/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.core.parser;

import com.luues.jdbc.plus.annotation.SqlParser;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SqlParserHelper {
    public static final String DELEGATE_MAPPED_STATEMENT = "delegate.mappedStatement";
    private static final Map<String, Boolean> SQL_PARSER_INFO_CACHE = new ConcurrentHashMap<String, Boolean>();

    public static synchronized void initSqlParserInfoCache(Class<?> mapperClass) {
        SqlParser sqlParser = mapperClass.getAnnotation(SqlParser.class);
        if (sqlParser != null) {
            SQL_PARSER_INFO_CACHE.put(mapperClass.getName(), sqlParser.filter());
        }
    }

    public static void initSqlParserInfoCache(String mapperClassName, Method method) {
        SqlParser sqlParser = method.getAnnotation(SqlParser.class);
        if (sqlParser != null) {
            if (SQL_PARSER_INFO_CACHE.containsKey(mapperClassName)) {
                Boolean value = SQL_PARSER_INFO_CACHE.get(mapperClassName);
                if (!value.equals(sqlParser.filter())) {
                    String sid = mapperClassName + "." + method.getName();
                    SQL_PARSER_INFO_CACHE.putIfAbsent(sid, sqlParser.filter());
                }
            } else {
                String sid = mapperClassName + "." + method.getName();
                SQL_PARSER_INFO_CACHE.putIfAbsent(sid, sqlParser.filter());
            }
        }
    }
}

