/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.core.metadata;

import com.luues.jdbc.plus.annotation.FieldUnderLine;
import com.luues.jdbc.plus.annotation.IdType;
import com.luues.jdbc.plus.annotation.KeySequence;
import com.luues.jdbc.plus.annotation.TableField;
import com.luues.jdbc.plus.annotation.TableId;
import com.luues.jdbc.plus.annotation.TableName;
import com.luues.jdbc.plus.core.config.GlobalConfig;
import com.luues.jdbc.plus.core.metadata.TableFieldInfo;
import com.luues.jdbc.plus.core.metadata.TableInfo;
import com.luues.jdbc.plus.core.toolkit.Assert;
import com.luues.jdbc.plus.core.toolkit.ClassUtils;
import com.luues.jdbc.plus.core.toolkit.ExceptionUtils;
import com.luues.jdbc.plus.core.toolkit.GlobalConfigUtils;
import com.luues.jdbc.plus.core.toolkit.LambdaUtils;
import com.luues.jdbc.plus.core.toolkit.ReflectionKit;
import com.luues.jdbc.plus.core.toolkit.StringUtils;
import com.luues.jdbc.plus.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.luues.jdbc.plus.dynamic.datasource.spring.boot.autoconfigure.SingleDynamicDataSourceProperties;
import com.luues.util.TypeConvert;
import com.luues.util.logs.LogUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class TableInfoHelper {
    private static FieldUnderLine fieldUnderline = null;
    private static SingleDynamicDataSourceProperties singleDynamicDataSourceProperties;
    private static DynamicDataSourceProperties dynamicDataSourceProperties;
    private static final Map<Class<?>, TableInfo> TABLE_INFO_CACHE;
    private static final String DEFAULT_ID_NAME = "id";

    public static void setSingleDynamicDataSourceProperties(SingleDynamicDataSourceProperties singleDynamicDataSourceProperties_) {
        if (null == singleDynamicDataSourceProperties) {
            singleDynamicDataSourceProperties = singleDynamicDataSourceProperties_;
        }
    }

    public static void setDynamicDataSourceProperties(DynamicDataSourceProperties dynamicDataSourceProperties_) {
        if (null == dynamicDataSourceProperties) {
            dynamicDataSourceProperties = dynamicDataSourceProperties_;
        }
    }

    public static TableInfo getTableInfo(Class<?> clazz) {
        if (clazz == null || ReflectionKit.isPrimitiveOrWrapper(clazz) || clazz == String.class) {
            return null;
        }
        TableInfo tableInfo = TABLE_INFO_CACHE.get(ClassUtils.getUserClass(clazz));
        if (null != tableInfo) {
            return tableInfo;
        }
        for (Class<?> currentClass = clazz; null == tableInfo && Object.class != currentClass; currentClass = currentClass.getSuperclass()) {
            tableInfo = TABLE_INFO_CACHE.get(ClassUtils.getUserClass(currentClass));
        }
        if (tableInfo != null) {
            TABLE_INFO_CACHE.put(ClassUtils.getUserClass(clazz), tableInfo);
        }
        return tableInfo;
    }

    public static List<TableInfo> getTableInfos() {
        return new ArrayList<TableInfo>(TABLE_INFO_CACHE.values());
    }

    public static TableInfo initTableInfo(Class<?> clazz) {
        TableInfo tableInfo = TABLE_INFO_CACHE.get(clazz);
        if (tableInfo != null) {
            return tableInfo;
        }
        tableInfo = new TableInfo(clazz);
        GlobalConfig globalConfig = GlobalConfigUtils.defaults();
        String[] excludeProperty = TableInfoHelper.initTableName(clazz, globalConfig, tableInfo);
        List<String> excludePropertyList = excludeProperty != null && excludeProperty.length > 0 ? Arrays.asList(excludeProperty) : Collections.emptyList();
        TableInfoHelper.initTableFields(clazz, globalConfig, tableInfo, excludePropertyList);
        TABLE_INFO_CACHE.put(clazz, tableInfo);
        LambdaUtils.installCache(tableInfo);
        return tableInfo;
    }

    private static String[] initTableName(Class<?> clazz, GlobalConfig globalConfig, TableInfo tableInfo) {
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        TableName table = clazz.getAnnotation(TableName.class);
        String tableName = clazz.getSimpleName();
        String tablePrefix = dbConfig.getTablePrefix();
        String schema = dbConfig.getSchema();
        boolean tablePrefixEffect = true;
        String[] excludeProperty = null;
        if (table != null) {
            if (StringUtils.isNotBlank(table.value())) {
                tableName = table.value();
                if (StringUtils.isNotBlank(tablePrefix) && !table.keepGlobalPrefix()) {
                    tablePrefixEffect = false;
                }
            } else {
                tableName = TableInfoHelper.initTableNameWithDbConfig(tableName, dbConfig);
            }
            if (StringUtils.isNotBlank(table.schema())) {
                schema = table.schema();
            }
            if (StringUtils.isNotBlank(table.resultMap())) {
                tableInfo.setResultMap(table.resultMap());
            }
            tableInfo.setFieldUnderLine(table.fieldUnderLine());
            tableInfo.setAutoInitResultMap(table.autoResultMap());
            excludeProperty = table.excludeProperty();
        } else {
            tableName = TableInfoHelper.initTableNameWithDbConfig(tableName, dbConfig);
        }
        String targetTableName = tableName;
        if (StringUtils.isNotBlank(tablePrefix) && tablePrefixEffect) {
            targetTableName = tablePrefix + targetTableName;
        }
        if (StringUtils.isNotBlank(schema)) {
            targetTableName = schema + "." + targetTableName;
        }
        tableInfo.setTableName(targetTableName);
        if (null != dbConfig.getKeyGenerator()) {
            tableInfo.setKeySequence(clazz.getAnnotation(KeySequence.class));
        }
        return excludeProperty;
    }

    private static String initTableNameWithDbConfig(String className, GlobalConfig.DbConfig dbConfig) {
        String tableName = className;
        if (dbConfig.isTableUnderline()) {
            tableName = StringUtils.camelToUnderline(tableName);
        }
        tableName = dbConfig.isCapitalMode() ? tableName.toUpperCase() : StringUtils.firstToLowerCase(tableName);
        return tableName;
    }

    public static void initTableFields(Class<?> clazz, GlobalConfig globalConfig, TableInfo tableInfo, List<String> excludeProperty) {
        fieldUnderline = FieldUnderLine.AUTO;
        if (null != singleDynamicDataSourceProperties.getFieldUnderline()) {
            fieldUnderline = singleDynamicDataSourceProperties.getFieldUnderline() != false ? FieldUnderLine.YES : FieldUnderLine.NO;
        }
        if (null != dynamicDataSourceProperties.getFieldUnderline()) {
            fieldUnderline = dynamicDataSourceProperties.getFieldUnderline() != false ? FieldUnderLine.YES : FieldUnderLine.NO;
        }
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        List<Field> list = TableInfoHelper.getAllFields(clazz);
        List<Method> methods = Arrays.asList(clazz.getDeclaredMethods());
        boolean isReadPK = false;
        boolean existTableId = TableInfoHelper.isExistTableId(list);
        ArrayList<TableFieldInfo> fieldList = new ArrayList<TableFieldInfo>(list.size());
        for (Field field : list) {
            tableInfo.addFieldType(field.getName(), field.getType());
            String fieldName = TypeConvert.upperCase((String)field.getName());
            String getMethodName = "get" + fieldName;
            String setMethodName = "set" + fieldName;
            Method getMethod = null;
            Method setMethod = null;
            for (Method method : methods) {
                if (getMethodName.equals(method.getName())) {
                    getMethod = method;
                }
                if (setMethodName.equals(method.getName())) {
                    setMethod = method;
                }
                if (null == getMethod || null == setMethod) continue;
                break;
            }
            if (null == getMethod) {
                LogUtil.warn((String)String.format("The get method corresponding to this property cannot be found, entity:{}, field:{}, method:{}", clazz.getName(), field.getName(), getMethodName));
            } else if (null == setMethod) {
                LogUtil.warn((String)String.format("The set method corresponding to this property cannot be found, entity:{}, field:{}, method:{}", clazz.getName(), field.getName(), setMethodName));
            } else {
                tableInfo.addFieldGetMethod(field.getName(), getMethod);
                tableInfo.addFieldSetMethod(field.getName(), setMethod);
            }
            if (excludeProperty.contains(field.getName())) continue;
            if (existTableId) {
                TableId tableId = field.getAnnotation(TableId.class);
                if (tableId != null) {
                    if (isReadPK) {
                        throw ExceptionUtils.mpe("@TableId can't more than one in Class: \"%s\".", clazz.getName());
                    }
                    isReadPK = TableInfoHelper.initTableIdWithAnnotation(dbConfig, tableInfo, field, tableId);
                    continue;
                }
            } else if (!isReadPK && (isReadPK = TableInfoHelper.initTableIdWithoutAnnotation(dbConfig, tableInfo, field))) continue;
            if (TableInfoHelper.initTableFieldWithAnnotation(dbConfig, tableInfo, fieldList, field)) continue;
            fieldList.add(new TableFieldInfo(dbConfig, tableInfo, field, fieldUnderline));
        }
        Assert.isTrue(fieldList.parallelStream().filter(TableFieldInfo::isLogicDelete).count() < 2L, String.format("@TableLogic can't more than one in Class: \"%s\".", clazz.getName()), new Object[0]);
        tableInfo.setFieldList(Collections.unmodifiableList(fieldList));
        if (!isReadPK) {
            LogUtil.warn((String)String.format("Can not find table primary key in Class: \"%s\".", clazz.getName()));
        }
    }

    public static boolean isExistTableId(List<Field> list) {
        return list.stream().anyMatch(field -> field.isAnnotationPresent(TableId.class));
    }

    private static boolean initTableIdWithAnnotation(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, TableId tableId) {
        boolean underCamel = tableInfo.isUnderCamel();
        String property = field.getName();
        if (field.getAnnotation(TableField.class) != null) {
            LogUtil.warn((String)String.format("This \"%s\" is the table primary key by @TableId annotation in Class: \"%s\",So @TableField annotation will not work!", property, tableInfo.getEntityType().getName()));
        }
        if (IdType.NONE == tableId.type()) {
            tableInfo.setIdType(dbConfig.getIdType());
        } else {
            tableInfo.setIdType(tableId.type());
        }
        String column = property;
        if (StringUtils.isNotBlank(tableId.value())) {
            column = tableId.value();
        } else {
            if (underCamel) {
                column = StringUtils.camelToUnderline(column);
            }
            if (dbConfig.isCapitalMode()) {
                column = column.toUpperCase();
            }
            if (tableInfo.getFieldUnderLine().getKey() == FieldUnderLine.YES.getKey()) {
                column = StringUtils.humpToLine(column);
            } else if (tableInfo.getFieldUnderLine().getKey() == FieldUnderLine.AUTO.getKey()) {
                if (fieldUnderline.getKey() == FieldUnderLine.YES.getKey()) {
                    column = StringUtils.humpToLine(column);
                } else if (fieldUnderline.getKey() == FieldUnderLine.AUTO.getKey() && dbConfig.isFieldUnderline()) {
                    column = StringUtils.humpToLine(column);
                }
            }
        }
        tableInfo.setKeyRelated(TableInfoHelper.checkRelated(underCamel, property, column)).setKeyColumn(column).setKeyProperty(property);
        return true;
    }

    private static boolean initTableIdWithoutAnnotation(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field) {
        String property = field.getName();
        if (DEFAULT_ID_NAME.equalsIgnoreCase(property)) {
            if (field.getAnnotation(TableField.class) != null) {
                LogUtil.warn((String)String.format("This \"%s\" is the table primary key by default name for `id` in Class: \"%s\",So @TableField will not work!", property, tableInfo.getEntityType().getName()));
            }
            String column = property;
            if (dbConfig.isCapitalMode()) {
                column = column.toUpperCase();
            }
            tableInfo.setKeyRelated(TableInfoHelper.checkRelated(tableInfo.isUnderCamel(), property, column)).setIdType(dbConfig.getIdType()).setKeyColumn(column).setKeyProperty(property);
            return true;
        }
        return false;
    }

    private static boolean initTableFieldWithAnnotation(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, List<TableFieldInfo> fieldList, Field field) {
        TableField tableField = field.getAnnotation(TableField.class);
        if (null == tableField) {
            return false;
        }
        fieldList.add(new TableFieldInfo(dbConfig, tableInfo, field, tableField));
        return true;
    }

    public static boolean checkRelated(boolean underCamel, String property, String column) {
        if (StringUtils.isNotColumnName(column)) {
            column = column.substring(1, column.length() - 1);
        }
        String propertyUpper = property.toUpperCase(Locale.ENGLISH);
        String columnUpper = column.toUpperCase(Locale.ENGLISH);
        if (underCamel) {
            return !propertyUpper.equals(columnUpper) && !propertyUpper.equals(columnUpper.replace("_", ""));
        }
        return !propertyUpper.equals(columnUpper);
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        List<Field> fieldList = ReflectionKit.getFieldList(ClassUtils.getUserClass(clazz));
        return fieldList.stream().filter(field -> {
            TableField tableField = field.getAnnotation(TableField.class);
            return tableField == null || tableField.exist();
        }).collect(Collectors.toList());
    }

    static {
        TABLE_INFO_CACHE = new ConcurrentHashMap();
    }
}

