/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.core.metadata;

import com.luues.jdbc.plus.annotation.FieldUnderLine;
import com.luues.jdbc.plus.annotation.IdType;
import com.luues.jdbc.plus.annotation.KeySequence;
import com.luues.jdbc.plus.core.metadata.TableFieldInfo;
import com.luues.jdbc.plus.core.toolkit.Constants;
import com.luues.jdbc.plus.core.toolkit.ExceptionUtils;
import com.luues.jdbc.plus.core.toolkit.StringUtils;
import com.luues.jdbc.plus.core.toolkit.sql.SqlScriptUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TableInfo
implements Constants {
    private Class<?> entityType;
    private IdType idType = IdType.NONE;
    private String tableName;
    private String resultMap;
    private boolean autoInitResultMap;
    private boolean initResultMap;
    private boolean keyRelated;
    private String keyColumn;
    private String keyProperty;
    private Class<?> keyType;
    private KeySequence keySequence;
    private List<TableFieldInfo> fieldList;
    private Map<String, Method> fieldGetMethod;
    private Map<String, Method> fieldSetMethod;
    private Map<String, Class<?>> fieldType;
    private String currentNamespace;
    private FieldUnderLine fieldUnderLine;
    private boolean logicDelete;
    private boolean underCamel;
    private String allSqlSelect;
    private String sqlSelect;
    private boolean withInsertFill;
    private boolean withUpdateFill;
    private boolean withVersion;
    private TableFieldInfo versionFieldInfo;

    public TableInfo(Class<?> entityType) {
        this.entityType = entityType;
    }

    public String getSqlStatement(String sqlMethod) {
        return this.currentNamespace + "." + sqlMethod;
    }

    public boolean havePK() {
        return StringUtils.isNotBlank(this.keyColumn);
    }

    public String getKeySqlSelect() {
        if (this.sqlSelect != null) {
            return this.sqlSelect;
        }
        if (this.havePK()) {
            this.sqlSelect = this.keyColumn;
            if (this.keyRelated) {
                this.sqlSelect = this.sqlSelect + " AS " + this.keyProperty;
            }
        } else {
            this.sqlSelect = "";
        }
        return this.sqlSelect;
    }

    public String getAllSqlSelect() {
        if (this.allSqlSelect != null) {
            return this.allSqlSelect;
        }
        this.allSqlSelect = this.chooseSelect(TableFieldInfo::isSelect);
        return this.allSqlSelect;
    }

    public String chooseSelect(Predicate<TableFieldInfo> predicate) {
        String sqlSelect = this.getKeySqlSelect();
        String fieldsSqlSelect = this.fieldList.stream().filter(predicate).map(TableFieldInfo::getSqlSelect).collect(Collectors.joining(","));
        if (StringUtils.isNotBlank(sqlSelect) && StringUtils.isNotBlank(fieldsSqlSelect)) {
            return sqlSelect + "," + fieldsSqlSelect;
        }
        if (StringUtils.isNotBlank(fieldsSqlSelect)) {
            return fieldsSqlSelect;
        }
        return sqlSelect;
    }

    public String getKeyInsertSqlProperty(String prefix, boolean newLine) {
        String newPrefix;
        String string = newPrefix = prefix == null ? "" : prefix;
        if (this.havePK()) {
            if (this.idType == IdType.AUTO) {
                return "";
            }
            return SqlScriptUtils.safeParam(newPrefix + this.keyProperty) + "," + (newLine ? "\n" : "");
        }
        return "";
    }

    public String getKeyInsertSqlColumn(boolean newLine) {
        if (this.havePK()) {
            if (this.idType == IdType.AUTO) {
                return "";
            }
            return this.keyColumn + "," + (newLine ? "\n" : "");
        }
        return "";
    }

    public String getAllInsertSqlPropertyMaybeIf(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        return this.getKeyInsertSqlProperty(newPrefix, true) + this.fieldList.stream().map(i -> i.getInsertSqlPropertyMaybeIf(newPrefix)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }

    public String getAllInsertSqlColumnMaybeIf() {
        return this.getKeyInsertSqlColumn(true) + this.fieldList.stream().map(TableFieldInfo::getInsertSqlColumnMaybeIf).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }

    public String getAllSqlWhere(boolean ignoreLogicDelFiled, boolean withId, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String filedSqlScript = this.fieldList.stream().filter(i -> {
            if (ignoreLogicDelFiled) {
                return !this.isLogicDelete() || !i.isLogicDelete();
            }
            return true;
        }).map(i -> i.getSqlWhere(newPrefix)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        if (!withId || StringUtils.isBlank(this.keyProperty)) {
            return filedSqlScript;
        }
        String newKeyProperty = newPrefix + this.keyProperty;
        String keySqlScript = this.keyColumn + "=" + SqlScriptUtils.safeParam(newKeyProperty);
        return SqlScriptUtils.convertIf(keySqlScript, String.format("%s != null", newKeyProperty), false) + "\n" + filedSqlScript;
    }

    public String getAllSqlSet(boolean ignoreLogicDelFiled, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        return this.fieldList.stream().filter(i -> {
            if (ignoreLogicDelFiled) {
                return !this.isLogicDelete() || !i.isLogicDelete();
            }
            return true;
        }).map(i -> i.getSqlSet(newPrefix)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }

    public String getLogicDeleteSql(boolean startWithAnd, boolean isWhere) {
        if (this.logicDelete) {
            TableFieldInfo field = this.fieldList.stream().filter(TableFieldInfo::isLogicDelete).findFirst().orElseThrow(() -> ExceptionUtils.mpe("can't find the logicFiled from table {%s}", this.tableName));
            String logicDeleteSql = this.formatLogicDeleteSql(field, isWhere);
            if (startWithAnd) {
                logicDeleteSql = " AND " + logicDeleteSql;
            }
            return logicDeleteSql;
        }
        return "";
    }

    private String formatLogicDeleteSql(TableFieldInfo field, boolean isWhere) {
        String value;
        String string = value = isWhere ? field.getLogicNotDeleteValue() : field.getLogicDeleteValue();
        if (isWhere) {
            if ("null".equalsIgnoreCase(value)) {
                return field.getColumn() + " IS NULL";
            }
            return field.getColumn() + "=" + String.format(field.isCharSequence() ? "'%s'" : "%s", value);
        }
        String targetStr = field.getColumn() + "=";
        if ("null".equalsIgnoreCase(value)) {
            return targetStr + "null";
        }
        return targetStr + String.format(field.isCharSequence() ? "'%s'" : "%s", value);
    }

    void setFieldList(List<TableFieldInfo> fieldList) {
        this.fieldList = fieldList;
        fieldList.forEach(i -> {
            if (i.isLogicDelete()) {
                this.logicDelete = true;
            }
            if (i.isWithInsertFill()) {
                this.withInsertFill = true;
            }
            if (i.isWithUpdateFill()) {
                this.withUpdateFill = true;
            }
            if (i.isVersion()) {
                this.withVersion = true;
                this.versionFieldInfo = i;
            }
        });
    }

    void addFieldGetMethod(String field, Method method) {
        if (null == this.fieldGetMethod) {
            this.fieldGetMethod = new HashMap<String, Method>();
        }
        this.fieldGetMethod.put(field, method);
    }

    void addFieldSetMethod(String field, Method method) {
        if (null == this.fieldSetMethod) {
            this.fieldSetMethod = new HashMap<String, Method>();
        }
        this.fieldSetMethod.put(field, method);
    }

    void addFieldType(String field, Class<?> type) {
        if (null == this.fieldType) {
            this.fieldType = new HashMap();
        }
        this.fieldType.put(field, type);
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getResultMap() {
        return this.resultMap;
    }

    public boolean isAutoInitResultMap() {
        return this.autoInitResultMap;
    }

    public boolean isInitResultMap() {
        return this.initResultMap;
    }

    public boolean isKeyRelated() {
        return this.keyRelated;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getKeyProperty() {
        return this.keyProperty;
    }

    public Class<?> getKeyType() {
        return this.keyType;
    }

    public KeySequence getKeySequence() {
        return this.keySequence;
    }

    public List<TableFieldInfo> getFieldList() {
        return this.fieldList;
    }

    public Map<String, Method> getFieldGetMethod() {
        return this.fieldGetMethod;
    }

    public Map<String, Method> getFieldSetMethod() {
        return this.fieldSetMethod;
    }

    public Map<String, Class<?>> getFieldType() {
        return this.fieldType;
    }

    public String getCurrentNamespace() {
        return this.currentNamespace;
    }

    public FieldUnderLine getFieldUnderLine() {
        return this.fieldUnderLine;
    }

    public boolean isLogicDelete() {
        return this.logicDelete;
    }

    public boolean isUnderCamel() {
        return this.underCamel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableInfo)) {
            return false;
        }
        TableInfo other = (TableInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$entityType = this.getEntityType();
        Class<?> other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        IdType this$idType = this.getIdType();
        IdType other$idType = other.getIdType();
        if (this$idType == null ? other$idType != null : !((Object)((Object)this$idType)).equals((Object)other$idType)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$resultMap = this.getResultMap();
        String other$resultMap = other.getResultMap();
        if (this$resultMap == null ? other$resultMap != null : !this$resultMap.equals(other$resultMap)) {
            return false;
        }
        if (this.isAutoInitResultMap() != other.isAutoInitResultMap()) {
            return false;
        }
        if (this.isInitResultMap() != other.isInitResultMap()) {
            return false;
        }
        if (this.isKeyRelated() != other.isKeyRelated()) {
            return false;
        }
        String this$keyColumn = this.getKeyColumn();
        String other$keyColumn = other.getKeyColumn();
        if (this$keyColumn == null ? other$keyColumn != null : !this$keyColumn.equals(other$keyColumn)) {
            return false;
        }
        String this$keyProperty = this.getKeyProperty();
        String other$keyProperty = other.getKeyProperty();
        if (this$keyProperty == null ? other$keyProperty != null : !this$keyProperty.equals(other$keyProperty)) {
            return false;
        }
        Class<?> this$keyType = this.getKeyType();
        Class<?> other$keyType = other.getKeyType();
        if (this$keyType == null ? other$keyType != null : !this$keyType.equals(other$keyType)) {
            return false;
        }
        KeySequence this$keySequence = this.getKeySequence();
        KeySequence other$keySequence = other.getKeySequence();
        if (this$keySequence == null ? other$keySequence != null : !this$keySequence.equals(other$keySequence)) {
            return false;
        }
        List<TableFieldInfo> this$fieldList = this.getFieldList();
        List<TableFieldInfo> other$fieldList = other.getFieldList();
        if (this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList)) {
            return false;
        }
        Map<String, Method> this$fieldGetMethod = this.getFieldGetMethod();
        Map<String, Method> other$fieldGetMethod = other.getFieldGetMethod();
        if (this$fieldGetMethod == null ? other$fieldGetMethod != null : !((Object)this$fieldGetMethod).equals(other$fieldGetMethod)) {
            return false;
        }
        Map<String, Method> this$fieldSetMethod = this.getFieldSetMethod();
        Map<String, Method> other$fieldSetMethod = other.getFieldSetMethod();
        if (this$fieldSetMethod == null ? other$fieldSetMethod != null : !((Object)this$fieldSetMethod).equals(other$fieldSetMethod)) {
            return false;
        }
        Map<String, Class<?>> this$fieldType = this.getFieldType();
        Map<String, Class<?>> other$fieldType = other.getFieldType();
        if (this$fieldType == null ? other$fieldType != null : !((Object)this$fieldType).equals(other$fieldType)) {
            return false;
        }
        String this$currentNamespace = this.getCurrentNamespace();
        String other$currentNamespace = other.getCurrentNamespace();
        if (this$currentNamespace == null ? other$currentNamespace != null : !this$currentNamespace.equals(other$currentNamespace)) {
            return false;
        }
        FieldUnderLine this$fieldUnderLine = this.getFieldUnderLine();
        FieldUnderLine other$fieldUnderLine = other.getFieldUnderLine();
        if (this$fieldUnderLine == null ? other$fieldUnderLine != null : !((Object)((Object)this$fieldUnderLine)).equals((Object)other$fieldUnderLine)) {
            return false;
        }
        if (this.isLogicDelete() != other.isLogicDelete()) {
            return false;
        }
        if (this.isUnderCamel() != other.isUnderCamel()) {
            return false;
        }
        String this$allSqlSelect = this.getAllSqlSelect();
        String other$allSqlSelect = other.getAllSqlSelect();
        if (this$allSqlSelect == null ? other$allSqlSelect != null : !this$allSqlSelect.equals(other$allSqlSelect)) {
            return false;
        }
        String this$sqlSelect = this.sqlSelect;
        String other$sqlSelect = other.sqlSelect;
        if (this$sqlSelect == null ? other$sqlSelect != null : !this$sqlSelect.equals(other$sqlSelect)) {
            return false;
        }
        if (this.isWithInsertFill() != other.isWithInsertFill()) {
            return false;
        }
        if (this.isWithUpdateFill() != other.isWithUpdateFill()) {
            return false;
        }
        if (this.isWithVersion() != other.isWithVersion()) {
            return false;
        }
        TableFieldInfo this$versionFieldInfo = this.getVersionFieldInfo();
        TableFieldInfo other$versionFieldInfo = other.getVersionFieldInfo();
        return !(this$versionFieldInfo == null ? other$versionFieldInfo != null : !((Object)this$versionFieldInfo).equals(other$versionFieldInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        IdType $idType = this.getIdType();
        result = result * 59 + ($idType == null ? 43 : ((Object)((Object)$idType)).hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $resultMap = this.getResultMap();
        result = result * 59 + ($resultMap == null ? 43 : $resultMap.hashCode());
        result = result * 59 + (this.isAutoInitResultMap() ? 79 : 97);
        result = result * 59 + (this.isInitResultMap() ? 79 : 97);
        result = result * 59 + (this.isKeyRelated() ? 79 : 97);
        String $keyColumn = this.getKeyColumn();
        result = result * 59 + ($keyColumn == null ? 43 : $keyColumn.hashCode());
        String $keyProperty = this.getKeyProperty();
        result = result * 59 + ($keyProperty == null ? 43 : $keyProperty.hashCode());
        Class<?> $keyType = this.getKeyType();
        result = result * 59 + ($keyType == null ? 43 : $keyType.hashCode());
        KeySequence $keySequence = this.getKeySequence();
        result = result * 59 + ($keySequence == null ? 43 : $keySequence.hashCode());
        List<TableFieldInfo> $fieldList = this.getFieldList();
        result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
        Map<String, Method> $fieldGetMethod = this.getFieldGetMethod();
        result = result * 59 + ($fieldGetMethod == null ? 43 : ((Object)$fieldGetMethod).hashCode());
        Map<String, Method> $fieldSetMethod = this.getFieldSetMethod();
        result = result * 59 + ($fieldSetMethod == null ? 43 : ((Object)$fieldSetMethod).hashCode());
        Map<String, Class<?>> $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : ((Object)$fieldType).hashCode());
        String $currentNamespace = this.getCurrentNamespace();
        result = result * 59 + ($currentNamespace == null ? 43 : $currentNamespace.hashCode());
        FieldUnderLine $fieldUnderLine = this.getFieldUnderLine();
        result = result * 59 + ($fieldUnderLine == null ? 43 : ((Object)((Object)$fieldUnderLine)).hashCode());
        result = result * 59 + (this.isLogicDelete() ? 79 : 97);
        result = result * 59 + (this.isUnderCamel() ? 79 : 97);
        String $allSqlSelect = this.getAllSqlSelect();
        result = result * 59 + ($allSqlSelect == null ? 43 : $allSqlSelect.hashCode());
        String $sqlSelect = this.sqlSelect;
        result = result * 59 + ($sqlSelect == null ? 43 : $sqlSelect.hashCode());
        result = result * 59 + (this.isWithInsertFill() ? 79 : 97);
        result = result * 59 + (this.isWithUpdateFill() ? 79 : 97);
        result = result * 59 + (this.isWithVersion() ? 79 : 97);
        TableFieldInfo $versionFieldInfo = this.getVersionFieldInfo();
        result = result * 59 + ($versionFieldInfo == null ? 43 : ((Object)$versionFieldInfo).hashCode());
        return result;
    }

    public String toString() {
        return "TableInfo(entityType=" + this.getEntityType() + ", idType=" + (Object)((Object)this.getIdType()) + ", tableName=" + this.getTableName() + ", resultMap=" + this.getResultMap() + ", autoInitResultMap=" + this.isAutoInitResultMap() + ", initResultMap=" + this.isInitResultMap() + ", keyRelated=" + this.isKeyRelated() + ", keyColumn=" + this.getKeyColumn() + ", keyProperty=" + this.getKeyProperty() + ", keyType=" + this.getKeyType() + ", keySequence=" + this.getKeySequence() + ", fieldList=" + this.getFieldList() + ", fieldGetMethod=" + this.getFieldGetMethod() + ", fieldSetMethod=" + this.getFieldSetMethod() + ", fieldType=" + this.getFieldType() + ", currentNamespace=" + this.getCurrentNamespace() + ", fieldUnderLine=" + (Object)((Object)this.getFieldUnderLine()) + ", logicDelete=" + this.isLogicDelete() + ", underCamel=" + this.isUnderCamel() + ", allSqlSelect=" + this.getAllSqlSelect() + ", sqlSelect=" + this.sqlSelect + ", withInsertFill=" + this.isWithInsertFill() + ", withUpdateFill=" + this.isWithUpdateFill() + ", withVersion=" + this.isWithVersion() + ", versionFieldInfo=" + this.getVersionFieldInfo() + ")";
    }

    TableInfo setEntityType(Class<?> entityType) {
        this.entityType = entityType;
        return this;
    }

    TableInfo setIdType(IdType idType) {
        this.idType = idType;
        return this;
    }

    TableInfo setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    TableInfo setResultMap(String resultMap) {
        this.resultMap = resultMap;
        return this;
    }

    TableInfo setAutoInitResultMap(boolean autoInitResultMap) {
        this.autoInitResultMap = autoInitResultMap;
        return this;
    }

    TableInfo setInitResultMap(boolean initResultMap) {
        this.initResultMap = initResultMap;
        return this;
    }

    TableInfo setKeyRelated(boolean keyRelated) {
        this.keyRelated = keyRelated;
        return this;
    }

    TableInfo setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
        return this;
    }

    TableInfo setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
        return this;
    }

    TableInfo setKeyType(Class<?> keyType) {
        this.keyType = keyType;
        return this;
    }

    TableInfo setKeySequence(KeySequence keySequence) {
        this.keySequence = keySequence;
        return this;
    }

    TableInfo setFieldGetMethod(Map<String, Method> fieldGetMethod) {
        this.fieldGetMethod = fieldGetMethod;
        return this;
    }

    TableInfo setFieldSetMethod(Map<String, Method> fieldSetMethod) {
        this.fieldSetMethod = fieldSetMethod;
        return this;
    }

    TableInfo setFieldType(Map<String, Class<?>> fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    TableInfo setCurrentNamespace(String currentNamespace) {
        this.currentNamespace = currentNamespace;
        return this;
    }

    TableInfo setFieldUnderLine(FieldUnderLine fieldUnderLine) {
        this.fieldUnderLine = fieldUnderLine;
        return this;
    }

    TableInfo setUnderCamel(boolean underCamel) {
        this.underCamel = underCamel;
        return this;
    }

    public boolean isWithInsertFill() {
        return this.withInsertFill;
    }

    public boolean isWithUpdateFill() {
        return this.withUpdateFill;
    }

    public boolean isWithVersion() {
        return this.withVersion;
    }

    public TableFieldInfo getVersionFieldInfo() {
        return this.versionFieldInfo;
    }
}

