/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.core.metadata;

import com.luues.jdbc.plus.annotation.FieldFill;
import com.luues.jdbc.plus.annotation.FieldStrategy;
import com.luues.jdbc.plus.annotation.FieldUnderLine;
import com.luues.jdbc.plus.annotation.TableField;
import com.luues.jdbc.plus.annotation.TableLogic;
import com.luues.jdbc.plus.annotation.Version;
import com.luues.jdbc.plus.core.config.GlobalConfig;
import com.luues.jdbc.plus.core.metadata.TableInfo;
import com.luues.jdbc.plus.core.toolkit.Constants;
import com.luues.jdbc.plus.core.toolkit.StringUtils;
import com.luues.jdbc.plus.core.toolkit.sql.SqlScriptUtils;
import java.lang.reflect.Field;
import java.util.Locale;

public class TableFieldInfo
implements Constants {
    private final Field field;
    private final String column;
    private final String property;
    private final String el;
    private final Class<?> propertyType;
    private final boolean isCharSequence;
    private final FieldStrategy insertStrategy;
    private final FieldStrategy updateStrategy;
    private final FieldStrategy whereStrategy;
    private boolean select = true;
    private boolean version;
    private String logicDeleteValue;
    private String logicNotDeleteValue;
    private String update;
    private String condition = "%s=#{%s}";
    private FieldFill fieldFill = FieldFill.DEFAULT;
    private boolean withInsertFill;
    private boolean withUpdateFill;
    private String sqlSelect;

    public TableFieldInfo(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, TableField tableField) {
        String columnFormat;
        field.setAccessible(true);
        this.field = field;
        this.version = field.getAnnotation(Version.class) != null;
        this.property = field.getName();
        this.propertyType = field.getType();
        this.isCharSequence = StringUtils.isCharSequence(this.propertyType);
        this.fieldFill = tableField.fill();
        this.withInsertFill = this.fieldFill == FieldFill.INSERT || this.fieldFill == FieldFill.INSERT_UPDATE;
        this.withUpdateFill = this.fieldFill == FieldFill.UPDATE || this.fieldFill == FieldFill.INSERT_UPDATE;
        this.update = tableField.update();
        String numericScale = tableField.numericScale();
        String el = this.property;
        if (StringUtils.isNotBlank(numericScale)) {
            el = el + ",numericScale=" + numericScale;
        }
        this.el = el;
        this.initLogicDelete(dbConfig, field);
        String column = tableField.value();
        if (StringUtils.isBlank(column)) {
            column = this.property;
            if (tableInfo.isUnderCamel()) {
                column = StringUtils.camelToUnderline(column);
            }
            if (dbConfig.isCapitalMode()) {
                column = column.toUpperCase();
            }
        }
        if (StringUtils.isNotBlank(columnFormat = dbConfig.getColumnFormat()) && tableField.keepGlobalFormat()) {
            column = String.format(columnFormat, column);
        }
        this.column = column;
        this.sqlSelect = column;
        if (TableFieldInfo.checkRelated(tableInfo.isUnderCamel(), this.property, this.column)) {
            String propertyFormat = dbConfig.getPropertyFormat();
            String asProperty = this.property;
            if (StringUtils.isNotBlank(propertyFormat)) {
                asProperty = String.format(propertyFormat, this.property);
            }
            this.sqlSelect = this.sqlSelect + " AS " + asProperty;
        }
        this.insertStrategy = this.chooseFieldStrategy(tableField.insertStrategy(), dbConfig.getInsertStrategy());
        this.updateStrategy = this.chooseFieldStrategy(tableField.updateStrategy(), dbConfig.getUpdateStrategy());
        this.whereStrategy = this.chooseFieldStrategy(tableField.whereStrategy(), dbConfig.getSelectStrategy());
        if (StringUtils.isNotBlank(tableField.condition())) {
            this.condition = tableField.condition();
        }
        this.select = tableField.select();
    }

    public static boolean checkRelated(boolean underCamel, String property, String column) {
        if (StringUtils.isNotColumnName(column)) {
            column = column.substring(1, column.length() - 1);
        }
        String propertyUpper = property.toUpperCase(Locale.ENGLISH);
        String columnUpper = column.toUpperCase(Locale.ENGLISH);
        if (underCamel) {
            return !propertyUpper.equals(columnUpper) && !propertyUpper.equals(columnUpper.replace("_", ""));
        }
        return !propertyUpper.equals(columnUpper);
    }

    private FieldStrategy chooseFieldStrategy(FieldStrategy fromAnnotation, FieldStrategy fromDbConfig) {
        return fromAnnotation == FieldStrategy.DEFAULT ? fromDbConfig : fromAnnotation;
    }

    public TableFieldInfo(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, FieldUnderLine fieldUnderline) {
        field.setAccessible(true);
        this.field = field;
        this.version = field.getAnnotation(Version.class) != null;
        this.property = field.getName();
        this.propertyType = field.getType();
        this.isCharSequence = StringUtils.isCharSequence(this.propertyType);
        this.el = this.property;
        this.insertStrategy = dbConfig.getInsertStrategy();
        this.updateStrategy = dbConfig.getUpdateStrategy();
        this.whereStrategy = dbConfig.getSelectStrategy();
        this.initLogicDelete(dbConfig, field);
        String column = field.getName();
        if (tableInfo.isUnderCamel()) {
            column = StringUtils.camelToUnderline(column);
        }
        if (dbConfig.isCapitalMode()) {
            column = column.toUpperCase();
        }
        if (tableInfo.getFieldUnderLine().getKey() == FieldUnderLine.YES.getKey()) {
            column = StringUtils.humpToLine(column);
        } else if (tableInfo.getFieldUnderLine().getKey() == FieldUnderLine.AUTO.getKey()) {
            if (fieldUnderline.getKey() == FieldUnderLine.YES.getKey()) {
                column = StringUtils.humpToLine(column);
            } else if (fieldUnderline.getKey() == FieldUnderLine.AUTO.getKey() && dbConfig.isFieldUnderline()) {
                column = StringUtils.humpToLine(column);
            }
        }
        String columnFormat = dbConfig.getColumnFormat();
        if (StringUtils.isNotBlank(columnFormat)) {
            column = String.format(columnFormat, column);
        }
        this.column = column;
        this.sqlSelect = column;
        if (!TableFieldInfo.checkRelated(tableInfo.isUnderCamel(), this.property, this.column)) {
            this.sqlSelect = column;
        } else {
            String propertyFormat = dbConfig.getPropertyFormat();
            String asProperty = this.property;
            if (StringUtils.isNotBlank(propertyFormat)) {
                asProperty = String.format(propertyFormat, this.property);
            }
            this.sqlSelect = this.sqlSelect + " AS " + asProperty;
        }
    }

    private void initLogicDelete(GlobalConfig.DbConfig dbConfig, Field field) {
        TableLogic tableLogic = field.getAnnotation(TableLogic.class);
        if (null != tableLogic) {
            this.logicNotDeleteValue = StringUtils.isNotBlank(tableLogic.value()) ? tableLogic.value() : dbConfig.getLogicNotDeleteValue();
            this.logicDeleteValue = StringUtils.isNotBlank(tableLogic.delval()) ? tableLogic.delval() : dbConfig.getLogicDeleteValue();
        } else {
            String globalLogicDeleteField = dbConfig.getLogicDeleteField();
            if (StringUtils.isNotBlank(globalLogicDeleteField) && globalLogicDeleteField.equalsIgnoreCase(field.getName())) {
                this.logicNotDeleteValue = dbConfig.getLogicNotDeleteValue();
                this.logicDeleteValue = dbConfig.getLogicDeleteValue();
            }
        }
    }

    public boolean isLogicDelete() {
        return StringUtils.isNotBlank(this.logicDeleteValue) && StringUtils.isNotBlank(this.logicNotDeleteValue);
    }

    public String getInsertSqlProperty(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        return SqlScriptUtils.safeParam(newPrefix + this.el) + ",";
    }

    public String getInsertSqlPropertyMaybeIf(String prefix) {
        String sqlScript = this.getInsertSqlProperty(prefix);
        if (this.withInsertFill) {
            return sqlScript;
        }
        return this.convertIf(sqlScript, this.property, this.insertStrategy);
    }

    public String getInsertSqlColumn() {
        return this.column + ",";
    }

    public String getInsertSqlColumnMaybeIf() {
        String sqlScript = this.getInsertSqlColumn();
        if (this.withInsertFill) {
            return sqlScript;
        }
        return this.convertIf(sqlScript, this.property, this.insertStrategy);
    }

    public String getSqlSet(String prefix) {
        return this.getSqlSet(false, prefix);
    }

    public String getSqlSet(boolean ignoreIf, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String sqlSet = this.column + "=";
        sqlSet = StringUtils.isNotBlank(this.update) ? sqlSet + String.format(this.update, this.column) : sqlSet + SqlScriptUtils.safeParam(newPrefix + this.el);
        sqlSet = sqlSet + ",";
        if (ignoreIf) {
            return sqlSet;
        }
        if (this.withUpdateFill) {
            return sqlSet;
        }
        return this.convertIf(sqlSet, this.convertIfProperty(prefix, this.property), this.updateStrategy);
    }

    private String convertIfProperty(String prefix, String property) {
        return StringUtils.isNotBlank(prefix) ? prefix.substring(0, prefix.length() - 1) + "['" + property + "']" : property;
    }

    public String getSqlWhere(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String sqlScript = " AND " + String.format(this.condition, this.column, newPrefix + this.el);
        return this.convertIf(sqlScript, this.convertIfProperty(newPrefix, this.property), this.whereStrategy);
    }

    public String getVersionOli(String alias, String prefix) {
        String oli = " AND " + this.column + "=" + SqlScriptUtils.safeParam("MP_OPTLOCK_VERSION_ORIGINAL");
        String ognlStr = this.convertIfProperty(prefix, this.property);
        if (this.isCharSequence) {
            return SqlScriptUtils.convertIf(oli, String.format("%s != null and %s != null and %s != ''", alias, ognlStr, ognlStr), false);
        }
        return SqlScriptUtils.convertIf(oli, String.format("%s != null and %s != null", alias, ognlStr), false);
    }

    private String convertIf(String sqlScript, String property, FieldStrategy fieldStrategy) {
        if (fieldStrategy == FieldStrategy.NEVER) {
            return null;
        }
        if (fieldStrategy == FieldStrategy.IGNORED) {
            return sqlScript;
        }
        if (fieldStrategy == FieldStrategy.NOT_EMPTY && this.isCharSequence) {
            return SqlScriptUtils.convertIf(sqlScript, String.format("%s != null and %s != ''", property, property), false);
        }
        return SqlScriptUtils.convertIf(sqlScript, String.format("%s != null", property), false);
    }

    public Field getField() {
        return this.field;
    }

    public String getColumn() {
        return this.column;
    }

    public String getProperty() {
        return this.property;
    }

    public String getEl() {
        return this.el;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public boolean isCharSequence() {
        return this.isCharSequence;
    }

    public FieldStrategy getInsertStrategy() {
        return this.insertStrategy;
    }

    public FieldStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public FieldStrategy getWhereStrategy() {
        return this.whereStrategy;
    }

    public boolean isSelect() {
        return this.select;
    }

    public boolean isVersion() {
        return this.version;
    }

    public String getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    public String getLogicNotDeleteValue() {
        return this.logicNotDeleteValue;
    }

    public String getUpdate() {
        return this.update;
    }

    public String getCondition() {
        return this.condition;
    }

    public FieldFill getFieldFill() {
        return this.fieldFill;
    }

    public boolean isWithInsertFill() {
        return this.withInsertFill;
    }

    public boolean isWithUpdateFill() {
        return this.withUpdateFill;
    }

    public String getSqlSelect() {
        return this.sqlSelect;
    }

    public String toString() {
        return "TableFieldInfo(field=" + this.getField() + ", column=" + this.getColumn() + ", property=" + this.getProperty() + ", el=" + this.getEl() + ", propertyType=" + this.getPropertyType() + ", isCharSequence=" + this.isCharSequence() + ", insertStrategy=" + (Object)((Object)this.getInsertStrategy()) + ", updateStrategy=" + (Object)((Object)this.getUpdateStrategy()) + ", whereStrategy=" + (Object)((Object)this.getWhereStrategy()) + ", select=" + this.isSelect() + ", version=" + this.isVersion() + ", logicDeleteValue=" + this.getLogicDeleteValue() + ", logicNotDeleteValue=" + this.getLogicNotDeleteValue() + ", update=" + this.getUpdate() + ", condition=" + this.getCondition() + ", fieldFill=" + (Object)((Object)this.getFieldFill()) + ", withInsertFill=" + this.isWithInsertFill() + ", withUpdateFill=" + this.isWithUpdateFill() + ", sqlSelect=" + this.getSqlSelect() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableFieldInfo)) {
            return false;
        }
        TableFieldInfo other = (TableFieldInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Field this$field = this.getField();
        Field other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        String this$el = this.getEl();
        String other$el = other.getEl();
        if (this$el == null ? other$el != null : !this$el.equals(other$el)) {
            return false;
        }
        Class<?> this$propertyType = this.getPropertyType();
        Class<?> other$propertyType = other.getPropertyType();
        if (this$propertyType == null ? other$propertyType != null : !this$propertyType.equals(other$propertyType)) {
            return false;
        }
        if (this.isCharSequence() != other.isCharSequence()) {
            return false;
        }
        FieldStrategy this$insertStrategy = this.getInsertStrategy();
        FieldStrategy other$insertStrategy = other.getInsertStrategy();
        if (this$insertStrategy == null ? other$insertStrategy != null : !((Object)((Object)this$insertStrategy)).equals((Object)other$insertStrategy)) {
            return false;
        }
        FieldStrategy this$updateStrategy = this.getUpdateStrategy();
        FieldStrategy other$updateStrategy = other.getUpdateStrategy();
        if (this$updateStrategy == null ? other$updateStrategy != null : !((Object)((Object)this$updateStrategy)).equals((Object)other$updateStrategy)) {
            return false;
        }
        FieldStrategy this$whereStrategy = this.getWhereStrategy();
        FieldStrategy other$whereStrategy = other.getWhereStrategy();
        if (this$whereStrategy == null ? other$whereStrategy != null : !((Object)((Object)this$whereStrategy)).equals((Object)other$whereStrategy)) {
            return false;
        }
        if (this.isSelect() != other.isSelect()) {
            return false;
        }
        if (this.isVersion() != other.isVersion()) {
            return false;
        }
        String this$logicDeleteValue = this.getLogicDeleteValue();
        String other$logicDeleteValue = other.getLogicDeleteValue();
        if (this$logicDeleteValue == null ? other$logicDeleteValue != null : !this$logicDeleteValue.equals(other$logicDeleteValue)) {
            return false;
        }
        String this$logicNotDeleteValue = this.getLogicNotDeleteValue();
        String other$logicNotDeleteValue = other.getLogicNotDeleteValue();
        if (this$logicNotDeleteValue == null ? other$logicNotDeleteValue != null : !this$logicNotDeleteValue.equals(other$logicNotDeleteValue)) {
            return false;
        }
        String this$update = this.getUpdate();
        String other$update = other.getUpdate();
        if (this$update == null ? other$update != null : !this$update.equals(other$update)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        FieldFill this$fieldFill = this.getFieldFill();
        FieldFill other$fieldFill = other.getFieldFill();
        if (this$fieldFill == null ? other$fieldFill != null : !((Object)((Object)this$fieldFill)).equals((Object)other$fieldFill)) {
            return false;
        }
        if (this.isWithInsertFill() != other.isWithInsertFill()) {
            return false;
        }
        if (this.isWithUpdateFill() != other.isWithUpdateFill()) {
            return false;
        }
        String this$sqlSelect = this.getSqlSelect();
        String other$sqlSelect = other.getSqlSelect();
        return !(this$sqlSelect == null ? other$sqlSelect != null : !this$sqlSelect.equals(other$sqlSelect));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableFieldInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Field $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        String $el = this.getEl();
        result = result * 59 + ($el == null ? 43 : $el.hashCode());
        Class<?> $propertyType = this.getPropertyType();
        result = result * 59 + ($propertyType == null ? 43 : $propertyType.hashCode());
        result = result * 59 + (this.isCharSequence() ? 79 : 97);
        FieldStrategy $insertStrategy = this.getInsertStrategy();
        result = result * 59 + ($insertStrategy == null ? 43 : ((Object)((Object)$insertStrategy)).hashCode());
        FieldStrategy $updateStrategy = this.getUpdateStrategy();
        result = result * 59 + ($updateStrategy == null ? 43 : ((Object)((Object)$updateStrategy)).hashCode());
        FieldStrategy $whereStrategy = this.getWhereStrategy();
        result = result * 59 + ($whereStrategy == null ? 43 : ((Object)((Object)$whereStrategy)).hashCode());
        result = result * 59 + (this.isSelect() ? 79 : 97);
        result = result * 59 + (this.isVersion() ? 79 : 97);
        String $logicDeleteValue = this.getLogicDeleteValue();
        result = result * 59 + ($logicDeleteValue == null ? 43 : $logicDeleteValue.hashCode());
        String $logicNotDeleteValue = this.getLogicNotDeleteValue();
        result = result * 59 + ($logicNotDeleteValue == null ? 43 : $logicNotDeleteValue.hashCode());
        String $update = this.getUpdate();
        result = result * 59 + ($update == null ? 43 : $update.hashCode());
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        FieldFill $fieldFill = this.getFieldFill();
        result = result * 59 + ($fieldFill == null ? 43 : ((Object)((Object)$fieldFill)).hashCode());
        result = result * 59 + (this.isWithInsertFill() ? 79 : 97);
        result = result * 59 + (this.isWithUpdateFill() ? 79 : 97);
        String $sqlSelect = this.getSqlSelect();
        result = result * 59 + ($sqlSelect == null ? 43 : $sqlSelect.hashCode());
        return result;
    }
}

