/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.core.jdbc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.luues.jdbc.plus.core.conditions.AbstractWrapper;
import com.luues.jdbc.plus.core.conditions.Wrapper;
import com.luues.jdbc.plus.core.enums.SqlStatementType;
import com.luues.jdbc.plus.core.jdbc.SqlInfo;
import com.luues.jdbc.plus.core.jdbc.SqlParser;
import com.luues.jdbc.plus.core.jdbc.util.IdUtil;
import com.luues.jdbc.plus.core.jdbc.util.SqlMethod;
import com.luues.jdbc.plus.core.metadata.IPage;
import com.luues.jdbc.plus.core.metadata.TableInfo;
import com.luues.jdbc.plus.core.metadata.TableInfoHelper;
import com.luues.jdbc.plus.core.toolkit.ExceptionUtils;
import com.luues.util.uuid.UniqueOrderGenerate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;

public class AbstractSqlParser<R>
implements SqlParser<R> {
    private UniqueOrderGenerate idWorker = new UniqueOrderGenerate(0L, 0L);

    @Override
    public <T> R getSelectListSqlInfo(boolean flag, Wrapper<T> wrapper) {
        return this.selectListParserByWrapper(SqlMethod.SELECT_LIST.getSql(), null, wrapper);
    }

    @Override
    public <T> R getSelectPageSqlInfo(boolean flag, IPage<T> iPage, Wrapper<T> wrapper) {
        return this.selectListParserByWrapper(SqlMethod.SELECT_PAGE.getSql(), iPage, wrapper);
    }

    @Override
    public <T> R getSelectOneSqlInfo(boolean flag, Wrapper<T> wrapper) {
        return this.selectListParserByWrapper(SqlMethod.SELECT_ONE.getSql(), null, wrapper);
    }

    @Override
    public <T> R getSelectOneSqlInfoById(boolean flag, T enetity) {
        return this.entityTransformationJson(SqlMethod.SELECT_ONE.getSql(), enetity, true);
    }

    @Override
    public <T> R getSelectCountSqlInfo(boolean flag, Wrapper<T> wrapper) {
        return this.selectCountParserByWrapper(SqlMethod.SELECT_COUNT.getSql(), null, wrapper);
    }

    @Override
    public <T> R getInsertSqlInfo(boolean flag, T entity) {
        return this.insertParserByEntity(SqlMethod.INSERT_ONE.getSql(), entity);
    }

    @Override
    public <T> R getUpdateSqlInfo(boolean flag, T entity) {
        return this.updateParserByEntity(SqlMethod.UPDATE.getSql(), entity);
    }

    @Override
    public <T> R getUpdateSqlInfo(boolean flag, Wrapper<T> wrapper) {
        return this.updateParserByWrapper(SqlMethod.UPDATE.getSql(), wrapper);
    }

    @Override
    public <T> R getUpdateSqlInfo(boolean flag, T entity, Wrapper<T> wrapper) {
        return this.updateParserByEntityAnWrapper(SqlMethod.UPDATE.getSql(), entity, wrapper);
    }

    @Override
    public <T> R getDeleteSqlInfo(boolean flag, T entity) {
        return this.deleteParserByEntity(SqlMethod.DELETE.getSql(), entity);
    }

    @Override
    public <T> R getDeleteSqlInfo(boolean flag, Wrapper<T> wrapper) {
        return this.deleteParserByWrapper(SqlMethod.DELETE.getSql(), wrapper);
    }

    @Override
    public <T> List<R> getBatchSaveSqlInfo(boolean flag, Collection<T> entitys) {
        return this.batchInsertParserByEntity(SqlMethod.INSERT_ONE.getSql(), entitys);
    }

    @Override
    public <T> List<R> getBatchUpdateSqlInfo(boolean flag, Collection<T> entitys) {
        return this.batchUpdateParserByEntity(SqlMethod.UPDATE.getSql(), entitys);
    }

    @Override
    public <T> R getCusSql(String sql, Object ... params) {
        return (R)new SqlInfo().setSql(sql).setSqlStatementType(sql.toUpperCase().contains(SqlStatementType.SELECT.name()) ? SqlStatementType.SELECT : (sql.toUpperCase().contains(SqlStatementType.UPDATE.name()) ? SqlStatementType.UPDATE : (sql.toUpperCase().contains(SqlStatementType.DELETE.name()) ? SqlStatementType.DELETE : (sql.toUpperCase().contains(SqlStatementType.INSERT.name()) ? SqlStatementType.INSERT : SqlStatementType.SELECT)))).setParams(Arrays.asList(params));
    }

    public <T> R selectListParserByWrapper(String selectSql, IPage<T> iPage, Wrapper<T> wrapper) {
        String sqlSelect = wrapper.getSqlSelect();
        selectSql = Strings.isEmpty((CharSequence)sqlSelect) ? selectSql.replaceFirst("%s", "*") : selectSql.replaceFirst("%s", sqlSelect);
        TableInfo tableInfo = TableInfoHelper.getTableInfo(wrapper.getEntityClass());
        selectSql = selectSql.replaceFirst("%s", tableInfo.getTableName());
        selectSql = wrapper.nonEmptyOfWhere() ? selectSql.replaceFirst("%s", "WHERE " + wrapper.getTargetSql()) + " " : selectSql.replaceFirst("%s", wrapper.getTargetSql());
        AbstractWrapper abstractWrapper = (AbstractWrapper)wrapper;
        Map<String, Object> map = abstractWrapper.getParamNameValuePairs();
        HashMap<Integer, Object> map1 = new HashMap<Integer, Object>();
        for (String key2 : map.keySet()) {
            map1.put(Integer.valueOf(key2.substring(8)), null == map.get(key2) ? "" : map.get(key2));
        }
        LinkedHashMap<String, Long> linkedHashMap = new LinkedHashMap<String, Long>();
        map1.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> linkedHashMap.put(((Integer)entry.getKey()).toString(), (Long)entry.getValue()));
        if (null != iPage) {
            selectSql = selectSql + "LIMIT ?, ?";
            linkedHashMap.put("%start%", (iPage.getCurrent() - 1L) * iPage.getSize());
            linkedHashMap.put("%size%", iPage.getSize());
        }
        return (R)new SqlInfo().setSql(selectSql).setParams(linkedHashMap.keySet().stream().map(key -> linkedHashMap.get(key)).collect(Collectors.toList())).setSqlStatementType(SqlStatementType.SELECT);
    }

    public <T> R selectCountParserByWrapper(String selectSql, IPage<T> iPage, Wrapper<T> wrapper) {
        selectSql = selectSql.replaceFirst("%s", "*");
        TableInfo tableInfo = TableInfoHelper.getTableInfo(wrapper.getEntityClass());
        selectSql = selectSql.replaceFirst("%s", tableInfo.getTableName());
        selectSql = wrapper.nonEmptyOfWhere() ? selectSql.replaceFirst("%s", "WHERE " + wrapper.getTargetSql()) + " " : selectSql.replaceFirst("%s", wrapper.getTargetSql());
        AbstractWrapper abstractWrapper = (AbstractWrapper)wrapper;
        Map<String, Object> map = abstractWrapper.getParamNameValuePairs();
        HashMap<Integer, Object> map1 = new HashMap<Integer, Object>();
        for (String key2 : map.keySet()) {
            map1.put(Integer.valueOf(key2.substring(8)), null == map.get(key2) ? "" : map.get(key2));
        }
        LinkedHashMap<String, Long> linkedHashMap = new LinkedHashMap<String, Long>();
        map1.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> linkedHashMap.put(((Integer)entry.getKey()).toString(), (Long)entry.getValue()));
        if (null != iPage) {
            selectSql = selectSql + "LIMIT ?, ?";
            linkedHashMap.put("%start%", (iPage.getCurrent() - 1L) * iPage.getSize());
            linkedHashMap.put("%size%", iPage.getSize());
        }
        return (R)new SqlInfo().setSql(selectSql).setParams(linkedHashMap.keySet().stream().map(key -> linkedHashMap.get(key)).collect(Collectors.toList())).setSqlStatementType(SqlStatementType.SELECT);
    }

    public <T> R insertParserByEntity(String insertSql, T entity) {
        return this.entityTransformationJson(insertSql, entity, true);
    }

    public <T> R updateParserByEntity(String updateSql, T entity) {
        return this.entityTransformationJson(updateSql, entity, true);
    }

    public <T> R deleteParserByEntity(String deleteSql, T entity) {
        return this.entityTransformationJson(deleteSql, entity, true);
    }

    public <T> R updateParserByWrapper(String updateSql, Wrapper<T> wrapper) {
        String sqlSet = wrapper.getSqlSet();
        TableInfo tableInfo = TableInfoHelper.getTableInfo(wrapper.getEntityClass());
        updateSql = updateSql.replaceFirst("%s", tableInfo.getTableName());
        if (Strings.isEmpty((CharSequence)sqlSet)) {
            throw ExceptionUtils.mpe("update Method requires set field to be set", new Object[0]);
        }
        sqlSet = sqlSet.replaceAll("=#\\{ew.paramNameValuePairs.MPGENVAL\\d{1,6}}", " = ?");
        updateSql = updateSql.replaceFirst("%s", "SET " + sqlSet);
        updateSql = wrapper.nonEmptyOfWhere() ? updateSql.replaceFirst("%s", "WHERE " + wrapper.getTargetSql()) : updateSql.replaceFirst("%s", wrapper.getTargetSql());
        Map<String, Object> map = ((AbstractWrapper)wrapper).getParamNameValuePairs();
        HashMap<Integer, Object> map1 = new HashMap<Integer, Object>();
        for (String key2 : map.keySet()) {
            map1.put(Integer.valueOf(key2.substring(8)), null == map.get(key2) ? "" : map.get(key2));
        }
        LinkedHashMap<String, Object> linkedMap = new LinkedHashMap<String, Object>();
        map1.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> linkedMap.put(((Integer)entry.getKey()).toString(), entry.getValue()));
        return (R)new SqlInfo().setSql(this.updateSql(linkedMap, updateSql)).setParams(linkedMap.keySet().stream().map(key -> linkedMap.get(key)).collect(Collectors.toList())).setSqlStatementType(SqlStatementType.UPDATE);
    }

    public <T> R deleteParserByWrapper(String deleteSql, Wrapper<T> wrapper) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(wrapper.getEntityClass());
        deleteSql = deleteSql.replaceFirst("%s", tableInfo.getTableName());
        deleteSql = wrapper.nonEmptyOfWhere() ? deleteSql.replaceFirst("%s", "WHERE " + wrapper.getTargetSql()) : deleteSql.replaceFirst("%s", wrapper.getTargetSql());
        Map<String, Object> map = ((AbstractWrapper)wrapper).getParamNameValuePairs();
        HashMap<Integer, Object> map1 = new HashMap<Integer, Object>();
        for (String key2 : map.keySet()) {
            map1.put(Integer.valueOf(key2.substring(8)), null == map.get(key2) ? "" : map.get(key2));
        }
        LinkedHashMap<String, Object> linkedMap = new LinkedHashMap<String, Object>();
        map1.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> linkedMap.put(((Integer)entry.getKey()).toString(), entry.getValue()));
        return (R)new SqlInfo().setSql(this.updateSql(linkedMap, deleteSql)).setParams(linkedMap.keySet().stream().map(key -> linkedMap.get(key)).collect(Collectors.toList())).setSqlStatementType(SqlStatementType.DELETE);
    }

    public <T> R updateParserByEntityAnWrapper(String updateSql, T entity, Wrapper<T> wrapper) {
        SqlInfo sqlInfo = new SqlInfo();
        if (null != entity) {
            sqlInfo = (SqlInfo)this.entityTransformationJson(updateSql, null == entity ? wrapper.getEntityClass() : entity, false);
            updateSql = sqlInfo.getSql();
        } else {
            sqlInfo.setTableInfo(TableInfoHelper.getTableInfo(wrapper.getEntityClass())).setParams(new ArrayList<Object>());
            updateSql = updateSql.replaceFirst("%s", TableInfoHelper.getTableInfo(wrapper.getEntityClass()).getTableName());
        }
        if (null == wrapper.getEntityClass()) {
            updateSql = updateSql.replaceFirst(" %s", "");
        } else {
            TableInfo tableInfo = TableInfoHelper.getTableInfo(wrapper.getEntityClass());
            if (!tableInfo.getTableName().equals(sqlInfo.getTableInfo().getTableName())) {
                throw ExceptionUtils.mpe("entity class inconsistency", new Object[0]);
            }
            String sqlSet = wrapper.getSqlSet();
            if (Strings.isNotEmpty((CharSequence)sqlSet)) {
                sqlSet = sqlSet.replaceAll("=#\\{ew.paramNameValuePairs.MPGENVAL\\d{1,6}}", " = ?");
                updateSql = updateSql.contains("SET") ? updateSql.replaceFirst(" %s", ", " + sqlSet + " %s") : updateSql.replaceFirst(" %s", " SET " + sqlSet);
            }
            updateSql = wrapper.nonEmptyOfWhere() ? updateSql.replaceFirst("%s", "WHERE " + wrapper.getTargetSql()) : updateSql.replaceFirst("%s", wrapper.getTargetSql());
            Map<String, Object> map = ((AbstractWrapper)wrapper).getParamNameValuePairs();
            HashMap<Integer, Object> map1 = new HashMap<Integer, Object>();
            for (String key2 : map.keySet()) {
                map1.put(Integer.valueOf(key2.substring(8)), null == map.get(key2) ? "" : map.get(key2));
            }
            LinkedHashMap<String, Object> linkedMap = new LinkedHashMap<String, Object>();
            map1.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> linkedMap.put(((Integer)entry.getKey()).toString(), entry.getValue()));
            updateSql = this.updateSql(linkedMap, updateSql);
            sqlInfo.getParams().addAll(linkedMap.keySet().stream().map(key -> linkedMap.get(key)).collect(Collectors.toList()));
        }
        return (R)new SqlInfo().setSql(updateSql).setParams(sqlInfo.getParams()).setSqlStatementType(SqlStatementType.UPDATE);
    }

    public <T> List<R> batchInsertParserByEntity(String insertSql, Collection<T> entitys) {
        SqlInfo sqlInfo;
        ArrayList<SqlInfo> sqlInfoList = new ArrayList<SqlInfo>();
        HashMap<Integer, String> sqlMap = new HashMap<Integer, String>();
        HashMap<Integer, ArrayList<Collection<Object>>> paramMap = new HashMap<Integer, ArrayList<Collection<Object>>>();
        for (T entity : entitys) {
            ArrayList<Collection<Object>> insertParamsList;
            sqlInfo = (SqlInfo)this.entityTransformationJson(insertSql, entity, true);
            String sql = (String)sqlMap.get(sqlInfo.getSql().hashCode());
            if (null == sql) {
                sqlMap.put(sqlInfo.getSql().hashCode(), sqlInfo.getSql());
                insertParamsList = new ArrayList<Collection<Object>>();
                insertParamsList.add(sqlInfo.getParams());
                paramMap.put(sqlInfo.getSql().hashCode(), insertParamsList);
                continue;
            }
            insertParamsList = (ArrayList<Collection<Object>>)paramMap.get(sqlInfo.getSql().hashCode());
            insertParamsList.add(sqlInfo.getParams());
            paramMap.put(sqlInfo.getSql().hashCode(), insertParamsList);
        }
        for (Integer key : paramMap.keySet()) {
            sqlInfo = new SqlInfo().setSql((String)sqlMap.get(key)).setParamsList((List)paramMap.get(key)).setSqlStatementType(SqlStatementType.BATCHINSERT);
            sqlInfoList.add(sqlInfo);
        }
        return sqlInfoList;
    }

    public <T> List<R> batchUpdateParserByEntity(String updateSql, Collection<T> entitys) {
        ArrayList<Collection<Object>> updateParamsList = new ArrayList<Collection<Object>>();
        Integer updateColum = null;
        String keyColum = null;
        String updateDbSql = null;
        ArrayList<SqlInfo> sqlInfoList = new ArrayList<SqlInfo>();
        for (T entity : entitys) {
            SqlInfo sqlInfo = (SqlInfo)this.entityTransformationJson(updateSql, entity, true);
            if (null == keyColum) {
                keyColum = sqlInfo.getKeyColum();
                updateDbSql = sqlInfo.getSql();
                updateColum = sqlInfo.getSqlColum().hashCode();
            }
            if (null != updateColum && updateColum.hashCode() != sqlInfo.getSqlColum().hashCode()) {
                sqlInfoList.add(new SqlInfo().setSql(updateDbSql).setParamsList(updateParamsList).setSqlStatementType(SqlStatementType.BATCHUPDATE));
                keyColum = null;
                updateParamsList = new ArrayList();
                updateParamsList.add(sqlInfo.getParams());
                continue;
            }
            updateParamsList.add(sqlInfo.getParams());
        }
        sqlInfoList.add(new SqlInfo().setSql(updateDbSql).setParamsList(updateParamsList).setSqlStatementType(SqlStatementType.BATCHUPDATE));
        return sqlInfoList;
    }

    protected <T> R entityTransformationJson(String sql, T entity, boolean key_) {
        JSONObject jsonObject;
        SqlInfo sqlInfo = new SqlInfo();
        sqlInfo.setSelfIncrement(false);
        try {
            jsonObject = JSON.parseObject((String)JSON.toJSONStringWithDateFormat(entity, (String)"yyyy-MM-dd HH:mm:ss.SSS", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        }
        catch (Exception e) {
            try {
                jsonObject = JSON.parseObject((String)JSON.toJSONStringWithDateFormat(entity, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
            }
            catch (Exception e1) {
                try {
                    jsonObject = JSON.parseObject((String)JSON.toJSONStringWithDateFormat(entity, (String)"yyyy-MM-dd HH:mm", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
                }
                catch (Exception e2) {
                    try {
                        jsonObject = JSON.parseObject((String)JSON.toJSONStringWithDateFormat(entity, (String)"yyyy-MM-dd HH", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
                    }
                    catch (Exception e3) {
                        try {
                            jsonObject = JSON.parseObject((String)JSON.toJSONStringWithDateFormat(entity, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
                        }
                        catch (Exception e4) {
                            throw ExceptionUtils.mpe("CLASS Transformation JSON FAIL !", new Object[0]);
                        }
                    }
                }
            }
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entity.getClass());
        JSONObject finalJsonObject = jsonObject;
        if (sql.startsWith(SqlStatementType.SELECT.name())) {
            Collection<Object> params = new ArrayList();
            if (key_) {
                if (null == finalJsonObject.get((Object)tableInfo.getKeyProperty())) {
                    throw ExceptionUtils.mpe("ID cannot be empty", new Object[0]);
                }
                sql = sql.replaceFirst("%s", "*");
                sql = sql.replaceFirst("%s", tableInfo.getTableName().toUpperCase());
                sql = sql.replaceFirst("%s", "WHERE " + tableInfo.getKeyColumn() + " = ?");
                params.add(finalJsonObject.get((Object)tableInfo.getKeySqlSelect()));
            } else {
                List whereColum = tableInfo.getFieldList().stream().filter(tableFieldInfo_ -> null != finalJsonObject.get((Object)tableFieldInfo_.getSqlSelect())).map(tableFieldInfo_ -> tableFieldInfo_.getSqlSelect()).collect(Collectors.toList());
                params = whereColum.stream().map(key -> finalJsonObject.get(key)).collect(Collectors.toList());
                sql = sql.replaceFirst("%s", "*");
                sql = sql.replaceFirst("%s", tableInfo.getTableName().toUpperCase());
                sql = sql.replaceFirst("%s", "WHERE " + String.join((CharSequence)"AND", whereColum.stream().map(colum -> colum + " = ? ").collect(Collectors.toList())));
            }
            sqlInfo.setSql(sql).setParams(params).setSqlStatementType(SqlStatementType.SELECT);
        } else if (sql.startsWith(SqlStatementType.INSERT.name())) {
            List<String> insertColum = tableInfo.getFieldList().stream().filter(tableFieldInfo_ -> null != finalJsonObject.get((Object)tableFieldInfo_.getProperty())).map(tableFieldInfo_ -> tableFieldInfo_.getColumn()).collect(Collectors.toList());
            List<Object> insertParams = tableInfo.getFieldList().stream().filter(tableFieldInfo_ -> null != finalJsonObject.get((Object)tableFieldInfo_.getProperty())).map(tableFieldInfo_ -> finalJsonObject.get((Object)tableFieldInfo_.getProperty())).collect(Collectors.toList());
            switch (tableInfo.getIdType()) {
                case ASSIGN_ID: {
                    if (null != finalJsonObject.get((Object)tableInfo.getKeyProperty())) {
                        insertColum.add(0, tableInfo.getKeyColumn());
                        insertParams.add(0, finalJsonObject.get((Object)tableInfo.getKeyProperty()));
                        break;
                    }
                    insertColum.add(0, tableInfo.getKeyColumn());
                    insertParams.add(0, this.idWorker.nextId());
                    sqlInfo.setKeyValue(insertParams.get(0));
                    break;
                }
                case ASSIGN_UUID: {
                    if (null != finalJsonObject.get((Object)tableInfo.getKeyProperty())) {
                        insertColum.add(0, tableInfo.getKeyColumn());
                        insertParams.add(0, finalJsonObject.get((Object)tableInfo.getKeyProperty()));
                        break;
                    }
                    insertColum.add(0, tableInfo.getKeyColumn());
                    insertParams.add(0, IdUtil.getUuid());
                    sqlInfo.setKeyValue(insertParams.get(0));
                    break;
                }
                case AUTO: {
                    sqlInfo.setSelfIncrement(true);
                    break;
                }
                case NONE: {
                    if (null == finalJsonObject.get((Object)tableInfo.getKeyProperty())) break;
                    insertColum.add(0, tableInfo.getKeyColumn());
                    insertParams.add(0, finalJsonObject.get((Object)tableInfo.getKeyProperty()));
                    break;
                }
                case INPUT: {
                    if (null == jsonObject.get((Object)tableInfo.getKeyProperty())) {
                        throw ExceptionUtils.mpe("{%s} Primary key {%s} Can't be empty, maybe you can set@IdType=ASSIGN_ID", entity.getClass().getName(), tableInfo.getKeyProperty());
                    }
                    insertColum.add(0, tableInfo.getKeyColumn());
                    insertParams.add(0, finalJsonObject.get((Object)tableInfo.getKeyProperty()));
                    break;
                }
                default: {
                    throw ExceptionUtils.mpe("\u672a\u77e5\u7684 @IdType", entity.getClass().getName(), tableInfo.getKeyProperty());
                }
            }
            sql = sql.replaceFirst("%s", tableInfo.getTableName().toUpperCase());
            sql = sql.replaceFirst("%s", String.join((CharSequence)",", insertColum));
            sql = sql.replaceFirst("%s", String.join((CharSequence)",", insertColum.stream().map(colum -> "?").collect(Collectors.toList())));
            sqlInfo.setSql(sql).setKeyColum(tableInfo.getKeyColumn()).setParams(insertParams).setTableInfo(tableInfo).setSqlColum(insertColum).setSqlStatementType(SqlStatementType.INSERT);
        } else if (sql.startsWith(SqlStatementType.UPDATE.name())) {
            if (key_) {
                if (null == jsonObject.get((Object)tableInfo.getKeyProperty())) {
                    throw ExceptionUtils.mpe("updateById Method needs to set the primary key ID as the condition", new Object[0]);
                }
                List<String> updateColum_ = tableInfo.getFieldList().stream().filter(tableFieldInfo_ -> null != finalJsonObject.get((Object)tableFieldInfo_.getProperty())).map(tableFieldInfo_ -> tableFieldInfo_.getColumn()).collect(Collectors.toList());
                List<Object> updateParams = tableInfo.getFieldList().stream().filter(tableFieldInfo_ -> null != finalJsonObject.get((Object)tableFieldInfo_.getProperty())).map(tableFieldInfo_ -> finalJsonObject.get((Object)tableFieldInfo_.getProperty())).collect(Collectors.toList());
                if (updateColum_.size() == 0) {
                    throw ExceptionUtils.mpe("Please set the property to be modified", new Object[0]);
                }
                updateParams.add(jsonObject.get((Object)tableInfo.getKeyProperty()));
                sql = sql.replaceFirst("%s", tableInfo.getTableName().toUpperCase());
                sql = sql.replaceFirst("%s", "SET " + updateColum_.stream().collect(Collectors.joining(" = ?, ")) + " = ?");
                sql = sql.replaceFirst("%s", "WHERE " + tableInfo.getKeyColumn() + " = ?");
                sqlInfo.setSql(sql).setKeyColum(tableInfo.getKeyColumn()).setParams(updateParams).setTableInfo(tableInfo).setSqlColum(updateColum_).setSqlStatementType(SqlStatementType.UPDATE);
            } else {
                List<String> updateColum_ = tableInfo.getFieldList().stream().filter(tableFieldInfo_ -> null != finalJsonObject.get((Object)tableFieldInfo_.getProperty())).map(tableFieldInfo_ -> tableFieldInfo_.getColumn()).collect(Collectors.toList());
                List<Object> updateParams = tableInfo.getFieldList().stream().filter(tableFieldInfo_ -> null != finalJsonObject.get((Object)tableFieldInfo_.getProperty())).map(tableFieldInfo_ -> finalJsonObject.get((Object)tableFieldInfo_.getProperty())).collect(Collectors.toList());
                if (updateColum_.size() == 0) {
                    throw ExceptionUtils.mpe("Please set the property to be modified", new Object[0]);
                }
                sql = sql.replaceFirst("%s", tableInfo.getTableName().toUpperCase());
                sql = sql.replaceFirst("%s", "SET " + updateColum_.stream().collect(Collectors.joining(" = ?, ")) + " = ?");
                sqlInfo.setSql(sql).setParams(updateParams).setTableInfo(tableInfo).setSqlColum(updateColum_).setSqlStatementType(SqlStatementType.UPDATE);
            }
        } else if (sql.startsWith(SqlStatementType.DELETE.name())) {
            List whereColum = tableInfo.getFieldList().stream().filter(tableFieldInfo_ -> null != finalJsonObject.get((Object)tableFieldInfo_.getProperty())).map(tableFieldInfo_ -> tableFieldInfo_.getColumn()).collect(Collectors.toList());
            Collection params = tableInfo.getFieldList().stream().filter(tableFieldInfo_ -> null != finalJsonObject.get((Object)tableFieldInfo_.getProperty())).map(tableFieldInfo_ -> finalJsonObject.get((Object)tableFieldInfo_.getProperty())).collect(Collectors.toList());
            sql = sql.replaceFirst("%s", tableInfo.getTableName().toUpperCase());
            sql = sql.replaceFirst("%s", "WHERE " + String.join((CharSequence)"AND", whereColum.stream().map(colum -> colum + " = ? ").collect(Collectors.toList())));
            sqlInfo.setSql(sql).setParams(params).setSqlStatementType(SqlStatementType.DELETE);
        }
        return (R)sqlInfo;
    }

    protected String updateSql(Map<String, Object> linkedMap, String updateSql) {
        for (String key : linkedMap.keySet()) {
            if (updateSql.contains("=#{ew.paramNameValuePairs." + key + "},")) {
                updateSql = updateSql.replaceFirst("=#\\{ew.paramNameValuePairs." + key + "},", " = ?, ");
                continue;
            }
            if (updateSql.contains("= #{ew.paramNameValuePairs." + key + "}")) {
                updateSql = updateSql.replaceFirst("= #\\{ew.paramNameValuePairs." + key + "}", "= ?");
                continue;
            }
            updateSql = updateSql.replaceFirst("=#\\{ew.paramNameValuePairs." + key + "}", " = ?");
        }
        return updateSql;
    }
}

