/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.core.injector;

import com.luues.jdbc.plus.core.injector.AbstractMethod;
import com.luues.jdbc.plus.core.injector.ISqlInjector;
import com.luues.jdbc.plus.core.metadata.TableInfo;
import com.luues.jdbc.plus.core.metadata.TableInfoHelper;
import com.luues.jdbc.plus.core.toolkit.ArrayUtils;
import com.luues.jdbc.plus.core.toolkit.CollectionUtils;
import com.luues.util.logs.LogUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;

public abstract class AbstractSqlInjector
implements ISqlInjector {
    @Override
    public void inspectInject(Class<?> mapperClass) {
        Class<?> modelClass = this.extractModelClass(mapperClass);
        if (modelClass != null) {
            String className = mapperClass.toString();
            List<AbstractMethod> methodList = this.getMethodList(mapperClass);
            if (CollectionUtils.isNotEmpty(methodList)) {
                TableInfo tableInfo = TableInfoHelper.initTableInfo(modelClass);
                methodList.forEach(m -> m.inject(mapperClass, modelClass, tableInfo));
            } else {
                LogUtil.debug((String)(mapperClass.toString() + ", No effective injection method was found."));
            }
        }
    }

    public abstract List<AbstractMethod> getMethodList(Class<?> var1);

    protected Class<?> extractModelClass(Class<?> mapperClass) {
        Type[] types = mapperClass.getGenericInterfaces();
        ParameterizedType target = null;
        for (Type type : types) {
            Object t;
            Object[] objectArray;
            int n;
            int n2;
            if (!(type instanceof ParameterizedType)) continue;
            Object[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            if (!ArrayUtils.isNotEmpty(typeArray) || (n2 = 0) >= (n = (objectArray = typeArray).length) || (t = objectArray[n2]) instanceof TypeVariable || t instanceof WildcardType) break;
            target = (ParameterizedType)type;
            break;
        }
        return target == null ? null : (Class)target.getActualTypeArguments()[0];
    }
}

