/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.core.conditions;

import com.luues.jdbc.plus.core.conditions.ISqlSegment;
import com.luues.jdbc.plus.core.conditions.segments.MergeSegments;
import com.luues.jdbc.plus.core.conditions.segments.NormalSegmentList;
import com.luues.jdbc.plus.core.metadata.TableFieldInfo;
import com.luues.jdbc.plus.core.metadata.TableInfo;
import com.luues.jdbc.plus.core.metadata.TableInfoHelper;
import com.luues.jdbc.plus.core.toolkit.CollectionUtils;
import com.luues.jdbc.plus.core.toolkit.ReflectionKit;
import com.luues.jdbc.plus.core.toolkit.StringUtils;
import java.util.Objects;

public abstract class Wrapper<T>
implements ISqlSegment {
    public abstract T getEntity();

    public abstract Class<T> getEntityClass();

    public String getSqlSelect() {
        return null;
    }

    public String getSqlSet() {
        return null;
    }

    public String getSqlComment() {
        return null;
    }

    public String getSqlFirst() {
        return null;
    }

    public abstract MergeSegments getExpression();

    public String getCustomSqlSegment() {
        MergeSegments expression = this.getExpression();
        if (Objects.nonNull(expression)) {
            NormalSegmentList normal = expression.getNormal();
            String sqlSegment = this.getSqlSegment();
            if (StringUtils.isNotBlank(sqlSegment)) {
                if (normal.isEmpty()) {
                    return sqlSegment;
                }
                return "WHERE " + sqlSegment;
            }
        }
        return "";
    }

    public boolean isEmptyOfWhere() {
        return this.isEmptyOfNormal() && this.isEmptyOfEntity();
    }

    public boolean nonEmptyOfWhere() {
        return !this.isEmptyOfWhere();
    }

    public boolean isEmptyOfNormal() {
        return CollectionUtils.isEmpty(this.getExpression().getNormal());
    }

    public boolean nonEmptyOfNormal() {
        return !this.isEmptyOfNormal();
    }

    public boolean nonEmptyOfEntity() {
        T entity = this.getEntity();
        if (entity == null) {
            return false;
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entity.getClass());
        if (tableInfo == null) {
            return false;
        }
        if (tableInfo.getFieldList().stream().anyMatch(e -> this.fieldStrategyMatch(entity, (TableFieldInfo)e))) {
            return true;
        }
        return StringUtils.isNotBlank(tableInfo.getKeyProperty()) ? Objects.nonNull(ReflectionKit.getFieldValue(entity, tableInfo.getKeyProperty())) : false;
    }

    private boolean fieldStrategyMatch(T entity, TableFieldInfo e) {
        switch (e.getWhereStrategy()) {
            case NOT_NULL: {
                return Objects.nonNull(ReflectionKit.getFieldValue(entity, e.getProperty()));
            }
            case IGNORED: {
                return true;
            }
            case NOT_EMPTY: {
                return StringUtils.checkValNotNull(ReflectionKit.getFieldValue(entity, e.getProperty()));
            }
            case NEVER: {
                return false;
            }
        }
        return Objects.nonNull(ReflectionKit.getFieldValue(entity, e.getProperty()));
    }

    public boolean isEmptyOfEntity() {
        return !this.nonEmptyOfEntity();
    }

    public String getTargetSql() {
        return this.getSqlSegment().replaceAll("#\\{.+?}", "?");
    }

    public abstract void clear();
}

