/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.core.conditions;

import com.luues.jdbc.plus.core.conditions.AbstractWrapper;
import com.luues.jdbc.plus.core.exceptions.JdbcPlusException;
import com.luues.jdbc.plus.core.toolkit.Assert;
import com.luues.jdbc.plus.core.toolkit.LambdaUtils;
import com.luues.jdbc.plus.core.toolkit.PropertyNamer;
import com.luues.jdbc.plus.core.toolkit.support.ColumnCache;
import com.luues.jdbc.plus.core.toolkit.support.SFunction;
import com.luues.jdbc.plus.core.toolkit.support.SerializedLambda;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractLambdaWrapper<T, Children extends AbstractLambdaWrapper<T, Children>>
extends AbstractWrapper<T, SFunction<T, ?>, Children> {
    private Map<String, ColumnCache> columnMap = null;
    private boolean initColumnMap = false;

    protected String columnsToString(SFunction<T, ?> ... columns) {
        return this.columnsToString(true, columns);
    }

    protected String columnsToString(boolean onlyColumn, SFunction<T, ?> ... columns) {
        return Arrays.stream(columns).map(i -> this.columnToString((SFunction<T, ?>)i, onlyColumn)).collect(Collectors.joining(","));
    }

    @Override
    protected String columnToString(SFunction<T, ?> column) {
        return this.columnToString(column, true);
    }

    protected String columnToString(SFunction<T, ?> column, boolean onlyColumn) {
        return this.getColumn(LambdaUtils.resolve(column), onlyColumn);
    }

    private String getColumn(SerializedLambda lambda, boolean onlyColumn) throws JdbcPlusException {
        String fieldName = PropertyNamer.methodToProperty(lambda.getImplMethodName());
        Class<?> aClass = lambda.getInstantiatedType();
        this.setEntityClass(aClass);
        if (!this.initColumnMap) {
            this.columnMap = LambdaUtils.getColumnMap(aClass);
        }
        Assert.notNull(this.columnMap, "can not find lambda cache for this entity [%s]", aClass.getName());
        ColumnCache columnCache = this.columnMap.get(LambdaUtils.formatKey(fieldName));
        Assert.notNull(columnCache, "can not find lambda cache for this property [%s] of entity [%s]", fieldName, aClass.getName());
        return onlyColumn ? columnCache.getColumn() : columnCache.getColumnSelect();
    }

    @Override
    protected void initNeed() {
        super.initNeed();
        Class entityClass = this.getEntityClass();
        if (entityClass != null) {
            this.initColumnMap = true;
            this.columnMap = LambdaUtils.getColumnMap(entityClass);
        }
    }
}

