/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jdbc.plus.aop;

import com.luues.bean.secondary.SystemInfo;
import com.luues.jdbc.plus.annotation.EnableSqlLog;
import com.luues.jdbc.plus.annotation.ProfilesType;
import com.luues.jdbc.plus.core.jdbc.SqlInfo;
import com.luues.util.classUtil.ClassUtil;
import com.luues.util.logs.LogUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.PostConstruct;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;

@Aspect
@Component
@EnableAsync
@DependsOn(value={"beanContextHolder"})
public class SqlLogs {
    private ThreadLocal<List<String[]>> threadLocal = new ThreadLocal();
    private Map<Integer, String[]> log_ = new HashMap<Integer, String[]>();
    private Set<Class<? extends Object>> allClass;
    private String mainPack;
    private boolean enableLog = false;

    @PostConstruct
    @Async
    public void init() {
        if (null == this.mainPack) {
            Set set = ClassUtil.getTypesAnnotatedWith(EnableSqlLog.class);
            if (set.size() == 0 || set.size() > 1) {
                LogUtil.warn((String)"@EnableSqlLog:{}", (Object[])new Object[]{"not enable"});
            } else {
                Class aClass = (Class)set.iterator().next();
                EnableSqlLog enableSqlLog = aClass.getAnnotation(EnableSqlLog.class);
                ProfilesType[] profilesTypes = enableSqlLog.profiles();
                String profiles = Arrays.stream(profilesTypes).map(profilesType -> profilesType.name()).collect(Collectors.joining(","));
                LogUtil.warn((String)"@EnableSqlLog:{}, profiles:{}", (Object[])new Object[]{"true", profiles});
                if (profiles.contains(SystemInfo.getActive().toUpperCase()) || profiles.equals(ProfilesType.DLT.name())) {
                    this.enableLog = true;
                }
                String packName = aClass.getName();
                this.mainPack = packName.substring(0, packName.lastIndexOf("."));
                if (null == this.allClass) {
                    this.allClass = ClassUtil.getAllClass_((String)this.mainPack);
                }
            }
        }
    }

    @Pointcut(value="execution(* com.luues.jdbc.plus.core.jdbc.SqlParser.*(..))")
    public void logsAspect() {
    }

    @After(value="logsAspect()")
    public void logsAfter(JoinPoint joinPoint) {
    }

    @Before(value="logsAspect()")
    public void logsBefore(JoinPoint joinPoint) {
    }

    @Around(value="logsAspect()")
    public Object logsAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Object object = joinPoint.proceed();
        if (null != this.mainPack && this.enableLog) {
            if (object instanceof SqlInfo) {
                SqlInfo sqlInfo = (SqlInfo)object;
                this.log(sqlInfo, Thread.currentThread().getStackTrace());
            }
            if (object instanceof List) {
                List<Object> list = (List<Object>)object;
                list = list.stream().filter(obj -> obj instanceof SqlInfo).collect(Collectors.toList());
                StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
                list.forEach(obj -> {
                    SqlInfo sqlInfo = (SqlInfo)obj;
                    this.log(sqlInfo, stackTraceElements);
                });
            }
        }
        return object;
    }

    @Pointcut(value="execution(* org.springframework.jdbc.core.JdbcTemplate.*(..))")
    public void jdbcAspect() {
    }

    @After(value="jdbcAspect()")
    public void jdbcAspect(JoinPoint joinPoint) {
    }

    @Before(value="jdbcAspect()")
    public void jdbcBefore(JoinPoint joinPoint) {
    }

    @Around(value="jdbcAspect()")
    public Object jdbcAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        if (null == this.threadLocal.get()) {
            return joinPoint.proceed();
        }
        Long startTime = System.currentTimeMillis();
        Object object = joinPoint.proceed();
        Long endTime = System.currentTimeMillis();
        String[] log = this.threadLocal.get().get(0);
        log[log.length - 3] = log[log.length - 3].replaceFirst("%s", endTime - startTime + "ms");
        if (object instanceof List) {
            List list = (List)object;
            log[log.length - 2] = log[log.length - 2].replaceFirst("%s", list.size() > 3 ? list.stream().findFirst().get().toString() : list.toString());
        } else {
            log[log.length - 2] = log[log.length - 2].replaceFirst("%s", object.toString());
        }
        LogUtil.info((String[])log);
        this.threadLocal.get().remove(0);
        if (this.threadLocal.get().size() == 0) {
            this.threadLocal.remove();
        }
        return object;
    }

    @Async
    public void log(SqlInfo sqlInfo, StackTraceElement[] stackTraceElements) {
        if (!Objects.isNull(this.log_.get(sqlInfo.hashCode()))) {
            if (this.threadLocal.get() == null) {
                this.threadLocal.set(new ArrayList());
            }
            this.threadLocal.get().add(this.log_.get(sqlInfo.hashCode()));
        } else {
            String call_class_name = "";
            String call_method = "";
            String call_file_name = "";
            int call_line_number = 0;
            List<StackTraceElement> stackTraceElementList = Arrays.asList(stackTraceElements);
            try {
                StackTraceElement stackTraceElement_ = stackTraceElementList.stream().filter(stackTraceElement -> {
                    long count = this.allClass.stream().filter(class_ -> stackTraceElement.getClassName().equals(class_.getName()) && stackTraceElement.getClassName().startsWith(this.mainPack)).count();
                    return count > 0L;
                }).findFirst().get();
                call_class_name = stackTraceElement_.getClassName();
                call_method = stackTraceElement_.getMethodName();
                call_file_name = stackTraceElement_.getFileName();
                call_line_number = stackTraceElement_.getLineNumber();
            }
            catch (Exception e) {
                LogUtil.warn((String)"It is possible that the method exists in the thread and the specific method location is not obtained!");
            }
            String oldSql = sqlInfo.getSql();
            String newSql = sqlInfo.getSql();
            String params = "";
            if (null != sqlInfo.getParams()) {
                for (Object object : sqlInfo.getParams()) {
                    newSql = newSql.replaceFirst("\\?", object instanceof Integer || object instanceof Long ? "" + object + "" : "'" + object + "'");
                }
                params = sqlInfo.getParams().stream().map(o -> o.toString()).collect(Collectors.joining(","));
            } else if (null != sqlInfo.getParamsList()) {
                params = "(\u53c2\u6570\u5b9e\u9645\u957f\u5ea6:" + sqlInfo.getParamsList().size() + ")" + IntStream.range(0, sqlInfo.getParamsList().size() > 3 ? 3 : sqlInfo.getParamsList().size()).mapToObj(i -> sqlInfo.getParamsList().get(i).stream().map(o -> o.toString()).collect(Collectors.joining(","))).collect(Collectors.joining("|")) + (sqlInfo.getParamsList().size() > 3 ? "|...." : "");
            }
            if (this.threadLocal.get() == null) {
                this.threadLocal.set(new ArrayList());
            }
            this.threadLocal.get().add(new String[]{"\u250f\u2501\u2501\u2501\u2501\u2501 START [" + call_class_name + "." + call_method + "] \u2501\u2501\u2501", "\u2523 \u7c7b\u578b  \uff1a [" + sqlInfo.getSqlStatementType().name() + "] ", "\u2523 \u65e7SQL \uff1a " + oldSql, "\u2523 \u65b0SQL \uff1a " + newSql, "\u2523 \u53c2\u6570  \uff1a [" + params + "]", "\u2523 \u4f4d\u7f6e  \uff1a (" + call_file_name + ":" + call_line_number + ")", "\u2523 \u65f6\u95f4  \uff1a [%s]", "\u2523 \u7ed3\u679c  \uff1a [%s]", "\u2517\u2501\u2501\u2501\u2501\u2501 END [" + call_class_name + "." + call_method + "] \u2501\u2501\u2501"});
            this.log_.put(sqlInfo.hashCode(), this.threadLocal.get().get(0));
        }
    }
}

