package com.luues.applicationcontext.init;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;


@AutoConfigureOrder(value = Ordered.HIGHEST_PRECEDENCE)
@Configuration
public class BeanPostConfiguration {

    @Autowired
    private AutowireCapableBeanFactory beanFactory;

    @Bean
    public BeanContextHolder beanContextHolder(){
        BeanContextHolder beanContextHolder = new BeanContextHolder();
        return beanContextHolder;
    }

    @Bean
    public BeanPostProcessor beanPostProcessor(){
        BeanPostProcessor beanPostProcessor = new BeanPostProcessor();
        return beanPostProcessor;
    }

}
