package com.luues.applicationcontext.init;

import com.luues.applicationcontext.SystemInfo;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * Springframework 上下文持有者<br><br>
 */
public class BeanContextHolder implements ApplicationContextAware {
	private static ApplicationContext applicationContext = null;

	public void setApplicationContext(ApplicationContext applicationContext) {
		this.applicationContext = applicationContext;
	}

	@PostConstruct
	protected void init(){
		try {
			String host = InetAddress.getLocalHost().getHostAddress();
			TomcatServletWebServerFactory tomcatServletWebServerFactory = BeanContextHolder.getApplicationContext().getBean(TomcatServletWebServerFactory.class);
			int port = tomcatServletWebServerFactory.getPort();
			String contextPath = tomcatServletWebServerFactory.getContextPath();
			new SystemInfo(host, port, contextPath, applicationContext.getEnvironment().getActiveProfiles()[0]);
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}
	}

	// 获取applicationContext
	public static ApplicationContext getApplicationContext() {
		return applicationContext;
	}

	public static HttpServletRequest getRequest() {
		HttpServletRequest httpServletRequest = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
		return httpServletRequest;
	}

	public static HttpServletResponse getResponse() {
		HttpServletResponse httpServletResponse = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getResponse();
		return httpServletResponse;
	}

	public static HttpSession getSession() {
		return getRequest().getSession();
	}

}
