package com.luues.applicationcontext.end;

import com.luues.applicationcontext.SystemInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class ApplicationReadyEventLog implements ApplicationListener<ApplicationReadyEvent> {

    @Override
    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        log.info("{}", "\n\n" +
                "　　　　　  .--,       .--,\n" +
                "　　　　　 ( (  \\.---./  ) )\n" +
                "　　　　　  '.__/o   o\\__.'\n" +
                "　　　　　     {=  ^  =}\n" +
                "　　　　　      >  -  <\n" +
                "　　　　　     /       \\\n" +
                "　　　　　    //       \\\\\n" +
                "　　　　　   //|   .   |\\\\\n" +
                "　　　　　   \"'\\       /'\"_.-~^`'-.\n" +
                "　　　　　      \\  _  /--'         `\n" +
                "　　　　　    ___)( )(___\n" +
                "　　　　　   (((__) (__)))    高山仰止,景行行止.虽不能至,心向往之。\n\n" +
                "　　　　　===========================当前运行环境："+ SystemInfo.getActive() +"\n\n" +
                "　　　　　project service address：" + SystemInfo.value() + "\n\n");
    }
}
