package com.luues.applicationcontext.banner;

import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.core.env.Environment;

import java.io.*;

public class Banner implements org.springframework.boot.Banner {
    public void printBanner(Environment environment, Class<?> aClass, PrintStream printStream) {
        InputStream is = Banner.class.getClassLoader().getResourceAsStream("logo.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if(line.contains("#{bootVersion}")){
                    line = line.replace("#{bootVersion}", SpringBootVersion.getVersion());
                }
                printStream.println("\u001b[48;35m" + line + "\u001b[0m");
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                is.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
