/*
 * Decompiled with CFR 0.152.
 */
package com.luter.heimdall.plugins.redis.store;

import com.luter.heimdall.core.authorization.store.AuthorizationStore;
import com.luter.heimdall.core.config.ConfigManager;
import com.luter.heimdall.core.config.HeimdallProperties;
import com.luter.heimdall.core.details.UserDetails;
import com.luter.heimdall.core.exception.HeimdallCacheException;
import com.luter.heimdall.core.exception.HeimdallExceededTokenException;
import com.luter.heimdall.core.exception.HeimdallTokenException;
import com.luter.heimdall.core.listener.AbstractTokenStoreEvent;
import com.luter.heimdall.core.token.PageModel;
import com.luter.heimdall.core.token.SimpleToken;
import com.luter.heimdall.core.token.store.TokenStore;
import com.luter.heimdall.core.utils.StrUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisTokenStore
extends AbstractTokenStoreEvent
implements TokenStore {
    private static final transient Logger log = LoggerFactory.getLogger(RedisTokenStore.class);
    private RedisTemplate<String, SimpleToken> tokenCache;
    private AuthorizationStore authorizationStore;

    public RedisTokenStore(RedisTemplate<String, SimpleToken> tokenCache) {
        this.tokenCache = tokenCache;
    }

    public RedisTokenStore(RedisTemplate<String, SimpleToken> tokenCache, AuthorizationStore authorizationStore) {
        this(tokenCache);
        this.tokenCache = tokenCache;
        this.authorizationStore = authorizationStore;
    }

    public boolean isSelfExpired() {
        return true;
    }

    public SimpleToken saveToken(SimpleToken token) {
        this.resolveMaxTokens(token.getDetails());
        HeimdallProperties config = ConfigManager.getConfig();
        long timeout = config.getToken().getTimeout();
        int maximumTokens = config.getToken().getMaximumTokens();
        log.debug("[cacheToken]::token = [{}]", (Object)token);
        Boolean aBoolean = this.tokenCache.opsForValue().setIfAbsent((Object)this.generateCacheKey(token.getId()), (Object)token, timeout, TimeUnit.SECONDS);
        log.info("[cacheToken]::token = [{}], tokenCacheTimeOut = [{}]", (Object)token, (Object)timeout);
        if (null != aBoolean && aBoolean.booleanValue()) {
            if (maximumTokens > 1 && null != this.authorizationStore) {
                this.authorizationStore.removeUserAuthorities(token.getDetails());
            }
            this.onCreated(token);
            return token;
        }
        throw new HeimdallCacheException("Failed to cache token:" + aBoolean);
    }

    public SimpleToken getToken(String tokenId) {
        log.debug("[getToken]::tokenId = [{}]", (Object)tokenId);
        if (StrUtils.isBlank((String)tokenId)) {
            return null;
        }
        SimpleToken simpleToken = (SimpleToken)this.tokenCache.opsForValue().get((Object)this.generateCacheKey(tokenId));
        log.debug("[getToken]::tokenId = [{}],token = [{}]", (Object)tokenId, (Object)simpleToken);
        this.onRead(simpleToken);
        return simpleToken;
    }

    public SimpleToken update(SimpleToken token) {
        log.debug("[update]::token = [{}]", (Object)token);
        SimpleToken newToken = this.renewToken(token);
        log.debug("[update]::token = [{}],newToken = [{}]", (Object)token, (Object)newToken);
        this.onUpdated(newToken);
        return newToken;
    }

    public SimpleToken renewToken(SimpleToken token) {
        HeimdallProperties config = ConfigManager.getConfig();
        boolean renewal = config.getToken().isRenewal();
        double ratio = config.getToken().getRatio();
        long timeout = config.getToken().getTimeout();
        log.debug("[renewToken]::token = [{}]", (Object)token);
        if (null == token) {
            return null;
        }
        String cacheKey = this.generateCacheKey(token.getId());
        if (renewal) {
            Long expire = this.tokenCache.getExpire((Object)cacheKey, TimeUnit.SECONDS);
            if (null != expire) {
                if (-2 == expire.intValue()) {
                    log.error("[renewToken]::Failed to update token data. Key: {} does not exist in redis. Please check whether the data is correct? ", (Object)cacheKey);
                }
                if (-1L == expire) {
                    log.warn("[renewToken]:: When renewing token, TTL of session: {} = - 1, which means it will never expire. Reset TTL to: {}", (Object)cacheKey, (Object)timeout);
                }
                log.debug("[renewToken]::Renewal token, set renewal ratio: {}", (Object)ratio);
                double radio = Math.max(ratio, 0.01);
                radio = Math.min(radio, 0.99);
                log.debug("[renewToken]::Renewal session, actual renewal ratio: {}", (Object)radio);
                double v = expire.doubleValue() / (double)timeout;
                if (v < radio || -1L == expire) {
                    log.info("[renewToken]::Token key = [{}], current remaining time = [{}] seconds, global expiration time = [{}] seconds, ratio = [{}], lower than the set value = [{}], renew to global time = [{}] seconds . ", new Object[]{cacheKey, expire.doubleValue(), timeout, v, radio, timeout});
                    SimpleToken newToken = token.renewalToken(token, timeout);
                    this.tokenCache.opsForValue().set((Object)cacheKey, (Object)newToken, timeout, TimeUnit.SECONDS);
                    return newToken;
                }
                log.debug("[renewToken]::Token  key = [{}], current remaining time = [{}] seconds, global expiration time = [{}] seconds, ratio = [{}], higher than the set value = [{}], Abort.", new Object[]{cacheKey, expire.doubleValue(), timeout, v, radio});
            }
        } else {
            log.debug("[renewToken]:: token renew is disabled. token = [{}]", (Object)token);
        }
        return token;
    }

    public Collection<SimpleToken> getPrincipalTokens(String principal) {
        List simpleTokens;
        log.debug("[getPrincipalTokens]::principal = [{}]", (Object)principal);
        if (StrUtils.isBlank((String)principal)) {
            return new ArrayList<SimpleToken>();
        }
        ArrayList<SimpleToken> principalTokens = new ArrayList<SimpleToken>();
        Set keys = this.tokenCache.keys((Object)(ConfigManager.getConfig().getToken().getCachePrefix() + "*"));
        if (null != keys && !keys.isEmpty() && null != (simpleTokens = this.tokenCache.opsForValue().multiGet((Collection)keys)) && !simpleTokens.isEmpty()) {
            for (SimpleToken simpleToken : simpleTokens) {
                if (!simpleToken.getDetails().getPrincipal().equals(principal)) continue;
                principalTokens.add(simpleToken);
            }
        }
        return principalTokens;
    }

    public Collection<SimpleToken> getActiveTokens() {
        log.debug("[getActiveTokens]::");
        Set keys = this.tokenCache.keys((Object)(ConfigManager.getConfig().getToken().getCachePrefix() + "*"));
        if (null != keys && !keys.isEmpty()) {
            List simpleTokens = this.tokenCache.opsForValue().multiGet((Collection)keys);
            return null != simpleTokens && !simpleTokens.isEmpty() ? (Collection)simpleTokens.stream().sorted(Comparator.comparing(SimpleToken::getIat).reversed()).collect(Collectors.toList()) : null;
        }
        return null;
    }

    public Collection<SimpleToken> getActiveTokens(String appId) {
        log.debug("[getActiveTokens]::appId = [{}]", (Object)appId);
        if (StrUtils.isBlank((String)appId)) {
            return new ArrayList<SimpleToken>();
        }
        Collection<SimpleToken> activeTokens = this.getActiveTokens();
        ArrayList<SimpleToken> tokens = new ArrayList<SimpleToken>();
        if (null != activeTokens && !activeTokens.isEmpty()) {
            for (SimpleToken activeToken : activeTokens) {
                if (!activeToken.getDetails().getAppId().equals(appId)) continue;
                tokens.add(activeToken);
            }
        }
        return tokens.stream().sorted(Comparator.comparing(SimpleToken::getIat).reversed()).collect(Collectors.toList());
    }

    public PageModel<SimpleToken> getActiveTokensPage(int pageNumber, int pageSize) {
        Collection<SimpleToken> activeTokens = this.getActiveTokens();
        if (null == activeTokens || activeTokens.isEmpty()) {
            return new PageModel();
        }
        return new PageModel(activeTokens, pageNumber, pageSize);
    }

    public PageModel<SimpleToken> getActiveTokensPage(String appId, int pageNumber, int pageSize) {
        Collection<SimpleToken> activeTokens = this.getActiveTokens(appId);
        if (null == activeTokens || activeTokens.isEmpty()) {
            return new PageModel();
        }
        return new PageModel(activeTokens, pageNumber, pageSize);
    }

    public SimpleToken deleteToken(String tokenId) {
        SimpleToken token = (SimpleToken)this.tokenCache.opsForValue().get((Object)this.generateCacheKey(tokenId));
        if (null != token) {
            this.tokenCache.delete((Object)this.generateCacheKey(token.getId()));
            this.onDeleted(token);
            if (null != this.authorizationStore) {
                log.debug("[deleteToken]:: clear the UserAuthorities at the same time after remove token, tokenId = [{}]", (Object)tokenId);
                this.authorizationStore.removeUserAuthorities(token.getDetails());
            }
            return token;
        }
        return null;
    }

    public int deletePrincipalTokens(String principal) {
        List simpleTokens;
        ArrayList<String> principalTokenKeys = new ArrayList<String>();
        Set keys = this.tokenCache.keys((Object)(ConfigManager.getConfig().getToken().getCachePrefix() + "*"));
        if (null != keys && !keys.isEmpty() && null != (simpleTokens = this.tokenCache.opsForValue().multiGet((Collection)keys)) && !simpleTokens.isEmpty()) {
            for (SimpleToken simpleToken : simpleTokens) {
                if (!simpleToken.getDetails().getPrincipal().equals(principal)) continue;
                principalTokenKeys.add(this.generateCacheKey(simpleToken.getId()));
            }
        }
        if (!principalTokenKeys.isEmpty()) {
            this.tokenCache.delete(principalTokenKeys);
            return principalTokenKeys.size();
        }
        return 0;
    }

    public int deleteAppTokens(String appId) {
        log.debug("[deleteAppTokens]::appId = [{}]", (Object)appId);
        Collection<SimpleToken> activeTokens = this.getActiveTokens(appId);
        ArrayList<String> deletedKeys = new ArrayList<String>();
        if (null != activeTokens && !activeTokens.isEmpty()) {
            for (SimpleToken activeToken : activeTokens) {
                if (!activeToken.getDetails().getAppId().equals(appId)) continue;
                deletedKeys.add(this.generateCacheKey(activeToken.getId()));
            }
        }
        if (!deletedKeys.isEmpty()) {
            this.tokenCache.delete(deletedKeys);
            log.info("[deleteAppTokens]::appId = [{}],deleted count = [{}]", (Object)appId, (Object)deletedKeys.size());
            return deletedKeys.size();
        }
        log.debug("[deleteAppTokens]::appId = [{}],deleted count =0", (Object)appId);
        return 0;
    }

    public int clearExpiredTokens() {
        return 0;
    }

    public long getActiveTokensCount() {
        Set keys = this.tokenCache.keys((Object)(ConfigManager.getConfig().getToken().getCachePrefix() + "*"));
        return null != keys ? (long)keys.size() : 0L;
    }

    private String generateCacheKey(String tokenId) {
        log.debug("[generateCacheKey]::tokenId = [{}]", (Object)tokenId);
        return this.generateCacheKey(ConfigManager.getConfig().getToken().getCachePrefix(), tokenId);
    }

    private String generateCacheKey(String orgPrefix, String tokenId) {
        if (StrUtils.isBlank((String)tokenId)) {
            throw new HeimdallCacheException("TokenId can not be null");
        }
        if (StrUtils.isBlank((String)orgPrefix)) {
            throw new HeimdallCacheException("TokenId can not be null");
        }
        log.debug("[generateCacheKey]::orgPrefix = [{}], tokenId = [{}]", (Object)orgPrefix, (Object)tokenId);
        String prefix = orgPrefix.trim();
        prefix = prefix.startsWith(":") ? prefix.replaceFirst(":", "") : prefix;
        prefix = prefix.endsWith(":") ? prefix : prefix + ":";
        return prefix + tokenId;
    }

    private void resolveMaxTokens(UserDetails userDetails) {
        Collection<SimpleToken> principalTokens;
        int maximumTokens = ConfigManager.getConfig().getToken().getMaximumTokens();
        log.debug("[resolveMaxTokens]::userDetails = [{}]", (Object)userDetails);
        if (maximumTokens < 0) {
            log.warn("[resolveMaxTokens]::Bad parameter settings .maximum tokens is set to {}, The concurrent authentication restriction function will disabled\u3002", (Object)maximumTokens);
        }
        if (0 == maximumTokens) {
            log.warn("[resolveMaxTokens]::maximum tokens is set to {}, The  authentication  function will disabled\u3002", (Object)maximumTokens);
            throw new HeimdallTokenException("authentication has been disabled");
        }
        if (maximumTokens > 0 && null != (principalTokens = this.getPrincipalTokens(userDetails.getPrincipal())) && principalTokens.size() >= maximumTokens) {
            if (ConfigManager.getConfig().getToken().isMaxTokensPreventLogin()) {
                log.warn("[resolveMaxTokens]::userDetails:[{}],   exceeded the maximum Tokens limit of [{}] times . request rejected", (Object)userDetails, (Object)maximumTokens);
                throw new HeimdallExceededTokenException();
            }
            ArrayList<String> deleteKeys = new ArrayList<String>();
            for (SimpleToken principalToken : principalTokens) {
                deleteKeys.add(this.generateCacheKey(principalToken.getId()));
            }
            this.tokenCache.delete(deleteKeys);
            log.warn("[resolveMaxTokens]:: Remove all previously authenticated tokens of the User:  userDetails = [{}],count= [{}]", (Object)userDetails, (Object)deleteKeys.size());
        }
    }

    public RedisTemplate<String, SimpleToken> tokenCache() {
        return this.tokenCache;
    }

    public AuthorizationStore authorizationStore() {
        return this.authorizationStore;
    }

    public RedisTokenStore tokenCache(RedisTemplate<String, SimpleToken> tokenCache) {
        this.tokenCache = tokenCache;
        return this;
    }

    public RedisTokenStore authorizationStore(AuthorizationStore authorizationStore) {
        this.authorizationStore = authorizationStore;
        return this;
    }

    public String toString() {
        return "RedisTokenStore(tokenCache=" + this.tokenCache() + ", authorizationStore=" + this.authorizationStore() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisTokenStore)) {
            return false;
        }
        RedisTokenStore other = (RedisTokenStore)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RedisTemplate<String, SimpleToken> this$tokenCache = this.tokenCache();
        RedisTemplate<String, SimpleToken> other$tokenCache = other.tokenCache();
        if (this$tokenCache == null ? other$tokenCache != null : !this$tokenCache.equals(other$tokenCache)) {
            return false;
        }
        AuthorizationStore this$authorizationStore = this.authorizationStore();
        AuthorizationStore other$authorizationStore = other.authorizationStore();
        return !(this$authorizationStore == null ? other$authorizationStore != null : !this$authorizationStore.equals(other$authorizationStore));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisTokenStore;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RedisTemplate<String, SimpleToken> $tokenCache = this.tokenCache();
        result = result * 59 + ($tokenCache == null ? 43 : $tokenCache.hashCode());
        AuthorizationStore $authorizationStore = this.authorizationStore();
        result = result * 59 + ($authorizationStore == null ? 43 : $authorizationStore.hashCode());
        return result;
    }
}

