/*
 * Decompiled with CFR 0.152.
 */
package com.luter.heimdall.plugins.redis.store;

import com.luter.heimdall.core.authorization.authority.GrantedAuthority;
import com.luter.heimdall.core.authorization.provider.AuthorityDataProvider;
import com.luter.heimdall.core.authorization.provider.NoneAuthoritiesDataProvider;
import com.luter.heimdall.core.authorization.store.AuthorizationStore;
import com.luter.heimdall.core.config.ConfigManager;
import com.luter.heimdall.core.config.HeimdallProperties;
import com.luter.heimdall.core.details.UserDetails;
import com.luter.heimdall.core.exception.HeimdallUnauthorizedException;
import com.luter.heimdall.core.utils.StrUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisAuthorizationStore
implements AuthorizationStore {
    private static final transient Logger log = LoggerFactory.getLogger(RedisAuthorizationStore.class);
    private RedisTemplate<String, Map<String, List<String>>> appCache;
    private RedisTemplate<String, List<? extends GrantedAuthority>> userCache;
    private AuthorityDataProvider dataProvider;

    public RedisAuthorizationStore() {
    }

    public RedisAuthorizationStore(RedisTemplate<String, Map<String, List<String>>> appCache, RedisTemplate<String, List<? extends GrantedAuthority>> userCache) {
        this.dataProvider = new NoneAuthoritiesDataProvider();
        this.appCache = appCache;
        this.userCache = userCache;
    }

    public RedisAuthorizationStore(RedisTemplate<String, Map<String, List<String>>> appCache, RedisTemplate<String, List<? extends GrantedAuthority>> userCache, AuthorityDataProvider dataProvider) {
        this(appCache, userCache);
        this.dataProvider = dataProvider;
    }

    public boolean isSelfExpired() {
        return true;
    }

    public List<? extends GrantedAuthority> getUserAuthorities(UserDetails userDetails) {
        HeimdallProperties config = ConfigManager.getConfig();
        if (null == userDetails || StrUtils.isBlank((String)userDetails.getPrincipal())) {
            return new ArrayList();
        }
        log.debug("[getUserAuthorities]::userDetails = [{}]", (Object)userDetails);
        String cacheKey = this.generateUserCacheKey(userDetails.getPrincipal());
        List cachedPerms = (List)this.userCache.opsForValue().get((Object)cacheKey);
        if (null == cachedPerms || cachedPerms.isEmpty()) {
            if (null != this.dataProvider) {
                cachedPerms = this.dataProvider.loadUserAuthorities(userDetails);
                if (null == cachedPerms || cachedPerms.isEmpty()) {
                    log.warn("The authorities of User:[{}] loaded from meta data service is empty", (Object)userDetails.getPrincipal());
                } else {
                    this.userCache.opsForValue().setIfAbsent((Object)cacheKey, (Object)cachedPerms, config.getAuthority().getUserCacheExpire(), TimeUnit.SECONDS);
                    log.debug("The user authorities  is successfully loaded from the MetaDataService  and stored in the cache\u3002user:[{}],authorities:[{}]", (Object)userDetails, (Object)cachedPerms);
                }
            } else {
                log.error("Authorization Metadata Service is not implemented. Failed to obtain user authorities");
            }
        }
        log.debug("The obtained User authorization data is: [{}]", (Object)cachedPerms);
        return cachedPerms;
    }

    public void putUserAuthorities(String principal, List<? extends GrantedAuthority> authorities) {
        HeimdallProperties config = ConfigManager.getConfig();
        log.debug("[putUserAuthorities]::principal = [{}], authorities = [{}]", (Object)principal, authorities);
        if (StrUtils.isBlank((String)principal)) {
            throw new IllegalArgumentException("The User principal can not be null ");
        }
        if (null == authorities || authorities.isEmpty()) {
            log.warn("The authorities of principal:[{}] is empty and will not be cached", (Object)principal);
        } else {
            log.debug("[putUserAuthorities]::principal = [{}], authorities = [{}]", (Object)principal, authorities);
            this.userCache.opsForValue().setIfAbsent((Object)this.generateUserCacheKey(principal), authorities, config.getAuthority().getUserCacheExpire(), TimeUnit.SECONDS);
        }
    }

    public void removeUserAuthorities(UserDetails userDetails) {
        if (null == userDetails || StrUtils.isBlank((String)userDetails.getPrincipal())) {
            throw new HeimdallUnauthorizedException("The User detail info can not be null");
        }
        if (StrUtils.isBlank((String)userDetails.getAppId())) {
            throw new IllegalArgumentException("appId can not be null");
        }
        if (StrUtils.isBlank((String)userDetails.getUserId())) {
            throw new IllegalArgumentException("userId can not be null");
        }
        log.debug("[removeUserAuthorities]::userDetails = [{}]", (Object)userDetails);
        Boolean delete = this.userCache.delete((Object)this.generateUserCacheKey(userDetails.getPrincipal()));
        log.info("[removeUserAuthorities]:: userDetails:[{}] userAuthorities = [{}]", (Object)userDetails, (Object)delete);
    }

    public void removeUserAuthorities(String appId, String userId) {
        this.removeUserAuthorities(new UserDetails(appId, userId));
    }

    public void removeAllUserAuthorities() {
        Set keys = this.userCache.keys((Object)"*");
        if (null != keys && !keys.isEmpty()) {
            this.userCache.delete((Collection)keys);
        }
    }

    public Map<String, List<String>> getAppAuthorities(String appId) {
        if (StrUtils.isBlank((String)appId)) {
            throw new IllegalArgumentException("The AppId can not be null");
        }
        log.debug("[getAppAuthorities]::appId = [{}]", (Object)appId);
        String cacheKey = this.generateAppCacheKey(appId);
        Map appPerms = (Map)this.appCache.opsForValue().get((Object)cacheKey);
        if (null == appPerms || appPerms.isEmpty()) {
            if (null != this.dataProvider) {
                appPerms = this.dataProvider.loadAppAuthorities(appId);
                if (null == appPerms || appPerms.isEmpty()) {
                    log.warn("Authorities of appId:[{}] loaded from meta data service is empty", (Object)appId);
                } else {
                    HeimdallProperties config = ConfigManager.getConfig();
                    this.appCache.opsForValue().setIfAbsent((Object)cacheKey, (Object)appPerms, config.getAuthority().getAppCacheExpire(), TimeUnit.SECONDS);
                }
            } else {
                log.error("Authorization Metadata Service is not implemented. Failed to obtain system authorities");
            }
        }
        log.debug("Obtained App authorization data is: [{}]", (Object)appPerms);
        return appPerms;
    }

    public Map<String, List<String>> getAppAuthorities(UserDetails userDetails) {
        if (null == userDetails || StrUtils.isBlank((String)userDetails.getAppId())) {
            throw new HeimdallUnauthorizedException("The UserDetails or appId can not be null");
        }
        log.debug("[getAppAuthorities]::userDetails = [{}]", (Object)userDetails);
        return this.getAppAuthorities(userDetails.getAppId());
    }

    public void putAppAuthorities(String appId, Map<String, List<String>> authorities) {
        HeimdallProperties config = ConfigManager.getConfig();
        if (StrUtils.isBlank((String)appId)) {
            throw new IllegalArgumentException(" The AppId can not be null ");
        }
        log.debug("[putAppAuthorities]::appId = [{}], authorities = [{}]", (Object)appId, authorities);
        if (null == authorities || authorities.isEmpty()) {
            log.warn("The authorities of appId:[{}] is empty and will not be cached", (Object)appId);
        } else {
            this.appCache.opsForValue().setIfAbsent((Object)this.generateAppCacheKey(appId), authorities, config.getAuthority().getAppCacheExpire(), TimeUnit.SECONDS);
        }
    }

    public void removeAppAuthorities(String appId) {
        log.debug("[removeAppAuthorities]::appId = [{}]", (Object)appId);
        if (StrUtils.isBlank((String)appId)) {
            throw new IllegalArgumentException(" The AppId can not be null ");
        }
        this.appCache.delete((Object)this.generateAppCacheKey(appId));
    }

    public void removeAppAuthorities(UserDetails userDetails) {
        this.removeAppAuthorities(userDetails.getAppId());
    }

    public void removeAllAppAuthorities() {
        Set keys = this.appCache.keys((Object)"*");
        if (null != keys && !keys.isEmpty()) {
            this.appCache.delete((Collection)keys);
        }
    }

    private String generateUserCacheKey(String id) {
        HeimdallProperties config = ConfigManager.getConfig();
        log.debug("[generateUserCacheKey]::id = [{}]", (Object)id);
        return this.generateCacheKey(config.getAuthority().getUserCacheKeyPrefix(), id);
    }

    private String generateAppCacheKey(String id) {
        HeimdallProperties config = ConfigManager.getConfig();
        log.debug("[generateAppCacheKey]::id = [{}]", (Object)id);
        return this.generateCacheKey(config.getAuthority().getAppCacheKeyPrefix(), id);
    }

    private String generateCacheKey(String orgPrefix, String id) {
        if (StrUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("The id can not be null");
        }
        if (StrUtils.isBlank((String)orgPrefix)) {
            throw new IllegalArgumentException("The prefix can not be null");
        }
        log.debug("[generateCacheKey]::orgPrefix = [{}], id = [{}]", (Object)orgPrefix, (Object)id);
        String prefix = orgPrefix.trim();
        prefix = prefix.startsWith(":") ? prefix.replaceFirst(":", "") : prefix;
        prefix = prefix.endsWith(":") ? prefix : prefix + ":";
        return prefix + id;
    }

    public RedisTemplate<String, Map<String, List<String>>> appCache() {
        return this.appCache;
    }

    public RedisTemplate<String, List<? extends GrantedAuthority>> userCache() {
        return this.userCache;
    }

    public AuthorityDataProvider dataProvider() {
        return this.dataProvider;
    }

    public RedisAuthorizationStore appCache(RedisTemplate<String, Map<String, List<String>>> appCache) {
        this.appCache = appCache;
        return this;
    }

    public RedisAuthorizationStore userCache(RedisTemplate<String, List<? extends GrantedAuthority>> userCache) {
        this.userCache = userCache;
        return this;
    }

    public RedisAuthorizationStore dataProvider(AuthorityDataProvider dataProvider) {
        this.dataProvider = dataProvider;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisAuthorizationStore)) {
            return false;
        }
        RedisAuthorizationStore other = (RedisAuthorizationStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisTemplate<String, Map<String, List<String>>> this$appCache = this.appCache();
        RedisTemplate<String, Map<String, List<String>>> other$appCache = other.appCache();
        if (this$appCache == null ? other$appCache != null : !this$appCache.equals(other$appCache)) {
            return false;
        }
        RedisTemplate<String, List<? extends GrantedAuthority>> this$userCache = this.userCache();
        RedisTemplate<String, List<? extends GrantedAuthority>> other$userCache = other.userCache();
        if (this$userCache == null ? other$userCache != null : !this$userCache.equals(other$userCache)) {
            return false;
        }
        AuthorityDataProvider this$dataProvider = this.dataProvider();
        AuthorityDataProvider other$dataProvider = other.dataProvider();
        return !(this$dataProvider == null ? other$dataProvider != null : !this$dataProvider.equals(other$dataProvider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisAuthorizationStore;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisTemplate<String, Map<String, List<String>>> $appCache = this.appCache();
        result = result * 59 + ($appCache == null ? 43 : $appCache.hashCode());
        RedisTemplate<String, List<? extends GrantedAuthority>> $userCache = this.userCache();
        result = result * 59 + ($userCache == null ? 43 : $userCache.hashCode());
        AuthorityDataProvider $dataProvider = this.dataProvider();
        result = result * 59 + ($dataProvider == null ? 43 : $dataProvider.hashCode());
        return result;
    }

    public String toString() {
        return "RedisAuthorizationStore(appCache=" + this.appCache() + ", userCache=" + this.userCache() + ", dataProvider=" + this.dataProvider() + ")";
    }
}

