/*
 * Decompiled with CFR 0.152.
 */
package com.luter.heimdall.plugins.redis.listener;

import com.luter.heimdall.core.config.ConfigManager;
import com.luter.heimdall.core.token.store.TokenStore;
import com.luter.heimdall.core.utils.StrUtils;
import com.luter.heimdall.plugins.redis.listener.RedisKeyExpiredEventMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

public class RedisTokenKeyExpirationListener
extends RedisKeyExpiredEventMessageListener {
    private static final transient Logger log = LoggerFactory.getLogger(RedisTokenKeyExpirationListener.class);
    @Autowired
    private TokenStore tokenStore;

    public RedisTokenKeyExpirationListener(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    public void onMessage(Message message, byte[] pattern) {
        log.debug("[onMessage]::Token expired event,  key = [{}]", (Object)message.toString());
        String expiredKey = message.toString();
        if (StrUtils.isNotBlank((String)expiredKey) && expiredKey.startsWith(ConfigManager.getConfig().getToken().getCachePrefix())) {
            String tokenId = expiredKey.replace(ConfigManager.getConfig().getToken().getCachePrefix(), "");
            log.warn("[onMessage]:: Expired Token, TokenId = [{}]", (Object)tokenId);
        } else {
            log.debug("Token expired event,key = [{}]", (Object)expiredKey);
        }
    }
}

