/*
 * Decompiled with CFR 0.152.
 */
package com.luter.heimdall.plugins.redis.listener;

import com.luter.heimdall.core.config.ConfigManager;
import com.luter.heimdall.core.token.store.TokenStore;
import com.luter.heimdall.core.utils.StrUtils;
import com.luter.heimdall.plugins.redis.listener.RedisKeyDeletedEventMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

public class RedisTokenKeyDeletedListener
extends RedisKeyDeletedEventMessageListener {
    private static final transient Logger log = LoggerFactory.getLogger(RedisTokenKeyDeletedListener.class);
    @Autowired
    private TokenStore tokenStore;

    public RedisTokenKeyDeletedListener(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    public void onMessage(Message message, byte[] pattern) {
        log.debug("[onMessage]:: token del event . key = [{}]", (Object)message.toString());
        String expiredKey = message.toString();
        if (StrUtils.isNotBlank((String)expiredKey) && expiredKey.startsWith(ConfigManager.getConfig().getToken().getCachePrefix())) {
            String tokenId = expiredKey.replace(ConfigManager.getConfig().getToken().getCachePrefix(), "");
            log.warn("[onMessage]::Deleted token. TokenId = [{}]", (Object)tokenId);
        } else {
            log.debug("[onMessage]::Token del event,key = [{}]", (Object)expiredKey);
        }
    }
}

