/*
 * Decompiled with CFR 0.152.
 */
package com.luter.heimdall.plugins.redis.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisKeyExpiredEvent;
import org.springframework.data.redis.listener.KeyspaceEventMessageListener;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.lang.Nullable;

public class RedisKeyDeletedEventMessageListener
extends KeyspaceEventMessageListener
implements ApplicationEventPublisherAware {
    private static final transient Logger log = LoggerFactory.getLogger(RedisKeyDeletedEventMessageListener.class);
    @Nullable
    private ApplicationEventPublisher publisher;
    @Autowired
    private RedisProperties redisProperties;

    public RedisKeyDeletedEventMessageListener(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    protected void doRegister(RedisMessageListenerContainer listenerContainer) {
        String tPattern = "__keyevent@" + this.redisProperties.getDatabase() + "__:del";
        PatternTopic topic = new PatternTopic(tPattern);
        log.info("Register redis key del event listener, topic pattern: {}", (Object)tPattern);
        listenerContainer.addMessageListener((MessageListener)this, (Topic)topic);
    }

    protected void doHandleMessage(Message message) {
        this.publishEvent(new RedisKeyExpiredEvent(message.getBody()));
    }

    protected void publishEvent(RedisKeyExpiredEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)event);
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }
}

