/*
 * Decompiled with CFR 0.152.
 */
package com.luter.heimdall.plugins.redis.limiter;

import com.luter.heimdall.core.config.ConfigManager;
import com.luter.heimdall.core.config.HeimdallProperties;
import com.luter.heimdall.core.exception.HeimdallCacheException;
import com.luter.heimdall.core.limiter.PasswordRetryLimiter;
import com.luter.heimdall.core.utils.StrUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisPasswordRetryLimiter
implements PasswordRetryLimiter {
    private static final transient Logger log = LoggerFactory.getLogger(RedisPasswordRetryLimiter.class);
    private StringRedisTemplate retryCache;

    public RedisPasswordRetryLimiter(StringRedisTemplate retryCache) {
        if (null == retryCache) {
            throw new HeimdallCacheException("String RedisTemplate can not be null ");
        }
        this.retryCache = retryCache;
    }

    public boolean overLimitWhenIncremented(String key) {
        HeimdallProperties config = ConfigManager.getConfig();
        int attempts = config.getLimiter().getAttempts();
        long lockedDuration = config.getLimiter().getLockedDuration();
        log.debug("[overLimitWhenIncremented]::key = [{}]", (Object)key);
        String cacheKey = config.getLimiter().getCachePrefix() + key;
        log.debug("[overLimitWhenIncremented]::cacheKey = [{}]", (Object)cacheKey);
        if (config.getLimiter().isEnabled()) {
            log.info("[overLimitWhenIncremented]:: The Retry Limiter is enabled, key = [{}],cacheKey = [{}]", (Object)key, (Object)cacheKey);
            String s = (String)this.retryCache.opsForValue().get((Object)cacheKey);
            if (StrUtils.isBlank((String)s)) {
                log.debug("[overLimitWhenIncremented]:: First retry ,Initialize and set to 0, key = [{}],cacheKey = [{}]", (Object)key, (Object)cacheKey);
                this.retryCache.opsForValue().set((Object)cacheKey, (Object)"1", lockedDuration, TimeUnit.MINUTES);
            } else {
                AtomicInteger retryCount = new AtomicInteger(Integer.parseInt(s));
                log.info("[overLimitWhenIncremented]::  key = [{}],cacheKey = [{}],retry times = [{}] ", new Object[]{key, cacheKey, retryCount.get()});
                if (retryCount.incrementAndGet() > attempts) {
                    log.error("[overLimitWhenIncremented]:: CacheKey: [{}] retry times: [{}], exceeding the maximum number limit: [{}], lock the account", new Object[]{cacheKey, retryCount, attempts});
                    return true;
                }
                this.retryCache.opsForValue().set((Object)cacheKey, (Object)(retryCount.get() + ""), lockedDuration, TimeUnit.MINUTES);
            }
        } else {
            log.debug("[increase]::  The Retry Limiter is Disabled.  key = [{}]", (Object)key);
        }
        return false;
    }

    public void release(String key) {
        HeimdallProperties config = ConfigManager.getConfig();
        this.retryCache.delete((Object)(config.getLimiter().getCachePrefix() + key));
    }

    public int count(String key) {
        HeimdallProperties config = ConfigManager.getConfig();
        String s = (String)this.retryCache.opsForValue().get((Object)(config.getLimiter().getCachePrefix() + key));
        if (null != s) {
            return Integer.parseInt(s);
        }
        return 0;
    }

    public int availableTimes(String key) {
        HeimdallProperties config = ConfigManager.getConfig();
        return config.getLimiter().getAttempts() - this.count(key);
    }

    public StringRedisTemplate retryCache() {
        return this.retryCache;
    }

    public RedisPasswordRetryLimiter retryCache(StringRedisTemplate retryCache) {
        this.retryCache = retryCache;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisPasswordRetryLimiter)) {
            return false;
        }
        RedisPasswordRetryLimiter other = (RedisPasswordRetryLimiter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StringRedisTemplate this$retryCache = this.retryCache();
        StringRedisTemplate other$retryCache = other.retryCache();
        return !(this$retryCache == null ? other$retryCache != null : !this$retryCache.equals(other$retryCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisPasswordRetryLimiter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringRedisTemplate $retryCache = this.retryCache();
        result = result * 59 + ($retryCache == null ? 43 : $retryCache.hashCode());
        return result;
    }

    public String toString() {
        return "RedisPasswordRetryLimiter(retryCache=" + this.retryCache() + ")";
    }
}

