/*
 * Decompiled with CFR 0.152.
 */
package com.luter.heimdall.plugins.redis.config;

import com.luter.heimdall.core.authorization.authority.GrantedAuthority;
import com.luter.heimdall.core.token.SimpleToken;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public abstract class DefaultStringKeyRedisTemplateConfiguration {
    private static final transient Logger log = LoggerFactory.getLogger(DefaultStringKeyRedisTemplateConfiguration.class);

    @Bean
    public RedisTemplate<String, SimpleToken> tokenRedisTemplate(RedisConnectionFactory factory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(factory);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.afterPropertiesSet();
        log.info("Default Token Redis Jackson Cache: RedisTemplate<String, SimpleToken> redisTemplate  Initialized.  ");
        return redisTemplate;
    }

    @Bean
    protected RedisTemplate<String, Map<String, List<String>>> appAuthoritiesRedisTemplate(RedisConnectionFactory factory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(factory);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.afterPropertiesSet();
        log.info("Default App Authorities Redis Jackson Cache: RedisTemplate<String, Collection<String>> redisTemplate Initialized.  ");
        return redisTemplate;
    }

    @Bean
    protected RedisTemplate<String, List<? extends GrantedAuthority>> userAuthoritiesRedisTemplate(RedisConnectionFactory factory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(factory);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.afterPropertiesSet();
        log.info("Default User Authorities Redis Jackson Cache: RedisTemplate<String, List<? extends GrantedAuthority>>  redisTemplate Initialized. ");
        return redisTemplate;
    }
}

