/*
 * Decompiled with CFR 0.152.
 */
package com.luter.heimdall.plugins.redis;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.RedisSerializer;

public class LoggingRedisTemplate<K, V>
extends RedisTemplate<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(LoggingRedisTemplate.class);

    public <T> T execute(RedisCallback<T> action, boolean exposeConnection, boolean pipeline) {
        try {
            return (T)super.execute(action, exposeConnection, pipeline);
        }
        catch (Throwable t) {
            logger.warn("Error executing cache operation: {}", (Object)t.getMessage());
            return null;
        }
    }

    public <T> T execute(RedisScript<T> script, List<K> keys, Object ... args) {
        try {
            return (T)super.execute(script, keys, args);
        }
        catch (Throwable t) {
            logger.warn("Error executing cache operation: {}", (Object)t.getMessage());
            return null;
        }
    }

    public <T> T execute(RedisScript<T> script, RedisSerializer<?> argsSerializer, RedisSerializer<T> resultSerializer, List<K> keys, Object ... args) {
        try {
            return (T)super.execute(script, argsSerializer, resultSerializer, keys, args);
        }
        catch (Throwable t) {
            logger.warn("Error executing cache operation: {}", (Object)t.getMessage());
            return null;
        }
    }

    public <T> T execute(SessionCallback<T> session) {
        try {
            return (T)super.execute(session);
        }
        catch (Throwable t) {
            logger.warn("Error executing cache operation: {}", (Object)t.getMessage());
            return null;
        }
    }
}

