
package org.neogroup.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * Utilities for mime types
 */
public abstract class MimeUtils {

    private static final String FILE_EXTENSION_REGEX = "\\.(?=[^\\.]+$)";

    public static final String APPLICATION_ACAD = "application/acad";
    public static final String APPLICATION_ARJ = "application/arj";
    public static final String APPLICATION_BASE64 = "application/base64";
    public static final String APPLICATION_BINHEX = "application/binhex";
    public static final String APPLICATION_BINHEX4 = "application/binhex4";
    public static final String APPLICATION_BOOK = "application/book";
    public static final String APPLICATION_CDF = "application/cdf";
    public static final String APPLICATION_CLARISCAD = "application/clariscad";
    public static final String APPLICATION_COMMONGROUND = "application/commonground";
    public static final String APPLICATION_DRAFTING = "application/drafting";
    public static final String APPLICATION_DSPTYPE = "application/dsptype";
    public static final String APPLICATION_DXF = "application/dxf";
    public static final String APPLICATION_ECMASCRIPT = "application/ecmascript";
    public static final String APPLICATION_ENVOY = "application/envoy";
    public static final String APPLICATION_EXCEL = "application/excel";
    public static final String APPLICATION_FRACTALS = "application/fractals";
    public static final String APPLICATION_FREELOADER = "application/freeloader";
    public static final String APPLICATION_FUTURESPLASH = "application/futuresplash";
    public static final String APPLICATION_GNUTAR = "application/gnutar";
    public static final String APPLICATION_GROUPWISE = "application/groupwise";
    public static final String APPLICATION_HLP = "application/hlp";
    public static final String APPLICATION_HTA = "application/hta";
    public static final String APPLICATION_IGES = "application/iges";
    public static final String APPLICATION_INF = "application/inf";
    public static final String APPLICATION_I_DEAS = "application/i-deas";
    public static final String APPLICATION_JAVA = "application/java";
    public static final String APPLICATION_JAVASCRIPT = "application/javascript";
    public static final String APPLICATION_JAVA_BYTE_CODE = "application/java-byte-code";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_LHA = "application/lha";
    public static final String APPLICATION_LZX = "application/lzx";
    public static final String APPLICATION_MACBINARY = "application/macbinary";
    public static final String APPLICATION_MAC_BINARY = "application/mac-binary";
    public static final String APPLICATION_MAC_BINHEX = "application/mac-binhex";
    public static final String APPLICATION_MAC_BINHEX40 = "application/mac-binhex40";
    public static final String APPLICATION_MAC_COMPACTPRO = "application/mac-compactpro";
    public static final String APPLICATION_MARC = "application/marc";
    public static final String APPLICATION_MBEDLET = "application/mbedlet";
    public static final String APPLICATION_MCAD = "application/mcad";
    public static final String APPLICATION_MIME = "application/mime";
    public static final String APPLICATION_MSPOWERPOINT = "application/mspowerpoint";
    public static final String APPLICATION_MSWORD = "application/msword";
    public static final String APPLICATION_MSWRITE = "application/mswrite";
    public static final String APPLICATION_NETMC = "application/netmc";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_ODA = "application/oda";
    public static final String APPLICATION_PDF = "application/pdf";
    public static final String APPLICATION_PKCS10 = "application/pkcs10";
    public static final String APPLICATION_PKCS7_MIME = "application/pkcs7-mime";
    public static final String APPLICATION_PKCS7_SIGNATURE = "application/pkcs7-signature";
    public static final String APPLICATION_PKCS_12 = "application/pkcs-12";
    public static final String APPLICATION_PKCS_CRL = "application/pkcs-crl";
    public static final String APPLICATION_PKIX_CERT = "application/pkix-cert";
    public static final String APPLICATION_PKIX_CRL = "application/pkix-crl";
    public static final String APPLICATION_PLAIN = "application/plain";
    public static final String APPLICATION_POSTSCRIPT = "application/postscript";
    public static final String APPLICATION_POWERPOINT = "application/powerpoint";
    public static final String APPLICATION_PRO_ENG = "application/pro_eng";
    public static final String APPLICATION_RINGING_TONES = "application/ringing-tones";
    public static final String APPLICATION_RTF = "application/rtf";
    public static final String APPLICATION_SDP = "application/sdp";
    public static final String APPLICATION_SEA = "application/sea";
    public static final String APPLICATION_SET = "application/set";
    public static final String APPLICATION_SLA = "application/sla";
    public static final String APPLICATION_SMIL = "application/smil";
    public static final String APPLICATION_SOLIDS = "application/solids";
    public static final String APPLICATION_SOUNDER = "application/sounder";
    public static final String APPLICATION_STEP = "application/step";
    public static final String APPLICATION_STREAMINGMEDIA = "application/streamingmedia";
    public static final String APPLICATION_TOOLBOOK = "application/toolbook";
    public static final String APPLICATION_VDA = "application/vda";
    public static final String APPLICATION_VND_FDF = "application/vnd.fdf";
    public static final String APPLICATION_VND_HP_HPGL = "application/vnd.hp-hpgl";
    public static final String APPLICATION_VND_HP_PCL = "application/vnd.hp-pcl";
    public static final String APPLICATION_VND_MS_EXCEL = "application/vnd.ms-excel";
    public static final String APPLICATION_VND_MS_PKI_CERTSTORE = "application/vnd.ms-pki.certstore";
    public static final String APPLICATION_VND_MS_PKI_PKO = "application/vnd.ms-pki.pko";
    public static final String APPLICATION_VND_MS_PKI_SECCAT = "application/vnd.ms-pki.seccat";
    public static final String APPLICATION_VND_MS_PKI_STL = "application/vnd.ms-pki.stl";
    public static final String APPLICATION_VND_MS_POWERPOINT = "application/vnd.ms-powerpoint";
    public static final String APPLICATION_VND_MS_PROJECT = "application/vnd.ms-project";
    public static final String APPLICATION_VND_NOKIA_CONFIGURATION_MESSAGE = "application/vnd.nokia.configuration-message";
    public static final String APPLICATION_VND_NOKIA_RINGING_TONE = "application/vnd.nokia.ringing-tone";
    public static final String APPLICATION_VND_RN_REALMEDIA = "application/vnd.rn-realmedia";
    public static final String APPLICATION_VND_RN_REALPLAYER = "application/vnd.rn-realplayer";
    public static final String APPLICATION_VND_WAP_WMLC = "application/vnd.wap.wmlc";
    public static final String APPLICATION_VND_WAP_WMLSCRIPTC = "application/vnd.wap.wmlscriptc";
    public static final String APPLICATION_VND_XARA = "application/vnd.xara";
    public static final String APPLICATION_VOCALTEC_MEDIA_DESC = "application/vocaltec-media-desc";
    public static final String APPLICATION_VOCALTEC_MEDIA_FILE = "application/vocaltec-media-file";
    public static final String APPLICATION_WORDPERFECT = "application/wordperfect";
    public static final String APPLICATION_WORDPERFECT6_0 = "application/wordperfect6.0";
    public static final String APPLICATION_WORDPERFECT6_1 = "application/wordperfect6.1";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_X_123 = "application/x-123";
    public static final String APPLICATION_X_AIM = "application/x-aim";
    public static final String APPLICATION_X_AUTHORWARE_BIN = "application/x-authorware-bin";
    public static final String APPLICATION_X_AUTHORWARE_MAP = "application/x-authorware-map";
    public static final String APPLICATION_X_AUTHORWARE_SEG = "application/x-authorware-seg";
    public static final String APPLICATION_X_BCPIO = "application/x-bcpio";
    public static final String APPLICATION_X_BINARY = "application/x-binary";
    public static final String APPLICATION_X_BINHEX40 = "application/x-binhex40";
    public static final String APPLICATION_X_BSH = "application/x-bsh";
    public static final String APPLICATION_X_BYTECODE_ELISP = "application/x-bytecode.elisp";
    public static final String APPLICATION_X_BYTECODE_PYTHON = "application/x-bytecode.python";
    public static final String APPLICATION_X_BZIP = "application/x-bzip";
    public static final String APPLICATION_X_BZIP2 = "application/x-bzip2";
    public static final String APPLICATION_X_CDF = "application/x-cdf";
    public static final String APPLICATION_X_CDLINK = "application/x-cdlink";
    public static final String APPLICATION_X_CHAT = "application/x-chat";
    public static final String APPLICATION_X_CMU_RASTER = "application/x-cmu-raster";
    public static final String APPLICATION_X_COCOA = "application/x-cocoa";
    public static final String APPLICATION_X_COMPACTPRO = "application/x-compactpro";
    public static final String APPLICATION_X_COMPRESS = "application/x-compress";
    public static final String APPLICATION_X_COMPRESSED = "application/x-compressed";
    public static final String APPLICATION_X_CONFERENCE = "application/x-conference";
    public static final String APPLICATION_X_CPIO = "application/x-cpio";
    public static final String APPLICATION_X_CPT = "application/x-cpt";
    public static final String APPLICATION_X_CSH = "application/x-csh";
    public static final String APPLICATION_X_DEEPV = "application/x-deepv";
    public static final String APPLICATION_X_DIRECTOR = "application/x-director";
    public static final String APPLICATION_X_DVI = "application/x-dvi";
    public static final String APPLICATION_X_ELC = "application/x-elc";
    public static final String APPLICATION_X_ENVOY = "application/x-envoy";
    public static final String APPLICATION_X_ESREHBER = "application/x-esrehber";
    public static final String APPLICATION_X_EXCEL = "application/x-excel";
    public static final String APPLICATION_X_FRAME = "application/x-frame";
    public static final String APPLICATION_X_FREELANCE = "application/x-freelance";
    public static final String APPLICATION_X_GSP = "application/x-gsp";
    public static final String APPLICATION_X_GSS = "application/x-gss";
    public static final String APPLICATION_X_GTAR = "application/x-gtar";
    public static final String APPLICATION_X_GZIP = "application/x-gzip";
    public static final String APPLICATION_X_HDF = "application/x-hdf";
    public static final String APPLICATION_X_HELPFILE = "application/x-helpfile";
    public static final String APPLICATION_X_HTTPD_IMAP = "application/x-httpd-imap";
    public static final String APPLICATION_X_IMA = "application/x-ima";
    public static final String APPLICATION_X_INTERNETT_SIGNUP = "application/x-internett-signup";
    public static final String APPLICATION_X_INVENTOR = "application/x-inventor";
    public static final String APPLICATION_X_IP2 = "application/x-ip2";
    public static final String APPLICATION_X_JAVASCRIPT = "application/x-javascript";
    public static final String APPLICATION_X_JAVA_CLASS = "application/x-java-class";
    public static final String APPLICATION_X_JAVA_COMMERCE = "application/x-java-commerce";
    public static final String APPLICATION_X_KOAN = "application/x-koan";
    public static final String APPLICATION_X_KSH = "application/x-ksh";
    public static final String APPLICATION_X_LATEX = "application/x-latex";
    public static final String APPLICATION_X_LHA = "application/x-lha";
    public static final String APPLICATION_X_LISP = "application/x-lisp";
    public static final String APPLICATION_X_LIVESCREEN = "application/x-livescreen";
    public static final String APPLICATION_X_LOTUS = "application/x-lotus";
    public static final String APPLICATION_X_LOTUSSCREENCAM = "application/x-lotusscreencam";
    public static final String APPLICATION_X_LZH = "application/x-lzh";
    public static final String APPLICATION_X_LZX = "application/x-lzx";
    public static final String APPLICATION_X_MACBINARY = "application/x-macbinary";
    public static final String APPLICATION_X_MAC_BINHEX40 = "application/x-mac-binhex40";
    public static final String APPLICATION_X_MAGIC_CAP_PACKAGE_1_0 = "application/x-magic-cap-package-1.0";
    public static final String APPLICATION_X_MATHCAD = "application/x-mathcad";
    public static final String APPLICATION_X_MEME = "application/x-meme";
    public static final String APPLICATION_X_MIDI = "application/x-midi";
    public static final String APPLICATION_X_MIF = "application/x-mif";
    public static final String APPLICATION_X_MIX_TRANSFER = "application/x-mix-transfer";
    public static final String APPLICATION_X_MPLAYER2 = "application/x-mplayer2";
    public static final String APPLICATION_X_MSEXCEL = "application/x-msexcel";
    public static final String APPLICATION_X_MSPOWERPOINT = "application/x-mspowerpoint";
    public static final String APPLICATION_X_NAVIDOC = "application/x-navidoc";
    public static final String APPLICATION_X_NAVIMAP = "application/x-navimap";
    public static final String APPLICATION_X_NAVISTYLE = "application/x-navistyle";
    public static final String APPLICATION_X_NAVI_ANIMATION = "application/x-navi-animation";
    public static final String APPLICATION_X_NETCDF = "application/x-netcdf";
    public static final String APPLICATION_X_NEWTON_COMPATIBLE_PKG = "application/x-newton-compatible-pkg";
    public static final String APPLICATION_X_NOKIA_9000_COMMUNICATOR_ADD_ON_SOFTWARE = "application/x-nokia-9000-communicator-add-on-software";
    public static final String APPLICATION_X_OMC = "application/x-omc";
    public static final String APPLICATION_X_OMCDATAMAKER = "application/x-omcdatamaker";
    public static final String APPLICATION_X_OMCREGERATOR = "application/x-omcregerator";
    public static final String APPLICATION_X_PAGEMAKER = "application/x-pagemaker";
    public static final String APPLICATION_X_PCL = "application/x-pcl";
    public static final String APPLICATION_X_PIXCLSCRIPT = "application/x-pixclscript";
    public static final String APPLICATION_X_PKCS10 = "application/x-pkcs10";
    public static final String APPLICATION_X_PKCS12 = "application/x-pkcs12";
    public static final String APPLICATION_X_PKCS7_CERTIFICATES = "application/x-pkcs7-certificates";
    public static final String APPLICATION_X_PKCS7_CERTREQRESP = "application/x-pkcs7-certreqresp";
    public static final String APPLICATION_X_PKCS7_MIME = "application/x-pkcs7-mime";
    public static final String APPLICATION_X_PKCS7_SIGNATURE = "application/x-pkcs7-signature";
    public static final String APPLICATION_X_POINTPLUS = "application/x-pointplus";
    public static final String APPLICATION_X_PORTABLE_ANYMAP = "application/x-portable-anymap";
    public static final String APPLICATION_X_PROJECT = "application/x-project";
    public static final String APPLICATION_X_QPRO = "application/x-qpro";
    public static final String APPLICATION_X_RTF = "application/x-rtf";
    public static final String APPLICATION_X_SDP = "application/x-sdp";
    public static final String APPLICATION_X_SEA = "application/x-sea";
    public static final String APPLICATION_X_SEELOGO = "application/x-seelogo";
    public static final String APPLICATION_X_SH = "application/x-sh";
    public static final String APPLICATION_X_SHAR = "application/x-shar";
    public static final String APPLICATION_X_SHOCKWAVE_FLASH = "application/x-shockwave-flash";
    public static final String APPLICATION_X_SIT = "application/x-sit";
    public static final String APPLICATION_X_SPRITE = "application/x-sprite";
    public static final String APPLICATION_X_STUFFIT = "application/x-stuffit";
    public static final String APPLICATION_X_SV4CPIO = "application/x-sv4cpio";
    public static final String APPLICATION_X_SV4CRC = "application/x-sv4crc";
    public static final String APPLICATION_X_TAR = "application/x-tar";
    public static final String APPLICATION_X_TBOOK = "application/x-tbook";
    public static final String APPLICATION_X_TCL = "application/x-tcl";
    public static final String APPLICATION_X_TEX = "application/x-tex";
    public static final String APPLICATION_X_TEXINFO = "application/x-texinfo";
    public static final String APPLICATION_X_TROFF = "application/x-troff";
    public static final String APPLICATION_X_TROFF_MAN = "application/x-troff-man";
    public static final String APPLICATION_X_TROFF_ME = "application/x-troff-me";
    public static final String APPLICATION_X_TROFF_MS = "application/x-troff-ms";
    public static final String APPLICATION_X_TROFF_MSVIDEO = "application/x-troff-msvideo";
    public static final String APPLICATION_X_USTAR = "application/x-ustar";
    public static final String APPLICATION_X_VISIO = "application/x-visio";
    public static final String APPLICATION_X_VND_AUDIOEXPLOSION_MZZ = "application/x-vnd.audioexplosion.mzz";
    public static final String APPLICATION_X_VND_LS_XPIX = "application/x-vnd.ls-xpix";
    public static final String APPLICATION_X_VRML = "application/x-vrml";
    public static final String APPLICATION_X_WAIS_SOURCE = "application/x-wais-source";
    public static final String APPLICATION_X_WINHELP = "application/x-winhelp";
    public static final String APPLICATION_X_WINTALK = "application/x-wintalk";
    public static final String APPLICATION_X_WORLD = "application/x-world";
    public static final String APPLICATION_X_WPWIN = "application/x-wpwin";
    public static final String APPLICATION_X_WRI = "application/x-wri";
    public static final String APPLICATION_X_X509_CA_CERT = "application/x-x509-ca-cert";
    public static final String APPLICATION_X_X509_USER_CERT = "application/x-x509-user-cert";
    public static final String APPLICATION_X_ZIP_COMPRESSED = "application/x-zip-compressed";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String AUDIO_AIFF = "audio/aiff";
    public static final String AUDIO_BASIC = "audio/basic";
    public static final String AUDIO_IT = "audio/it";
    public static final String AUDIO_MAKE = "audio/make";
    public static final String AUDIO_MAKE_MY_FUNK = "audio/make.my.funk";
    public static final String AUDIO_MID = "audio/mid";
    public static final String AUDIO_MIDI = "audio/midi";
    public static final String AUDIO_MOD = "audio/mod";
    public static final String AUDIO_MPEG = "audio/mpeg";
    public static final String AUDIO_MPEG3 = "audio/mpeg3";
    public static final String AUDIO_NSPAUDIO = "audio/nspaudio";
    public static final String AUDIO_S3M = "audio/s3m";
    public static final String AUDIO_TSPLAYER = "audio/tsplayer";
    public static final String AUDIO_TSP_AUDIO = "audio/tsp-audio";
    public static final String AUDIO_VND_QCELP = "audio/vnd.qcelp";
    public static final String AUDIO_VOC = "audio/voc";
    public static final String AUDIO_VOXWARE = "audio/voxware";
    public static final String AUDIO_WAV = "audio/wav";
    public static final String AUDIO_XM = "audio/xm";
    public static final String AUDIO_X_ADPCM = "audio/x-adpcm";
    public static final String AUDIO_X_AIFF = "audio/x-aiff";
    public static final String AUDIO_X_AU = "audio/x-au";
    public static final String AUDIO_X_GSM = "audio/x-gsm";
    public static final String AUDIO_X_JAM = "audio/x-jam";
    public static final String AUDIO_X_LIVEAUDIO = "audio/x-liveaudio";
    public static final String AUDIO_X_MID = "audio/x-mid";
    public static final String AUDIO_X_MIDI = "audio/x-midi";
    public static final String AUDIO_X_MOD = "audio/x-mod";
    public static final String AUDIO_X_MPEG = "audio/x-mpeg";
    public static final String AUDIO_X_MPEG_3 = "audio/x-mpeg-3";
    public static final String AUDIO_X_MPEQURL = "audio/x-mpequrl";
    public static final String AUDIO_X_NSPAUDIO = "audio/x-nspaudio";
    public static final String AUDIO_X_PN_REALAUDIO = "audio/x-pn-realaudio";
    public static final String AUDIO_X_PN_REALAUDIO_PLUGIN = "audio/x-pn-realaudio-plugin";
    public static final String AUDIO_X_PSID = "audio/x-psid";
    public static final String AUDIO_X_REALAUDIO = "audio/x-realaudio";
    public static final String AUDIO_X_TWINVQ = "audio/x-twinvq";
    public static final String AUDIO_X_TWINVQ_PLUGIN = "audio/x-twinvq-plugin";
    public static final String AUDIO_X_VND_AUDIOEXPLOSION_MJUICEMEDIAFILE = "audio/x-vnd.audioexplosion.mjuicemediafile";
    public static final String AUDIO_X_VOC = "audio/x-voc";
    public static final String AUDIO_X_WAV = "audio/x-wav";
    public static final String CHEMICAL_X_PDB = "chemical/x-pdb";
    public static final String DRAWING_X_DWF = "drawing/x-dwf";
    public static final String IMAGE_BMP = "image/bmp";
    public static final String IMAGE_CMU_RASTER = "image/cmu-raster";
    public static final String IMAGE_FIF = "image/fif";
    public static final String IMAGE_FLORIAN = "image/florian";
    public static final String IMAGE_G3FAX = "image/g3fax";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_IEF = "image/ief";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_JUTVISION = "image/jutvision";
    public static final String IMAGE_NAPLPS = "image/naplps";
    public static final String IMAGE_PICT = "image/pict";
    public static final String IMAGE_PJPEG = "image/pjpeg";
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_TIFF = "image/tiff";
    public static final String IMAGE_VASA = "image/vasa";
    public static final String IMAGE_VND_DWG = "image/vnd.dwg";
    public static final String IMAGE_VND_FPX = "image/vnd.fpx";
    public static final String IMAGE_VND_NET_FPX = "image/vnd.net-fpx";
    public static final String IMAGE_VND_RN_REALFLASH = "image/vnd.rn-realflash";
    public static final String IMAGE_VND_RN_REALPIX = "image/vnd.rn-realpix";
    public static final String IMAGE_VND_WAP_WBMP = "image/vnd.wap.wbmp";
    public static final String IMAGE_VND_XIFF = "image/vnd.xiff";
    public static final String IMAGE_XBM = "image/xbm";
    public static final String IMAGE_XPM = "image/xpm";
    public static final String IMAGE_X_CMU_RASTER = "image/x-cmu-raster";
    public static final String IMAGE_X_DWG = "image/x-dwg";
    public static final String IMAGE_X_ICON = "image/x-icon";
    public static final String IMAGE_X_JG = "image/x-jg";
    public static final String IMAGE_X_JPS = "image/x-jps";
    public static final String IMAGE_X_NIFF = "image/x-niff";
    public static final String IMAGE_X_PCX = "image/x-pcx";
    public static final String IMAGE_X_PICT = "image/x-pict";
    public static final String IMAGE_X_PORTABLE_ANYMAP = "image/x-portable-anymap";
    public static final String IMAGE_X_PORTABLE_BITMAP = "image/x-portable-bitmap";
    public static final String IMAGE_X_PORTABLE_GRAYMAP = "image/x-portable-graymap";
    public static final String IMAGE_X_PORTABLE_GREYMAP = "image/x-portable-greymap";
    public static final String IMAGE_X_PORTABLE_PIXMAP = "image/x-portable-pixmap";
    public static final String IMAGE_X_QUICKTIME = "image/x-quicktime";
    public static final String IMAGE_X_RGB = "image/x-rgb";
    public static final String IMAGE_X_TIFF = "image/x-tiff";
    public static final String IMAGE_X_WINDOWS_BMP = "image/x-windows-bmp";
    public static final String IMAGE_X_XBITMAP = "image/x-xbitmap";
    public static final String IMAGE_X_XBM = "image/x-xbm";
    public static final String IMAGE_X_XPIXMAP = "image/x-xpixmap";
    public static final String IMAGE_X_XWD = "image/x-xwd";
    public static final String IMAGE_X_XWINDOWDUMP = "image/x-xwindowdump";
    public static final String I_WORLD_I_VRML = "i-world/i-vrml";
    public static final String MESSAGE_RFC822 = "message/rfc822";
    public static final String MODEL_IGES = "model/iges";
    public static final String MODEL_VND_DWF = "model/vnd.dwf";
    public static final String MODEL_VRML = "model/vrml";
    public static final String MODEL_X_POV = "model/x-pov";
    public static final String MULTIPART_X_GZIP = "multipart/x-gzip";
    public static final String MULTIPART_X_USTAR = "multipart/x-ustar";
    public static final String MULTIPART_X_ZIP = "multipart/x-zip";
    public static final String MUSIC_CRESCENDO = "music/crescendo";
    public static final String MUSIC_X_KARAOKE = "music/x-karaoke";
    public static final String PALEOVU_X_PV = "paleovu/x-pv";
    public static final String TEXT_ASP = "text/asp";
    public static final String TEXT_CSS = "text/css";
    public static final String TEXT_ECMASCRIPT = "text/ecmascript";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_JAVASCRIPT = "text/javascript";
    public static final String TEXT_MCF = "text/mcf";
    public static final String TEXT_PASCAL = "text/pascal";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_RICHTEXT = "text/richtext";
    public static final String TEXT_SCRIPLET = "text/scriplet";
    public static final String TEXT_SGML = "text/sgml";
    public static final String TEXT_TAB_SEPARATED_VALUES = "text/tab-separated-values";
    public static final String TEXT_URI_LIST = "text/uri-list";
    public static final String TEXT_VND_ABC = "text/vnd.abc";
    public static final String TEXT_VND_FMI_FLEXSTOR = "text/vnd.fmi.flexstor";
    public static final String TEXT_VND_RN_REALTEXT = "text/vnd.rn-realtext";
    public static final String TEXT_VND_WAP_WML = "text/vnd.wap.wml";
    public static final String TEXT_VND_WAP_WMLSCRIPT = "text/vnd.wap.wmlscript";
    public static final String TEXT_WEBVIEWHTML = "text/webviewhtml";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_X_ASM = "text/x-asm";
    public static final String TEXT_X_AUDIOSOFT_INTRA = "text/x-audiosoft-intra";
    public static final String TEXT_X_C = "text/x-c";
    public static final String TEXT_X_COMPONENT = "text/x-component";
    public static final String TEXT_X_FORTRAN = "text/x-fortran";
    public static final String TEXT_X_H = "text/x-h";
    public static final String TEXT_X_JAVA_SOURCE = "text/x-java-source";
    public static final String TEXT_X_LA_ASF = "text/x-la-asf";
    public static final String TEXT_X_M = "text/x-m";
    public static final String TEXT_X_PASCAL = "text/x-pascal";
    public static final String TEXT_X_SCRIPT = "text/x-script";
    public static final String TEXT_X_SCRIPT_CSH = "text/x-script.csh";
    public static final String TEXT_X_SCRIPT_ELISP = "text/x-script.elisp";
    public static final String TEXT_X_SCRIPT_GUILE = "text/x-script.guile";
    public static final String TEXT_X_SCRIPT_KSH = "text/x-script.ksh";
    public static final String TEXT_X_SCRIPT_LISP = "text/x-script.lisp";
    public static final String TEXT_X_SCRIPT_PERL = "text/x-script.perl";
    public static final String TEXT_X_SCRIPT_PERL_MODULE = "text/x-script.perl-module";
    public static final String TEXT_X_SCRIPT_PHYTON = "text/x-script.phyton";
    public static final String TEXT_X_SCRIPT_REXX = "text/x-script.rexx";
    public static final String TEXT_X_SCRIPT_SCHEME = "text/x-script.scheme";
    public static final String TEXT_X_SCRIPT_SH = "text/x-script.sh";
    public static final String TEXT_X_SCRIPT_TCL = "text/x-script.tcl";
    public static final String TEXT_X_SCRIPT_TCSH = "text/x-script.tcsh";
    public static final String TEXT_X_SCRIPT_ZSH = "text/x-script.zsh";
    public static final String TEXT_X_SERVER_PARSED_HTML = "text/x-server-parsed-html";
    public static final String TEXT_X_SETEXT = "text/x-setext";
    public static final String TEXT_X_SGML = "text/x-sgml";
    public static final String TEXT_X_SPEECH = "text/x-speech";
    public static final String TEXT_X_UIL = "text/x-uil";
    public static final String TEXT_X_UUENCODE = "text/x-uuencode";
    public static final String TEXT_X_VCALENDAR = "text/x-vcalendar";
    public static final String VIDEO_ANIMAFLEX = "video/animaflex";
    public static final String VIDEO_AVI = "video/avi";
    public static final String VIDEO_AVS_VIDEO = "video/avs-video";
    public static final String VIDEO_DL = "video/dl";
    public static final String VIDEO_FLI = "video/fli";
    public static final String VIDEO_GL = "video/gl";
    public static final String VIDEO_MPEG = "video/mpeg";
    public static final String VIDEO_MSVIDEO = "video/msvideo";
    public static final String VIDEO_QUICKTIME = "video/quicktime";
    public static final String VIDEO_VDO = "video/vdo";
    public static final String VIDEO_VIVO = "video/vivo";
    public static final String VIDEO_VND_RN_REALVIDEO = "video/vnd.rn-realvideo";
    public static final String VIDEO_VND_VIVO = "video/vnd.vivo";
    public static final String VIDEO_VOSAIC = "video/vosaic";
    public static final String VIDEO_X_AMT_DEMORUN = "video/x-amt-demorun";
    public static final String VIDEO_X_AMT_SHOWRUN = "video/x-amt-showrun";
    public static final String VIDEO_X_ATOMIC3D_FEATURE = "video/x-atomic3d-feature";
    public static final String VIDEO_X_DL = "video/x-dl";
    public static final String VIDEO_X_DV = "video/x-dv";
    public static final String VIDEO_X_FLI = "video/x-fli";
    public static final String VIDEO_X_GL = "video/x-gl";
    public static final String VIDEO_X_ISVIDEO = "video/x-isvideo";
    public static final String VIDEO_X_MOTION_JPEG = "video/x-motion-jpeg";
    public static final String VIDEO_X_MPEG = "video/x-mpeg";
    public static final String VIDEO_X_MPEQ2A = "video/x-mpeq2a";
    public static final String VIDEO_X_MSVIDEO = "video/x-msvideo";
    public static final String VIDEO_X_MS_ASF = "video/x-ms-asf";
    public static final String VIDEO_X_MS_ASF_PLUGIN = "video/x-ms-asf-plugin";
    public static final String VIDEO_X_QTC = "video/x-qtc";
    public static final String VIDEO_X_SCM = "video/x-scm";
    public static final String VIDEO_X_SGI_MOVIE = "video/x-sgi-movie";
    public static final String WINDOWS_METAFILE = "windows/metafile";
    public static final String WWW_MIME = "www/mime";
    public static final String XGL_DRAWING = "xgl/drawing";
    public static final String XGL_MOVIE = "xgl/movie";
    public static final String X_CONFERENCE_X_COOLTALK = "x-conference/x-cooltalk";
    public static final String X_MUSIC_X_MIDI = "x-music/x-midi";
    public static final String X_WORLD_X_3DMF = "x-world/x-3dmf";
    public static final String X_WORLD_X_SVR = "x-world/x-svr";
    public static final String X_WORLD_X_VRML = "x-world/x-vrml";
    public static final String X_WORLD_X_VRT = "x-world/x-vrt";

    public static final String _3DM = "3dm";
    public static final String _3DMF = "3dmf";
    public static final String A = "a";
    public static final String AAB = "aab";
    public static final String AAM = "aam";
    public static final String AAS = "aas";
    public static final String ABC = "abc";
    public static final String ACGI = "acgi";
    public static final String AFL = "afl";
    public static final String AI = "ai";
    public static final String AIF = "aif";
    public static final String AIFC = "aifc";
    public static final String AIFF = "aiff";
    public static final String AIM = "aim";
    public static final String AIP = "aip";
    public static final String ANI = "ani";
    public static final String AOS = "aos";
    public static final String APS = "aps";
    public static final String ARC = "arc";
    public static final String ARJ = "arj";
    public static final String ART = "art";
    public static final String ASF = "asf";
    public static final String ASM = "asm";
    public static final String ASP = "asp";
    public static final String ASX = "asx";
    public static final String AU = "au";
    public static final String AVI = "avi";
    public static final String AVS = "avs";
    public static final String BCPIO = "bcpio";
    public static final String BIN = "bin";
    public static final String BM = "bm";
    public static final String BMP = "bmp";
    public static final String BOO = "boo";
    public static final String BOOK = "book";
    public static final String BOZ = "boz";
    public static final String BSH = "bsh";
    public static final String BZ = "bz";
    public static final String BZ2 = "bz2";
    public static final String C = "c";
    public static final String C_PLUS_PLUS = "c++";
    public static final String CAT = "cat";
    public static final String CC = "cc";
    public static final String CCAD = "ccad";
    public static final String CCO = "cco";
    public static final String CDF = "cdf";
    public static final String CER = "cer";
    public static final String CHA = "cha";
    public static final String CHAT = "chat";
    public static final String CLASS = "class";
    public static final String COM = "com";
    public static final String CONF = "conf";
    public static final String CPIO = "cpio";
    public static final String CPP = "cpp";
    public static final String CPT = "cpt";
    public static final String CRL = "crl";
    public static final String CRT = "crt";
    public static final String CSH = "csh";
    public static final String CSS = "css";
    public static final String CXX = "cxx";
    public static final String DCR = "dcr";
    public static final String DEEPV = "deepv";
    public static final String DEF = "def";
    public static final String DER = "der";
    public static final String DIF = "dif";
    public static final String DIR = "dir";
    public static final String DL = "dl";
    public static final String DOC = "doc";
    public static final String DOT = "dot";
    public static final String DP = "dp";
    public static final String DRW = "drw";
    public static final String DUMP = "dump";
    public static final String DV = "dv";
    public static final String DVI = "dvi";
    public static final String DWF = "dwf";
    public static final String DWG = "dwg";
    public static final String DXF = "dxf";
    public static final String DXR = "dxr";
    public static final String EL = "el";
    public static final String ELC = "elc";
    public static final String ENV = "env";
    public static final String EPS = "eps";
    public static final String ES = "es";
    public static final String ETX = "etx";
    public static final String EVY = "evy";
    public static final String EXE = "exe";
    public static final String F = "f";
    public static final String F77 = "f77";
    public static final String F90 = "f90";
    public static final String FDF = "fdf";
    public static final String FIF = "fif";
    public static final String FLI = "fli";
    public static final String FLO = "flo";
    public static final String FLX = "flx";
    public static final String FMF = "fmf";
    public static final String FOR = "for";
    public static final String FPX = "fpx";
    public static final String FRL = "frl";
    public static final String FUNK = "funk";
    public static final String G = "g";
    public static final String G3 = "g3";
    public static final String GIF = "gif";
    public static final String GL = "gl";
    public static final String GSD = "gsd";
    public static final String GSM = "gsm";
    public static final String GSP = "gsp";
    public static final String GSS = "gss";
    public static final String GTAR = "gtar";
    public static final String GZ = "gz";
    public static final String GZIP = "gzip";
    public static final String H = "h";
    public static final String HDF = "hdf";
    public static final String HELP = "help";
    public static final String HGL = "hgl";
    public static final String HH = "hh";
    public static final String HLB = "hlb";
    public static final String HLP = "hlp";
    public static final String HPG = "hpg";
    public static final String HPGL = "hpgl";
    public static final String HQX = "hqx";
    public static final String HTA = "hta";
    public static final String HTC = "htc";
    public static final String HTM = "htm";
    public static final String HTML = "html";
    public static final String HTMLS = "htmls";
    public static final String HTT = "htt";
    public static final String HTX = "htx";
    public static final String ICE = "ice";
    public static final String ICO = "ico";
    public static final String IDC = "idc";
    public static final String IEF = "ief";
    public static final String IEFS = "iefs";
    public static final String IGES = "iges";
    public static final String IGS = "igs";
    public static final String IMA = "ima";
    public static final String IMAP = "imap";
    public static final String INF = "inf";
    public static final String INS = "ins";
    public static final String IP = "ip";
    public static final String ISU = "isu";
    public static final String IT = "it";
    public static final String IV = "iv";
    public static final String IVR = "ivr";
    public static final String IVY = "ivy";
    public static final String JAM = "jam";
    public static final String JAV = "jav";
    public static final String JAVA = "java";
    public static final String JCM = "jcm";
    public static final String JFIF = "jfif";
    public static final String JFIF_TBNL = "jfif-tbnl";
    public static final String JPE = "jpe";
    public static final String JPEG = "jpeg";
    public static final String JPG = "jpg";
    public static final String JPS = "jps";
    public static final String JS = "js";
    public static final String JSON = "json";
    public static final String JUT = "jut";
    public static final String KAR = "kar";
    public static final String KSH = "ksh";
    public static final String LA = "la";
    public static final String LAM = "lam";
    public static final String LATEX = "latex";
    public static final String LHA = "lha";
    public static final String LHX = "lhx";
    public static final String LIST = "list";
    public static final String LMA = "lma";
    public static final String LOG = "log";
    public static final String LSP = "lsp";
    public static final String LST = "lst";
    public static final String LSX = "lsx";
    public static final String LTX = "ltx";
    public static final String LZH = "lzh";
    public static final String LZX = "lzx";
    public static final String M = "m";
    public static final String M1V = "m1v";
    public static final String M2A = "m2a";
    public static final String M2V = "m2v";
    public static final String M3U = "m3u";
    public static final String MAN = "man";
    public static final String MAP = "map";
    public static final String MAR = "mar";
    public static final String MBD = "mbd";
    public static final String MC$ = "mc$";
    public static final String MCD = "mcd";
    public static final String MCF = "mcf";
    public static final String MCP = "mcp";
    public static final String ME = "me";
    public static final String MHT = "mht";
    public static final String MHTML = "mhtml";
    public static final String MID = "mid";
    public static final String MIDI = "midi";
    public static final String MIF = "mif";
    public static final String MIME = "mime";
    public static final String MJF = "mjf";
    public static final String MJPG = "mjpg";
    public static final String MM = "mm";
    public static final String MME = "mme";
    public static final String MOD = "mod";
    public static final String MOOV = "moov";
    public static final String MOV = "mov";
    public static final String MOVIE = "movie";
    public static final String MP2 = "mp2";
    public static final String MP3 = "mp3";
    public static final String MPA = "mpa";
    public static final String MPC = "mpc";
    public static final String MPE = "mpe";
    public static final String MPEG = "mpeg";
    public static final String MPG = "mpg";
    public static final String MPGA = "mpga";
    public static final String MPP = "mpp";
    public static final String MPT = "mpt";
    public static final String MPV = "mpv";
    public static final String MPX = "mpx";
    public static final String MRC = "mrc";
    public static final String MS = "ms";
    public static final String MV = "mv";
    public static final String MY = "my";
    public static final String MZZ = "mzz";
    public static final String NAP = "nap";
    public static final String NAPLPS = "naplps";
    public static final String NC = "nc";
    public static final String NCM = "ncm";
    public static final String NIF = "nif";
    public static final String NIFF = "niff";
    public static final String NIX = "nix";
    public static final String NSC = "nsc";
    public static final String NVD = "nvd";
    public static final String O = "o";
    public static final String ODA = "oda";
    public static final String OMC = "omc";
    public static final String OMCD = "omcd";
    public static final String OMCR = "omcr";
    public static final String P = "p";
    public static final String P10 = "p10";
    public static final String P12 = "p12";
    public static final String P7A = "p7a";
    public static final String P7C = "p7c";
    public static final String P7M = "p7m";
    public static final String P7R = "p7r";
    public static final String P7S = "p7s";
    public static final String PART = "part";
    public static final String PAS = "pas";
    public static final String PBM = "pbm";
    public static final String PCL = "pcl";
    public static final String PCT = "pct";
    public static final String PCX = "pcx";
    public static final String PDB = "pdb";
    public static final String PDF = "pdf";
    public static final String PFUNK = "pfunk";
    public static final String PGM = "pgm";
    public static final String PIC = "pic";
    public static final String PICT = "pict";
    public static final String PKG = "pkg";
    public static final String PKO = "pko";
    public static final String PL = "pl";
    public static final String PLX = "plx";
    public static final String PM = "pm";
    public static final String PM4 = "pm4";
    public static final String PM5 = "pm5";
    public static final String PNG = "png";
    public static final String PNM = "pnm";
    public static final String POT = "pot";
    public static final String POV = "pov";
    public static final String PPA = "ppa";
    public static final String PPM = "ppm";
    public static final String PPS = "pps";
    public static final String PPT = "ppt";
    public static final String PPZ = "ppz";
    public static final String PRE = "pre";
    public static final String PRT = "prt";
    public static final String PS = "ps";
    public static final String PSD = "psd";
    public static final String PVU = "pvu";
    public static final String PWZ = "pwz";
    public static final String PY = "py";
    public static final String PYC = "pyc";
    public static final String QCP = "qcp";
    public static final String QD3 = "qd3";
    public static final String QD3D = "qd3d";
    public static final String QIF = "qif";
    public static final String QT = "qt";
    public static final String QTC = "qtc";
    public static final String QTI = "qti";
    public static final String QTIF = "qtif";
    public static final String RA = "ra";
    public static final String RAM = "ram";
    public static final String RAS = "ras";
    public static final String RAST = "rast";
    public static final String REXX = "rexx";
    public static final String RF = "rf";
    public static final String RGB = "rgb";
    public static final String RM = "rm";
    public static final String RMI = "rmi";
    public static final String RMM = "rmm";
    public static final String RMP = "rmp";
    public static final String RNG = "rng";
    public static final String RNX = "rnx";
    public static final String ROFF = "roff";
    public static final String RP = "rp";
    public static final String RPM = "rpm";
    public static final String RT = "rt";
    public static final String RTF = "rtf";
    public static final String RTX = "rtx";
    public static final String RV = "rv";
    public static final String S = "s";
    public static final String S3M = "s3m";
    public static final String SAVEME = "saveme";
    public static final String SBK = "sbk";
    public static final String SCM = "scm";
    public static final String SDML = "sdml";
    public static final String SDP = "sdp";
    public static final String SDR = "sdr";
    public static final String SEA = "sea";
    public static final String SET = "set";
    public static final String SGM = "sgm";
    public static final String SGML = "sgml";
    public static final String SH = "sh";
    public static final String SHAR = "shar";
    public static final String SHTML = "shtml";
    public static final String SID = "sid";
    public static final String SIT = "sit";
    public static final String SKD = "skd";
    public static final String SKM = "skm";
    public static final String SKP = "skp";
    public static final String SKT = "skt";
    public static final String SL = "sl";
    public static final String SMI = "smi";
    public static final String SMIL = "smil";
    public static final String SND = "snd";
    public static final String SOL = "sol";
    public static final String SPC = "spc";
    public static final String SPL = "spl";
    public static final String SPR = "spr";
    public static final String SPRITE = "sprite";
    public static final String SRC = "src";
    public static final String SSI = "ssi";
    public static final String SSM = "ssm";
    public static final String SST = "sst";
    public static final String STEP = "step";
    public static final String STL = "stl";
    public static final String STP = "stp";
    public static final String SV4CPIO = "sv4cpio";
    public static final String SV4CRC = "sv4crc";
    public static final String SVF = "svf";
    public static final String SVR = "svr";
    public static final String SWF = "swf";
    public static final String T = "t";
    public static final String TALK = "talk";
    public static final String TAR = "tar";
    public static final String TBK = "tbk";
    public static final String TCL = "tcl";
    public static final String TCSH = "tcsh";
    public static final String TEX = "tex";
    public static final String TEXI = "texi";
    public static final String TEXINFO = "texinfo";
    public static final String TEXT = "text";
    public static final String TGZ = "tgz";
    public static final String TIF = "tif";
    public static final String TIFF = "tiff";
    public static final String TR = "tr";
    public static final String TSI = "tsi";
    public static final String TSP = "tsp";
    public static final String TSV = "tsv";
    public static final String TURBOT = "turbot";
    public static final String TXT = "txt";
    public static final String UIL = "uil";
    public static final String UNI = "uni";
    public static final String UNIS = "unis";
    public static final String UNV = "unv";
    public static final String URI = "uri";
    public static final String URIS = "uris";
    public static final String USTAR = "ustar";
    public static final String UU = "uu";
    public static final String UUE = "uue";
    public static final String VCD = "vcd";
    public static final String VCS = "vcs";
    public static final String VDA = "vda";
    public static final String VDO = "vdo";
    public static final String VEW = "vew";
    public static final String VIV = "viv";
    public static final String VIVO = "vivo";
    public static final String VMD = "vmd";
    public static final String VMF = "vmf";
    public static final String VOC = "voc";
    public static final String VOS = "vos";
    public static final String VOX = "vox";
    public static final String VQE = "vqe";
    public static final String VQF = "vqf";
    public static final String VQL = "vql";
    public static final String VRML = "vrml";
    public static final String VRT = "vrt";
    public static final String VSD = "vsd";
    public static final String VST = "vst";
    public static final String VSW = "vsw";
    public static final String W60 = "w60";
    public static final String W61 = "w61";
    public static final String W6W = "w6w";
    public static final String WAV = "wav";
    public static final String WB1 = "wb1";
    public static final String WBMP = "wbmp";
    public static final String WEB = "routing";
    public static final String WIZ = "wiz";
    public static final String WK1 = "wk1";
    public static final String WMF = "wmf";
    public static final String WML = "wml";
    public static final String WMLC = "wmlc";
    public static final String WMLS = "wmls";
    public static final String WMLSC = "wmlsc";
    public static final String WORD = "word";
    public static final String WP = "wp";
    public static final String WP5 = "wp5";
    public static final String WP6 = "wp6";
    public static final String WPD = "wpd";
    public static final String WQ1 = "wq1";
    public static final String WRI = "wri";
    public static final String WRL = "wrl";
    public static final String WRZ = "wrz";
    public static final String WSC = "wsc";
    public static final String WSRC = "wsrc";
    public static final String WTK = "wtk";
    public static final String X_PNG = "x-png";
    public static final String XBM = "xbm";
    public static final String XDR = "xdr";
    public static final String XGZ = "xgz";
    public static final String XIF = "xif";
    public static final String XL = "xl";
    public static final String XLA = "xla";
    public static final String XLB = "xlb";
    public static final String XLC = "xlc";
    public static final String XLD = "xld";
    public static final String XLK = "xlk";
    public static final String XLL = "xll";
    public static final String XLM = "xlm";
    public static final String XLS = "xls";
    public static final String XLT = "xlt";
    public static final String XLV = "xlv";
    public static final String XLW = "xlw";
    public static final String XM = "xm";
    public static final String XML = "xml";
    public static final String XMZ = "xmz";
    public static final String XPIX = "xpix";
    public static final String XPM = "xpm";
    public static final String XSR = "xsr";
    public static final String XWD = "xwd";
    public static final String XYZ = "xyz";
    public static final String Z = "z";
    public static final String ZIP = "zip";
    public static final String ZOO = "zoo";
    public static final String ZSH = "zsh";

    private static final Map<String,String> mimeTypes;

    static {
        mimeTypes = new HashMap<>();
        mimeTypes.put(_3DM, X_WORLD_X_3DMF);
        mimeTypes.put(A, APPLICATION_OCTET_STREAM);
        mimeTypes.put(AAB, APPLICATION_X_AUTHORWARE_BIN);
        mimeTypes.put(AAM, APPLICATION_X_AUTHORWARE_MAP);
        mimeTypes.put(AAS, APPLICATION_X_AUTHORWARE_SEG);
        mimeTypes.put(ABC, TEXT_VND_ABC);
        mimeTypes.put(ACGI, TEXT_HTML);
        mimeTypes.put(AFL, VIDEO_ANIMAFLEX);
        mimeTypes.put(AI, APPLICATION_POSTSCRIPT);
        mimeTypes.put(AIF, AUDIO_AIFF);
        mimeTypes.put(AIM, APPLICATION_X_AIM);
        mimeTypes.put(AIP, TEXT_X_AUDIOSOFT_INTRA);
        mimeTypes.put(ANI, APPLICATION_X_NAVI_ANIMATION);
        mimeTypes.put(AOS, APPLICATION_X_NOKIA_9000_COMMUNICATOR_ADD_ON_SOFTWARE);
        mimeTypes.put(APS, APPLICATION_MIME);
        mimeTypes.put(ARJ, APPLICATION_ARJ);
        mimeTypes.put(ART, IMAGE_X_JG);
        mimeTypes.put(ASF, VIDEO_X_MS_ASF);
        mimeTypes.put(ASM, TEXT_X_ASM);
        mimeTypes.put(ASP, TEXT_ASP);
        mimeTypes.put(ASX, APPLICATION_X_MPLAYER2);
        mimeTypes.put(AU, AUDIO_BASIC);
        mimeTypes.put(AVI, APPLICATION_X_TROFF_MSVIDEO);
        mimeTypes.put(AVS, VIDEO_AVS_VIDEO);
        mimeTypes.put(BCPIO, APPLICATION_X_BCPIO);
        mimeTypes.put(BIN, APPLICATION_MAC_BINARY);
        mimeTypes.put(BM, IMAGE_BMP);
        mimeTypes.put(BOO, APPLICATION_BOOK);
        mimeTypes.put(BOZ, APPLICATION_X_BZIP2);
        mimeTypes.put(BSH, APPLICATION_X_BSH);
        mimeTypes.put(BZ, APPLICATION_X_BZIP);
        mimeTypes.put(C, TEXT_PLAIN);
        mimeTypes.put(CAT, APPLICATION_VND_MS_PKI_SECCAT);
        mimeTypes.put(CCAD, APPLICATION_CLARISCAD);
        mimeTypes.put(CCO, APPLICATION_X_COCOA);
        mimeTypes.put(CDF, APPLICATION_CDF);
        mimeTypes.put(CER, APPLICATION_PKIX_CERT);
        mimeTypes.put(CHA, APPLICATION_X_CHAT);
        mimeTypes.put(CLASS, APPLICATION_JAVA);
        mimeTypes.put(CPIO, APPLICATION_X_CPIO);
        mimeTypes.put(CPT, APPLICATION_MAC_COMPACTPRO);
        mimeTypes.put(CRL, APPLICATION_PKCS_CRL);
        mimeTypes.put(CSH, APPLICATION_X_CSH);
        mimeTypes.put(CSS, TEXT_CSS);
        mimeTypes.put(DCR, APPLICATION_X_DIRECTOR);
        mimeTypes.put(DEEPV, APPLICATION_X_DEEPV);
        mimeTypes.put(DIF, VIDEO_X_DV);
        mimeTypes.put(DL, VIDEO_DL);
        mimeTypes.put(DOC, APPLICATION_MSWORD);
        mimeTypes.put(DP, APPLICATION_COMMONGROUND);
        mimeTypes.put(DRW, APPLICATION_DRAFTING);
        mimeTypes.put(DVI, APPLICATION_X_DVI);
        mimeTypes.put(DWF, DRAWING_X_DWF);
        mimeTypes.put(DWG, APPLICATION_ACAD);
        mimeTypes.put(DXF, APPLICATION_DXF);
        mimeTypes.put(EL, TEXT_X_SCRIPT_ELISP);
        mimeTypes.put(ELC, APPLICATION_X_BYTECODE_ELISP);
        mimeTypes.put(ENV, APPLICATION_X_ENVOY);
        mimeTypes.put(ES, APPLICATION_X_ESREHBER);
        mimeTypes.put(ETX, TEXT_X_SETEXT);
        mimeTypes.put(EVY, APPLICATION_ENVOY);
        mimeTypes.put(FDF, APPLICATION_VND_FDF);
        mimeTypes.put(FIF, APPLICATION_FRACTALS);
        mimeTypes.put(FLI, VIDEO_FLI);
        mimeTypes.put(FLO, IMAGE_FLORIAN);
        mimeTypes.put(FLX, TEXT_VND_FMI_FLEXSTOR);
        mimeTypes.put(FMF, VIDEO_X_ATOMIC3D_FEATURE);
        mimeTypes.put(FPX, IMAGE_VND_FPX);
        mimeTypes.put(FRL, APPLICATION_FREELOADER);
        mimeTypes.put(FUNK, AUDIO_MAKE);
        mimeTypes.put(G3, IMAGE_G3FAX);
        mimeTypes.put(GIF, IMAGE_GIF);
        mimeTypes.put(GL, VIDEO_GL);
        mimeTypes.put(GSD, AUDIO_X_GSM);
        mimeTypes.put(GSP, APPLICATION_X_GSP);
        mimeTypes.put(GSS, APPLICATION_X_GSS);
        mimeTypes.put(GTAR, APPLICATION_X_GTAR);
        mimeTypes.put(GZ, APPLICATION_X_COMPRESSED);
        mimeTypes.put(HDF, APPLICATION_X_HDF);
        mimeTypes.put(HELP, APPLICATION_X_HELPFILE);
        mimeTypes.put(HGL, APPLICATION_VND_HP_HPGL);
        mimeTypes.put(HLB, TEXT_X_SCRIPT);
        mimeTypes.put(HLP, APPLICATION_HLP);
        mimeTypes.put(HQX, APPLICATION_BINHEX);
        mimeTypes.put(HTA, APPLICATION_HTA);
        mimeTypes.put(HTC, TEXT_X_COMPONENT);
        mimeTypes.put(HTT, TEXT_WEBVIEWHTML);
        mimeTypes.put(ICE, X_CONFERENCE_X_COOLTALK);
        mimeTypes.put(ICO, IMAGE_X_ICON);
        mimeTypes.put(IEF, IMAGE_IEF);
        mimeTypes.put(IGES, APPLICATION_IGES);
        mimeTypes.put(IMA, APPLICATION_X_IMA);
        mimeTypes.put(IMAP, APPLICATION_X_HTTPD_IMAP);
        mimeTypes.put(INF, APPLICATION_INF);
        mimeTypes.put(INS, APPLICATION_X_INTERNETT_SIGNUP);
        mimeTypes.put(IP, APPLICATION_X_IP2);
        mimeTypes.put(ISU, VIDEO_X_ISVIDEO);
        mimeTypes.put(IT, AUDIO_IT);
        mimeTypes.put(IV, APPLICATION_X_INVENTOR);
        mimeTypes.put(IVR, I_WORLD_I_VRML);
        mimeTypes.put(IVY, APPLICATION_X_LIVESCREEN);
        mimeTypes.put(JAVA, APPLICATION_JAVA);
        mimeTypes.put(JAM, AUDIO_X_JAM);
        mimeTypes.put(JCM, APPLICATION_X_JAVA_COMMERCE);
        mimeTypes.put(JFIF, IMAGE_JPEG);
        mimeTypes.put(JPS, IMAGE_X_JPS);
        mimeTypes.put(JPEG, IMAGE_JPEG);
        mimeTypes.put(JS, APPLICATION_X_JAVASCRIPT);
        mimeTypes.put(JUT, IMAGE_JUTVISION);
        mimeTypes.put(JSON, APPLICATION_JSON);
        mimeTypes.put(KAR, AUDIO_MIDI);
        mimeTypes.put(KSH, APPLICATION_X_KSH);
        mimeTypes.put(LA, AUDIO_NSPAUDIO);
        mimeTypes.put(LAM, AUDIO_X_LIVEAUDIO);
        mimeTypes.put(LATEX, APPLICATION_X_LATEX);
        mimeTypes.put(LHA, APPLICATION_LHA);
        mimeTypes.put(LSP, APPLICATION_X_LISP);
        mimeTypes.put(LSX, TEXT_X_LA_ASF);
        mimeTypes.put(LZX, APPLICATION_LZX);
        mimeTypes.put(M1V, VIDEO_MPEG);
        mimeTypes.put(M2A, AUDIO_MPEG);
        mimeTypes.put(M3U, AUDIO_X_MPEQURL);
        mimeTypes.put(MAN, APPLICATION_X_TROFF_MAN);
        mimeTypes.put(MAP, APPLICATION_X_NAVIMAP);
        mimeTypes.put(MBD, APPLICATION_MBEDLET);
        mimeTypes.put(MC$, APPLICATION_X_MAGIC_CAP_PACKAGE_1_0);
        mimeTypes.put(MCD, APPLICATION_MCAD);
        mimeTypes.put(MCF, IMAGE_VASA);
        mimeTypes.put(MCP, APPLICATION_NETMC);
        mimeTypes.put(ME, APPLICATION_X_TROFF_ME);
        mimeTypes.put(MHT, MESSAGE_RFC822);
        mimeTypes.put(MID, APPLICATION_X_MIDI);
        mimeTypes.put(MIF, APPLICATION_X_FRAME);
        mimeTypes.put(MJF, AUDIO_X_VND_AUDIOEXPLOSION_MJUICEMEDIAFILE);
        mimeTypes.put(MJPG, VIDEO_X_MOTION_JPEG);
        mimeTypes.put(MM, APPLICATION_BASE64);
        mimeTypes.put(MOD, AUDIO_MOD);
        mimeTypes.put(MOOV, VIDEO_QUICKTIME);
        mimeTypes.put(MOVIE, VIDEO_X_SGI_MOVIE);
        mimeTypes.put(MP3, AUDIO_MPEG3);
        mimeTypes.put(MPC, APPLICATION_X_PROJECT);
        mimeTypes.put(MPP, APPLICATION_VND_MS_PROJECT);
        mimeTypes.put(MRC, APPLICATION_MARC);
        mimeTypes.put(MS, APPLICATION_X_TROFF_MS);
        mimeTypes.put(MZZ, APPLICATION_X_VND_AUDIOEXPLOSION_MZZ);
        mimeTypes.put(NAP, IMAGE_NAPLPS);
        mimeTypes.put(NCM, APPLICATION_VND_NOKIA_CONFIGURATION_MESSAGE);
        mimeTypes.put(NIF, IMAGE_X_NIFF);
        mimeTypes.put(NIX, APPLICATION_X_MIX_TRANSFER);
        mimeTypes.put(NSC, APPLICATION_X_CONFERENCE);
        mimeTypes.put(NVD, APPLICATION_X_NAVIDOC);
        mimeTypes.put(ODA, APPLICATION_ODA);
        mimeTypes.put(OMC, APPLICATION_X_OMC);
        mimeTypes.put(OMCD, APPLICATION_X_OMCDATAMAKER);
        mimeTypes.put(OMCR, APPLICATION_X_OMCREGERATOR);
        mimeTypes.put(P, TEXT_X_PASCAL);
        mimeTypes.put(P10, APPLICATION_PKCS10);
        mimeTypes.put(P12, APPLICATION_PKCS_12);
        mimeTypes.put(P7A, APPLICATION_X_PKCS7_SIGNATURE);
        mimeTypes.put(P7C, APPLICATION_PKCS7_MIME);
        mimeTypes.put(P7R, APPLICATION_X_PKCS7_CERTREQRESP);
        mimeTypes.put(P7S, APPLICATION_PKCS7_SIGNATURE);
        mimeTypes.put(PART, APPLICATION_PRO_ENG);
        mimeTypes.put(PAS, TEXT_PASCAL);
        mimeTypes.put(PBM, IMAGE_X_PORTABLE_BITMAP);
        mimeTypes.put(PCL, APPLICATION_VND_HP_PCL);
        mimeTypes.put(PCT, IMAGE_X_PICT);
        mimeTypes.put(PCX, IMAGE_X_PCX);
        mimeTypes.put(PDB, CHEMICAL_X_PDB);
        mimeTypes.put(PDF, APPLICATION_PDF);
        mimeTypes.put(PGM, IMAGE_X_PORTABLE_GRAYMAP);
        mimeTypes.put(PIC, IMAGE_PICT);
        mimeTypes.put(PKG, APPLICATION_X_NEWTON_COMPATIBLE_PKG);
        mimeTypes.put(PKO, APPLICATION_VND_MS_PKI_PKO);
        mimeTypes.put(PLX, APPLICATION_X_PIXCLSCRIPT);
        mimeTypes.put(PM, IMAGE_X_XPIXMAP);
        mimeTypes.put(PM4, APPLICATION_X_PAGEMAKER);
        mimeTypes.put(PNG, IMAGE_PNG);
        mimeTypes.put(PNM, APPLICATION_X_PORTABLE_ANYMAP);
        mimeTypes.put(POT, APPLICATION_MSPOWERPOINT);
        mimeTypes.put(POV, MODEL_X_POV);
        mimeTypes.put(PPM, IMAGE_X_PORTABLE_PIXMAP);
        mimeTypes.put(PRE, APPLICATION_X_FREELANCE);
        mimeTypes.put(PVU, PALEOVU_X_PV);
        mimeTypes.put(PY, TEXT_X_SCRIPT_PHYTON);
        mimeTypes.put(PYC, APPLICATION_X_BYTECODE_PYTHON);
        mimeTypes.put(QCP, AUDIO_VND_QCELP);
        mimeTypes.put(QIF, IMAGE_X_QUICKTIME);
        mimeTypes.put(QTC, VIDEO_X_QTC);
        mimeTypes.put(RA, AUDIO_X_PN_REALAUDIO);
        mimeTypes.put(RAS, APPLICATION_X_CMU_RASTER);
        mimeTypes.put(REXX, TEXT_X_SCRIPT_REXX);
        mimeTypes.put(RF, IMAGE_VND_RN_REALFLASH);
        mimeTypes.put(RGB, IMAGE_X_RGB);
        mimeTypes.put(RM, APPLICATION_VND_RN_REALMEDIA);
        mimeTypes.put(RMI, AUDIO_MID);
        mimeTypes.put(RNG, APPLICATION_RINGING_TONES);
        mimeTypes.put(RNX, APPLICATION_VND_RN_REALPLAYER);
        mimeTypes.put(ROFF, APPLICATION_X_TROFF);
        mimeTypes.put(RP, IMAGE_VND_RN_REALPIX);
        mimeTypes.put(RT, TEXT_RICHTEXT);
        mimeTypes.put(RTF, APPLICATION_RTF);
        mimeTypes.put(RV, VIDEO_VND_RN_REALVIDEO);
        mimeTypes.put(S3M, AUDIO_S3M);
        mimeTypes.put(SBK, APPLICATION_X_TBOOK);
        mimeTypes.put(SCM, APPLICATION_X_LOTUSSCREENCAM);
        mimeTypes.put(SDP, APPLICATION_SDP);
        mimeTypes.put(SDR, APPLICATION_SOUNDER);
        mimeTypes.put(SEA, APPLICATION_SEA);
        mimeTypes.put(SET, APPLICATION_SET);
        mimeTypes.put(SGM, TEXT_SGML);
        mimeTypes.put(SID, AUDIO_X_PSID);
        mimeTypes.put(SIT, APPLICATION_X_SIT);
        mimeTypes.put(SKD, APPLICATION_X_KOAN);
        mimeTypes.put(SL, APPLICATION_X_SEELOGO);
        mimeTypes.put(SMI, APPLICATION_SMIL);
        mimeTypes.put(SOL, APPLICATION_SOLIDS);
        mimeTypes.put(SPC, APPLICATION_X_PKCS7_CERTIFICATES);
        mimeTypes.put(SPL, APPLICATION_FUTURESPLASH);
        mimeTypes.put(SPR, APPLICATION_X_SPRITE);
        mimeTypes.put(SRC, APPLICATION_X_WAIS_SOURCE);
        mimeTypes.put(SSM, APPLICATION_STREAMINGMEDIA);
        mimeTypes.put(SST, APPLICATION_VND_MS_PKI_CERTSTORE);
        mimeTypes.put(STEP, APPLICATION_STEP);
        mimeTypes.put(STL, APPLICATION_SLA);
        mimeTypes.put(SV4CPIO, APPLICATION_X_SV4CPIO);
        mimeTypes.put(SV4CRC, APPLICATION_X_SV4CRC);
        mimeTypes.put(SVR, APPLICATION_X_WORLD);
        mimeTypes.put(SWF, APPLICATION_X_SHOCKWAVE_FLASH);
        mimeTypes.put(TAR, APPLICATION_X_TAR);
        mimeTypes.put(TBK, APPLICATION_TOOLBOOK);
        mimeTypes.put(TCL, APPLICATION_X_TCL);
        mimeTypes.put(TCSH, TEXT_X_SCRIPT_TCSH);
        mimeTypes.put(TEX, APPLICATION_X_TEX);
        mimeTypes.put(TEXI, APPLICATION_X_TEXINFO);
        mimeTypes.put(TEXT, APPLICATION_PLAIN);
        mimeTypes.put(TGZ, APPLICATION_GNUTAR);
        mimeTypes.put(TIF, IMAGE_TIFF);
        mimeTypes.put(TSI, AUDIO_TSP_AUDIO);
        mimeTypes.put(TSP, APPLICATION_DSPTYPE);
        mimeTypes.put(TSV, TEXT_TAB_SEPARATED_VALUES);
        mimeTypes.put(UIL, TEXT_X_UIL);
        mimeTypes.put(UNI, TEXT_URI_LIST);
        mimeTypes.put(UNV, APPLICATION_I_DEAS);
        mimeTypes.put(USTAR, APPLICATION_X_USTAR);
        mimeTypes.put(VCD, APPLICATION_X_CDLINK);
        mimeTypes.put(VCS, TEXT_X_VCALENDAR);
        mimeTypes.put(VDA, APPLICATION_VDA);
        mimeTypes.put(VDO, VIDEO_VDO);
        mimeTypes.put(VEW, APPLICATION_GROUPWISE);
        mimeTypes.put(VIV, VIDEO_VIVO);
        mimeTypes.put(VMD, APPLICATION_VOCALTEC_MEDIA_DESC);
        mimeTypes.put(VMF, APPLICATION_VOCALTEC_MEDIA_FILE);
        mimeTypes.put(VOC, AUDIO_VOC);
        mimeTypes.put(VOS, VIDEO_VOSAIC);
        mimeTypes.put(VOX, AUDIO_VOXWARE);
        mimeTypes.put(VQE, AUDIO_X_TWINVQ_PLUGIN);
        mimeTypes.put(VQF, AUDIO_X_TWINVQ);
        mimeTypes.put(VRML, APPLICATION_X_VRML);
        mimeTypes.put(VRT, X_WORLD_X_VRT);
        mimeTypes.put(VSD, APPLICATION_X_VISIO);
        mimeTypes.put(W60, APPLICATION_WORDPERFECT6_0);
        mimeTypes.put(W61, APPLICATION_WORDPERFECT6_1);
        mimeTypes.put(WAV, AUDIO_WAV);
        mimeTypes.put(WB1, APPLICATION_X_QPRO);
        mimeTypes.put(WBMP, IMAGE_VND_WAP_WBMP);
        mimeTypes.put(WEB, APPLICATION_VND_XARA);
        mimeTypes.put(WK1, APPLICATION_X_123);
        mimeTypes.put(WMF, WINDOWS_METAFILE);
        mimeTypes.put(WML, TEXT_VND_WAP_WML);
        mimeTypes.put(WMLC, APPLICATION_VND_WAP_WMLC);
        mimeTypes.put(WMLS, TEXT_VND_WAP_WMLSCRIPT);
        mimeTypes.put(WMLSC, APPLICATION_VND_WAP_WMLSCRIPTC);
        mimeTypes.put(WP, APPLICATION_WORDPERFECT);
        mimeTypes.put(WQ1, APPLICATION_X_LOTUS);
        mimeTypes.put(WRI, APPLICATION_MSWRITE);
        mimeTypes.put(WSC, TEXT_SCRIPLET);
        mimeTypes.put(WTK, APPLICATION_X_WINTALK);
        mimeTypes.put(XBM, IMAGE_X_XBITMAP);
        mimeTypes.put(XDR, VIDEO_X_AMT_DEMORUN);
        mimeTypes.put(XGZ, XGL_DRAWING);
        mimeTypes.put(XIF, IMAGE_VND_XIFF);
        mimeTypes.put(XL, APPLICATION_EXCEL);
        mimeTypes.put(XM, AUDIO_XM);
        mimeTypes.put(XML, APPLICATION_XML);
        mimeTypes.put(XMZ, XGL_MOVIE);
        mimeTypes.put(XPIX, APPLICATION_X_VND_LS_XPIX);
        mimeTypes.put(XSR, VIDEO_X_AMT_SHOWRUN);
        mimeTypes.put(XWD, IMAGE_X_XWD);
        mimeTypes.put(Z, APPLICATION_X_COMPRESS);
        mimeTypes.put(ZSH, TEXT_X_SCRIPT_ZSH);
    }

    /**
     * Get the mime type for a given File
     * @param file File to obtain the mime type
     * @return
     */
    public static String getMimeType (File file) {
        return getMimeType(file.getName());
    }

    /**
     * Get the mime type for a given filename
     * @param filename Filename to obtain the mime type
     * @return
     */
    public static String getMimeType (String filename) {
        String[] nameExtension = filename.split(FILE_EXTENSION_REGEX);
        String extension = nameExtension.length == 2 ? nameExtension[1] : MimeUtils.BIN;
        String mimeType =  mimeTypes.get(extension);
        if (mimeType == null) {
            mimeType = TEXT_PLAIN;
        }
        return mimeType;
    }
}
