/*
 * Decompiled with CFR 0.152.
 */
package javabase.lorenwang.common_base_frame.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javabase.lorenwang.common_base_frame.SbcbflwCommon;
import javabase.lorenwang.common_base_frame.bean.SbcbflwBaseDataDisposeStatusBean;
import javabase.lorenwang.common_base_frame.controller.SbcbflwBaseHttpServletRequestWrapper;
import javabase.lorenwang.common_base_frame.database.table.SbcbflwBaseUserInfoTb;
import javabase.lorenwang.common_base_frame.utils.SbcbfBaseAllUtils;
import javabase.lorenwang.tools.common.JtlwCheckVariateUtils;
import javabase.lorenwang.tools.dataConversion.JtlwCodeConversionUtil;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;

public abstract class SbcbflwBaseControllerFilter<T extends SbcbflwBaseHttpServletRequestWrapper>
implements Filter {
    private final String TAG = "SbcbflwBaseControllerFilter";
    private final List<String> swaggerPathList = new ArrayList<String>();

    public SbcbflwBaseControllerFilter() {
        this.swaggerPathList.add("/swagger-ui.html");
        this.swaggerPathList.add("/swagger-resources");
        this.swaggerPathList.add("/v2/api-docs");
        this.swaggerPathList.add("/webjars/.+");
        this.swaggerPathList.add("/swagger-resources/.+");
    }

    public void init(FilterConfig filterConfig) {
        SbcbfBaseAllUtils.getLogUtils().logI(this.getClass(), "\u521d\u59cb\u5316\u7b5b\u9009\u5668", false);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        T req = this.paramsRequest(request);
        HttpServletResponse rep = (HttpServletResponse)response;
        if (SbcbflwCommon.getInstance().propertiesConfig.isDebug()) {
            rep.setHeader("Access-Control-Allow-Origin", "*");
            rep.setHeader("Access-Control-Allow-Methods", "POST, GET, PUT, OPTIONS, DELETE, PATCH");
            rep.setHeader("Access-Control-Max-Age", "3600");
            rep.setHeader("Access-Control-Allow-Headers", "" + SbcbflwCommon.getInstance().propertiesConfig.getHeaderTokenKeyName() + ",Origin, X-Requested-With, Content-Type, Accept,Access-Control-Allow-Headers,Origin, X-Requested-With, Content-Type, Accept,WG-App-Version, WG-Device-Id, WG-Network-Type, WG-Vendor, WG-OS-Type, WG-OS-Version, WG-Device-Model, WG-CPU, WG-Sid, WG-App-Id, WG-Token");
            rep.setCharacterEncoding("UTF-8");
            String method = ((HttpServletRequest)request).getMethod();
            if ("OPTIONS".equals(method)) {
                rep.setStatus(204);
                return;
            }
        } else {
            String servletPath = req.getServletPath();
            for (String item : this.swaggerPathList) {
                if (!servletPath.matches(item)) continue;
                SbcbfBaseAllUtils.getLogUtils().logI(this.getClass(), "\u8bf7\u6c42\u7684\u662f(" + servletPath + ")\u63a5\u53e3,\u6b63\u5f0f\u73af\u5883\u4e0b\u7981\u6b62\u8bbf\u95ee!", false);
                return;
            }
        }
        if (SbcbflwCommon.getInstance().getPropertiesConfig().getHaveUserSystem()) {
            rep.setHeader("Access-Control-Expose-Headers", SbcbflwCommon.getInstance().getUserService().getAccessTokenByReqHeader((SbcbflwBaseHttpServletRequestWrapper)((Object)req)));
            req.setAttribute("userInfoKey", (Object)"");
            String reqUrl = req.getRequestURI();
            if (JtlwCheckVariateUtils.getInstance().isEmpty((Object)SbcbflwCommon.getInstance().getUserService().getAccessTokenByReqHeader((SbcbflwBaseHttpServletRequestWrapper)((Object)req)))) {
                SbcbfBaseAllUtils.getLogUtils().logI(this.getClass(), reqUrl + "\u63a5\u6536\u5230\u65e0token\u63a5\u53e3\u8bf7\u6c42\uff0c\u6b63\u5e38\u53d1\u8d77", false);
                chain.doFilter(req, response);
            } else {
                SbcbfBaseAllUtils.getLogUtils().logI(this.getClass(), reqUrl + "\u63a5\u6536\u5230token\u63a5\u53e3\u8bf7\u6c42\uff0c\u5f00\u59cb\u6821\u9a8c\u7528\u6237\u4fe1\u606f", false);
                SbcbflwBaseDataDisposeStatusBean userStatus = SbcbflwCommon.getInstance().getUserService().checkUserLogin((SbcbflwBaseHttpServletRequestWrapper)((Object)req));
                if (userStatus.getStatusResult() && userStatus.getBody() != null && userStatus.getBody() instanceof SbcbflwBaseUserInfoTb) {
                    SbcbfBaseAllUtils.getLogUtils().logD(this.getClass(), reqUrl + "\u7528\u6237\u4fe1\u606f\u6821\u9a8c\u5b8c\u6bd5,\u5f53\u524d\u7528\u6237\u5b58\u5728\u5e76\u662f\u767b\u5f55\u72b6\u6001", false);
                    String accessToken = JtlwCodeConversionUtil.getInstance().unicodeToChinese(((SbcbflwBaseUserInfoTb)userStatus.getBody()).getAccessToken());
                    String newToken = SbcbflwCommon.getInstance().getUserService().refreshAccessToken(accessToken);
                    if (JtlwCheckVariateUtils.getInstance().isNotEmpty((Object)newToken) && accessToken.equals(newToken)) {
                        ((SbcbflwBaseUserInfoTb)userStatus.getBody()).setAccessToken(newToken);
                        rep.setHeader(this.getHeaderAccessTokenKey(), newToken);
                        ((SbcbflwBaseHttpServletRequestWrapper)((Object)req)).addHeader(this.getHeaderAccessTokenKey(), newToken);
                        SbcbfBaseAllUtils.getLogUtils().logI(this.getClass(), "token\u5df2\u66f4\u65b0", false);
                    } else {
                        ((SbcbflwBaseUserInfoTb)userStatus.getBody()).setAccessToken(accessToken);
                        rep.setHeader(this.getHeaderAccessTokenKey(), accessToken);
                        ((SbcbflwBaseHttpServletRequestWrapper)((Object)req)).addHeader(this.getHeaderAccessTokenKey(), accessToken);
                    }
                    req.setAttribute("userInfoKey", userStatus.getBody());
                    SbcbfBaseAllUtils.getLogUtils().logD(this.getClass(), reqUrl + "\u6b63\u5e38\u53d1\u8d77\u8bf7\u6c42", false);
                    chain.doFilter(req, response);
                } else {
                    SbcbfBaseAllUtils.getLogUtils().logD(this.getClass(), reqUrl + "token\u65e0\u6548\u6216\u8005\u4e0d\u5b58\u5728", false);
                    String responseFailInfo = this.responseErrorUser(userStatus);
                    rep.setHeader("content-type", "text/html;charset=UTF-8");
                    rep.getOutputStream().write(responseFailInfo.getBytes());
                    rep.setStatus(20);
                }
            }
        } else {
            chain.doFilter(req, response);
        }
    }

    public void destroy() {
        SbcbfBaseAllUtils.getLogUtils().logI(this.getClass(), "\u9500\u6bc1\u7b5b\u9009\u5668", false);
    }

    public String responseErrorUser(SbcbflwBaseDataDisposeStatusBean errorInfo) {
        return null;
    }

    @NotNull
    public abstract T paramsRequest(ServletRequest var1);

    @NotNull
    public abstract String getHeaderAccessTokenKey();
}

