package com.github.javaparser.symbolsolver.cache;

import java.util.Optional;

import com.github.benmanes.caffeine.cache.Caffeine;

/**
 * CaffeineCache.
 * @author lontme
 * @since 1.0
 * @param <K> K
 * @param <V> V
 */
public class CaffeineCache<K, V> implements Cache<K, V>  {

    private final com.github.benmanes.caffeine.cache.Cache<K, V> caffeineCache;

    public CaffeineCache() {
        this.caffeineCache = Caffeine.newBuilder().softValues().build();
    }

    public CaffeineCache(long maximumSize) {
        this.caffeineCache = Caffeine.newBuilder()
                .maximumSize(maximumSize).softValues().build();
    }

    @Override
    public void put(K key, V value) {
        caffeineCache.put(key, value);
    }

    @Override
    public Optional<V> get(K key) {
        return Optional.ofNullable(
                caffeineCache.getIfPresent(key)
        );
    }

    @Override
    public void remove(K key) {
        caffeineCache.invalidate(key);
    }

    @Override
    public void removeAll() {
        caffeineCache.invalidateAll();
    }

    @Override
    public boolean contains(K key) {
        return get(key).isPresent();
    }

    @Override
    public long size() {
        return caffeineCache.estimatedSize();
    }

    @Override
    public boolean isEmpty() {
        return size() == 0;
    }
}
