package com.github.lontime.base.workflow.provider;

import com.github.lontime.base.commonj.utils.LoggerHelper;
import com.github.lontime.base.serial.codec.MsgCodec;
import com.github.lontime.base.serial.codec.ObjectMsgCodec;
import com.github.lontime.base.serial.codec.StringMsgCodec;

/**
 * Provider.
 * start normal end, restart destroy
 * @author lontime
 * @since 1.0
 */
public interface Provider extends AutoCloseable {

    String START_NAME = "start";

    String STATE_NAME = "state";

    String RESTART_NAME = "restart";

    String END_NAME = "end";

    String DESTROY_NAME = "destroy";

    /**
     * getName.
     *
     * @return String
     */
    String getName();

    /**
     * push.
     * @param schemaName schemaName
     * @param stepName stepName
     * @param params params
     * @param codec codec
     * @param <RES> response
     * @param <REQ> request
     * @return response
     */
    <REQ, RES> RES push(String schemaName, String stepName, REQ params, MsgCodec<REQ, RES> codec);

    /**
     * push.
     * @param schemaName schemaName
     * @param params params
     * @param codec codec
     * @param methodName methodName
     * @param <RES> response
     * @param <REQ> request
     * @return state
     */
    <REQ, RES> RES state(String schemaName, String methodName, REQ params, MsgCodec<REQ, RES> codec);

    /**
     * push.
     * @param schemaName schemaName
     * @param id id
     * @return state
     */
    default String state(String schemaName, String id) {
        return state(schemaName, STATE_NAME, id, StringMsgCodec.INSTANCE);
    }

    /**
     * push.
     * @param schemaName schemaName
     * @param params params
     * @param codec codec
     * @param <RES> response
     * @param <REQ> request
     * @return response
     */
    default <REQ, RES> RES state(String schemaName, REQ params, MsgCodec<REQ, RES> codec) {
        return state(schemaName, STATE_NAME, params, codec);
    }

    /**
     * start.
     * @param schemaName schemaName
     * @param params params
     * @param codec codec
     * @param <RES> response
     * @param <REQ> request
     * @return response
     */
    default <REQ, RES> RES start(String schemaName, REQ params, MsgCodec<REQ, RES> codec) {
        return start(schemaName, START_NAME, params, codec);
    }

    /**
     * start.
     * @param schemaName schemaName
     * @param stepName stepName
     * @param params params
     * @param codec codec
     * @param <RES> response
     * @param <REQ> request
     * @return response
     */
    <REQ, RES> RES start(String schemaName, String stepName, REQ params, MsgCodec<REQ, RES> codec);

    /**
     * start.
     * @param schemaName schemaName
     * @param params params
     * @param codec codec
     * @param <RES> response
     * @param <REQ> request
     * @return response
     */
    default <REQ, RES> RES restart(String schemaName, REQ params, MsgCodec<REQ, RES> codec) {
        return restart(schemaName, RESTART_NAME, params, codec);
    }

    /**
     * end.
     * @param schemaName schemaName
     * @param stepName stepName
     * @param params params
     * @param codec codec
     * @param <RES> response
     * @param <REQ> request
     * @return response
     */
    <REQ, RES> RES restart(String schemaName, String stepName, REQ params, MsgCodec<REQ, RES> codec);

    /**
     * start.
     * @param schemaName schemaName
     * @param params params
     * @param codec codec
     * @param <RES> response
     * @param <REQ> request
     * @return response
     */
    default <REQ, RES> RES end(String schemaName, REQ params, MsgCodec<REQ, RES> codec) {
        return end(schemaName, END_NAME, params, codec);
    }

    /**
     * end.
     * @param schemaName schemaName
     * @param stepName stepName
     * @param params params
     * @param codec codec
     * @param <RES> response
     * @param <REQ> request
     * @return response
     */
    <REQ, RES> RES end(String schemaName, String stepName, REQ params, MsgCodec<REQ, RES> codec);

    /**
     * destroy.
     * @param schemaName schemaName
     * @param params params
     * @param codec codec
     * @param <RES> response
     * @param <REQ> request
     * @return response
     */
    default <REQ, RES> RES destroy(String schemaName, REQ params, MsgCodec<REQ, RES> codec) {
        return destroy(schemaName, DESTROY_NAME, params, codec);
    }

    /**
     * destroy.
     * @param schemaName schemaName
     * @param stepName stepName
     * @param params params
     * @param codec codec
     * @param <RES> response
     * @param <REQ> request
     * @return response
     */
    <REQ, RES> RES destroy(String schemaName, String stepName, REQ params, MsgCodec<REQ, RES> codec);

    /**
     * startForObject.
     * @param schemaName schemaName
     * @param params params
     * @return response
     */
    default Object startForObject(String schemaName, Object params) {
        return startForObject(schemaName, START_NAME, params);
    }

    /**
     * startForObject.
     * @param schemaName schemaName
     * @param stepName stepName
     * @param params params
     * @return response
     */
    default Object startForObject(String schemaName, String stepName, Object params) {
        return start(schemaName, stepName, params, ObjectMsgCodec.INSTANCE);
    }

    /**
     * pushForObject.
     * @param schemaName schemaName
     * @param stepName stepName
     * @param params params
     * @return response
     */
    default Object pushForObject(String schemaName, String stepName, Object params) {
        return push(schemaName, stepName, params, ObjectMsgCodec.INSTANCE);
    }

    /**
     * close.
     */
    @Override
    default void close() {
        LoggerHelper.info(getClass(), "close");
    }
}
