package com.github.lontime.base.workflow.interfaces;

import com.github.lontime.base.api.workflow.ReactiveInterface;

/**
 * WfRdbmsInterface
 * @author lontime
 * @since 1.0
 * @param <REQ> request
 */
public interface WfRdbmsInterface<REQ extends ReactiveInterface> extends WfPersistentInterface<REQ> {

    /**
     * getInsertStateSql.
     * @return sql
     */
    String getInsertStateSql();

    /**
     * getUpdateStateSql.
     * @return sql
     */
    String getUpdateStateSql();

    /**
     * getQueryStateSql.
     * @return sql
     */
    String getCountStateSql();

    /**
     * getQueryStateSql.
     * @return sql
     */
    String getQueryStateSql();

    /**
     * getInsertAuditTrailSql.
     * @return sql
     */
    String getInsertAuditTrailSql();

}
