package com.github.lontime.base.workflow.interfaces;

import com.github.lontime.base.api.workflow.ReactiveInterface;

/**
 * WfPersistentInterface.
 * @author lontime
 * @since 1.0
 * @param <REQ> request
 */
public interface WfPersistentInterface<REQ extends ReactiveInterface> {

    /**
     * insertState.
     * @param request request
     * @return result
     */
    int insertState(REQ request);

    /**
     * updateState.
     * @param request request
     * @return result
     */
    int updateState(REQ request);

    /**
     * queryState.
     * @param request request
     * @return result
     */
    String queryState(REQ request);

    /**
     * insertAuditTrail.
     * @param request request
     * @param params params
     * @param response response
     * @return result
     */
    int insertAuditTrail(REQ request, byte[] params, byte[] response);

    /**
     * insertAuditTrail.
     * @param request request
     * @param params params
     * @param response response
     * @return result
     */
    int insertStateAndAuditTrail(REQ request, byte[] params, byte[] response);

    /**
     * insertAuditTrail.
     * @param request request
     * @param params params
     * @param response response
     * @return result
     */
    int updateStateAndAuditTrail(REQ request, byte[] params, byte[] response);
}
