package com.github.lontime.base.workflow.impl;

import com.github.lontime.base.api.workflow.ReactiveInterface;

/**
 * WfMysqlImpl
 * @author lontime
 * @since 1.0
 * @param <REQ> request
 */
public class WfMysqlImpl<REQ extends ReactiveInterface> extends AbstractWfRdbmsImpl<REQ> {

    public WfMysqlImpl() {
        this(null);
    }

    public WfMysqlImpl(String dsName) {
        super(dsName);
    }

    @Override
    public String getInsertStateSql() {
        return "insert ignore into tb_state(bid, schema_name, state, created_time, updated_time) values(?, ?, ?, NOW(), NOW())";
    }

    @Override
    public String getUpdateStateSql() {
        return "update tb_state set state = ?, updated_time = NOW() where bid = ? and schema_name = ?";
    }

    @Override
    public String getQueryStateSql() {
        return "select state from tb_state where bid = ? and schema_name = ?";
    }

    @Override
    public String getCountStateSql() {
        return "select count(1) from tb_state where bid = ? and schema_name = ?";
    }

    @Override
    public String getInsertAuditTrailSql() {
        return "insert into tb_audit_trail(id, bid, schema_name, action_type, action, prev_state, state, params, response, created_time, updated_time) values(NULL, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())";
    }
}
