package com.github.lontime.base.workflow.configuration;

import java.time.Duration;
import java.util.List;

import lombok.Getter;
import lombok.Setter;

/**
 * Options.
 * @author lontime
 * @since 1.0
 */
@Getter
@Setter
public class Options {

    /**
     * schemas.
     * @return
     */
    private List<Schema> schemas;

    @Getter
    @Setter
    public static class Upstream {
        private String name;
        private String serviceName;
        private String methodName;
        private Duration timeout;
        private String tags;
    }

    @Getter
    @Setter
    public static class Schema {
        private String name;
        private String serviceName;
        private Integer version = 1;
        private String proxy;
        private List<Step> steps;
    }

    @Getter
    @Setter
    public static class Step {
        private String name;
        private String proxy;
        private String action;
        private String methodName;
        private String serviceName;
        private List<String> states;
        private String nextState;
        private String nextStep;
    }

}
