package com.github.lontime.base.workflow;

import com.github.lontime.base.commonj.utils.Holder;
import com.github.lontime.base.commonj.utils.LoggerHelper;
import com.github.lontime.base.workflow.provider.DefaultProvider;
import com.github.lontime.base.workflow.provider.Provider;

/**
 * WorkflowInstance.
 * @author lontime
 * @since 1.0
 */
public class WorkflowInstance {

    private static Holder<Provider> globalHolder = new Holder<>();
    private static final Object globalLock = new Object();

    public static Provider get() {
        if (null == globalHolder.get()) {
            synchronized (globalLock) {
                if (null == globalHolder.get()) {
                    globalHolder.set(DefaultProvider.create());
                }
            }
        }
        return globalHolder.get();
    }

    public static Provider set(Provider custom) {
        synchronized (globalLock) {
            final Provider provider = globalHolder.get();
            if (null != provider) {
                if (provider.equals(custom)) {
                    return provider;
                }
                LoggerHelper.infov("close {0} now {1}", provider.getName(), custom.getName());
                provider.close();
            }
            globalHolder.set(custom);
        }
        return globalHolder.get();
    }
}
