package com.github.lontime.base.errors.spi;

import java.util.Optional;

import com.github.lontime.base.errors.ErrorCodeEnum;
import com.github.lontime.base.errors.ErrorMessage;

/**
 * error message.
 * @author lontime
 * @since 1.0.0
 */
public interface ErrorMessageDetector {

    int SORT_NUM_CHINESE = 0;

    int SORT_NUM_DEFAULT = Integer.MAX_VALUE;

    /**
     * detect error message.
     * @param codeEnum codeEnum
     * @return ErrorMessage
     */
    default Optional<ErrorMessage> resolve(ErrorCodeEnum codeEnum) {
        return resolve(codeEnum.getCode());
    }

    /**
     * detect error message.
     * @param code code
     * @return ErrorMessage
     */
    Optional<ErrorMessage> resolve(String code);

    /**
     * sortNum.
     * @return sortNum
     */
    default int sortNum() {
        return SORT_NUM_DEFAULT;
    }

}
