package com.github.lontime.base.errors;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

import com.github.lontime.base.logging.GLogger;

/**
 * ErrorTypes.
 *
 * @author lontime
 * @since 1.0
 */
public final class ErrorTypes {
    private static final ConcurrentHashMap<String, Optional<ErrorMessage>> CACHE = new ConcurrentHashMap<>();

    /**
     * prevent instantiation of utility class.
     */
    private ErrorTypes() {}

    public static Optional<ErrorMessage> detectErrorTypeOptional(final String code) {
        GLogger.defaults().debugv("error code is {0}", code);
        return CACHE.computeIfAbsent(code, it ->
                ErrorMessageDetectorRegistry.getAll().stream().map(mtd -> {
                    final Optional<ErrorMessage> errorMessage = mtd.resolve(code);
                    return errorMessage;
                }).filter(Optional::isPresent).map(Optional::get).findFirst());
    }

    public static Optional<ErrorMessage> detectErrorTypeOptional(final ErrorCodeEnum codeEnum) {
        return detectErrorTypeOptional(codeEnum.getCode());
    }

    public static ErrorMessage detectErrorType(final String code) {
        return detectErrorTypeOptional(code).orElseGet(() -> detectErrorTypeOptional(ErrorCodeEnum.UNKNOWN).get());
    }

    public static ErrorMessage detectErrorType(final ErrorCodeEnum codeEnum) {
        return detectErrorType(codeEnum.getCode());
    }
}