package com.github.lontime.base.errors;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * error code.
 * @author lontime
 * @since 1.0.0
 */
@AllArgsConstructor
@Getter
public enum ErrorCodeEnum {
    /**成功*/
    SUCCESS("00000"),
    /**未知错误*/
    UNKNOWN("99999"),
    /**用户端错误 一级宏错误*/
    ERROR_USER("A0001"),
    /**用户注册错误 二级宏错误*/
    ERROR_REGISTER_ERROR("A0100"),
    /**用户未同意隐私协议*/
    DONOT_AGREE_AGREEMENT("A0101"),
    /**注册国家或地区受限*/
    BLOCKED_COUNTRY("A0102"),
    /**用户校验失败*/
    FAIL_USER_VERIFICATION("A0110"),
    /**用户名已存在*/
    EXISTED_USER("A0111"),
    /**用户名包含敏感词*/
    SENSITIVE_USER("A0112"),
    /**用户名包含特殊字符*/
    SPECIAL_USER("A0113"),
    /**密码校验失败*/
    FAIL_AUTH_PASSWORD("A0120"),
    /**密码长度不够*/
    SHORT_LENGTH_PASSWORD("A0121"),
    /**密码长度不够*/
    INSUFFICIENT_STRENGTH_PASSWORD("A0122"),
    /**校验码输入错误*/
    ERROR_CHECK_CODE("A0130"),
    /**短信验证码输入错误*/
    ERROR_SMS_CODE("A0131"),
    /**邮件校验码输入错误*/
    ERROR_EMAIL_CODE("A0132"),
    /**语音校验码输入错误*/
    ERROR_VOICE_CODE("A0133"),
    /**用户证件异常*/
    ABNORMAL_USER_ID("A0140"),
    /**用户证件类型未选择*/
    NULL_USER_ID_TYPE("A0141"),
    /**大陆身份证编号校验非法*/
    ILLEGAL_MAINLAND_USER_ID("A0142"),
    /**护照编号校验非法*/
    ILLEGAL_PASSPORT_ID("A0143"),
    /**军官证编号校验非法*/
    ILLEGAL_OFFICER_ID("A0144"),
    /**用户基本信息校验失败*/
    ERROR_USER_BASIC_INFORMATION("A0150"),
    /**手机格式校验失败*/
    ILLEGAL_PHONE_CODE("A0151"),
    /**地址格式校验失败*/
    ILLEGAL_HOME_ADDRESS("A0152"),
    /**邮件格式校验失败*/
    ILLEGAL_EMAIL_ADDRESS("A0153"),
    /**用户登录异常*/
    ABNORMAL_LOGIN("A0200"),
    /**用户账户不存在*/
    ILLEGAL_USER_ACCOUNT("A0201"),
    /**用户账户被冻结*/
    FROZEN_USER_ACCOUNT("A0202"),
    /**用户账户已作废*/
    INVALID_USER_ACCOUNT("A0203"),
    /**用户密码错误*/
    ERROR_USER_PASSWORD("A0210"),
    /**用户输入密码次数超限*/
    TOOMANY_ENTER_PASSWORD("A0211"),
    /**用户身份校验失败*/
    ERROR_USER_IDENTITY("A0220"),
    /**用户指纹识别失败*/
    ERROR_USER_FINGERPRINT("A0221"),
    /**用户面容识别失败*/
    ERROR_USER_FACE("A0222"),
    /**用户未获得第三方登录授权*/
    FAIL_THIRDPART_OAUTH("A0223"),
    /**用户登录已过期*/
    EXPIRED_USER_LOGIN("A0230"),
    /**用户验证码错误*/
    ERROR_USER_VERIFY_CODE("A0240"),
    /**用户验证码尝试次数超限*/
    LIMIT_RETRY_VERIFY_CODE("A0241"),
    /**访问权限异常*/
    ABNORMAL_ACCESS("A0300"),
    /**访问未授权*/
    UNAUTHORIZED_ACCESS("A0301"),
    /**正在授权中*/
    INPROCESS_AUTHORIZATION("A0302"),
    /**用户授权申请被拒绝*/
    REJECTED_AUTHORIZATION("A0303"),
    /**因访问对象隐私设置被拦截*/
    BLOCKED_PRIVACY_OBJECT("A0310"),
    /**授权已过期*/
    EXPIRED_AUTHORIZATION("A0311"),
    /**无权限使用API*/
    REJECTED_USE_API("A0312"),
    /**用户访问被拦截*/
    BLOCKED_ACCESS("A0320"),
    /**黑名单用户*/
    REJECTED_BLACK_LIST("A0321"),
    /**黑名单用户*/
    FROZEN_ACCOUNT("A0322"),
    /**非法IP地址*/
    INVALID_IP("A0323"),
    /**网关访问受限*/
    REJECTED_ACCESS_GATEWAY("A0324"),
    /**地域黑名单*/
    REJECTED_AREA_BLACK_LIST("A0325"),
    /**服务已欠费*/
    OWE_A_FEE_SERVICE("A0330"),
    /**用户签名异常*/
    ABNORMAL_SIGNATURE("A0340"),
    /**RSA签名错误*/
    ERROR_RSA_SIGNATURE("A0341"),
    /**用户请求参数错误*/
    ERROR_PARAM("A0400"),
    /**包含非法恶意跳转链接*/
    ILLEGAL_URL("A0401"),
    /**无效的用户输入*/
    ILLEGAL_INPUT("A0402"),
    /**不正确的URL*/
    ERROR_URL("A0403"),
    /**未找到的URL*/
    NOT_FOUND_URL("A0404"),
    /**无效的URI和方法*/
    ILLEGAL_URI_WITH_METHOD("A0405"),
    /**无效的URI和方法*/
    ILLEGAL_HTTP_METHOD("A0406"),
    /**请求必填参数为空*/
    ILLEGAL_REQUIRED_PARAM("A0410"),
    /**用户订单号为空*/
    EMPTY_ORDER("A0411"),
    /**订购数量为空*/
    EMPTY_QUANTITY("A0412"),
    /**缺少时间戳参数*/
    MISSING_TIMESTAMP("A0413"),
    /**非法的时间戳参数*/
    ILLEGAL_TIMESTAMP("A0414"),
    /**用户订单号重复*/
    DUPLICATE_ORDER("A0415"),
    /**无效的订单类型*/
    ILLEGAL_ORDER_TYPE("A0416"),
    /**无效的业务类型*/
    ILLEGAL_BUSINESS_TYPE("A0417"),
    /**请求参数值超出允许的范围*/
    OUT_RANGE_PARAM("A0420"),
    /**参数格式不匹配*/
    ILLEGAL_PARAM_FORMAT("A0421"),
    /**地址不在服务范围*/
    EXCEED_ADDRESS_RANGE("A0422"),
    /**地址不在服务范围*/
    EXCEED_TIME_RANGE("A0423"),
    /**金额超出限制*/
    EXCEED_MONEY_RANGE("A0424"),
    /**数量超出限制*/
    EXCEED_QUANTITY_RANGE("A0425"),
    /**请求批量处理总个数超出限制*/
    EXCEED_TOTAL_REQUEST("A0426"),
    /**请求JSON解析失败*/
    INVALID_JSON("A0427"),
    /**用户输入内容非法*/
    ILLEGAL_USER_INPUT("A0430"),
    /**包含违禁敏感词*/
    SENSITIVE_WORD("A0431"),
    /**图片包含违禁信息*/
    SENSITIVE_PICTURE("A0432"),
    /**文件侵犯版权*/
    INFRINGEMENT_FILE_COPYRIGHT("A0433"),
    /**用户操作异常*/
    ABNORMAL_USER_OPERATION("A0440"),
    /**用户支付超时*/
    TIMEOUT_USER_PAYMENT("A0441"),
    /**确认订单超时*/
    TIMEOUT_COMMIT_ORDER("A0442"),
    /**订单已关闭*/
    CLOSED_ORDER("A0443"),
    /**用户请求服务异常*/
    ABNORMAL_REQUEST_SERVICE("A0500"),
    /**请求次数超出限制*/
    EXCEED_REQUEST_NUMBER("A0501"),
    /**请求并发数超出限制*/
    EXCEED_REQUEST_CONCURRENT("A0502"),
    /**用户操作请等待*/
    WAIT_UNTIL_OPERATION_END("A0503"),
    /**WebSocket连接异常*/
    ABNORMAL_WEBSOCKET_CONNECTION("A0504"),
    /**WebSocket连接断开*/
    CLOSED_WEBSOCKET_CONNECTION("A0505"),
    /**用户重复请求*/
    DUPLICATE_REQUEST("A0506"),
    /**用户资源异常*/
    ABNORMAL_USER_RESOURCES("A0600"),
    /**账户余额不足*/
    INSUFFICIENT_USER_BALANCE("A0601"),
    /**用户磁盘空间不足*/
    INSUFFICIENT_USER_DISK("A0602"),
    /**用户内存空间不足*/
    INSUFFICIENT_USER_INMEMORY("A0603"),
    /**用户OSS容量不足*/
    INSUFFICIENT_USER_OSS("A0604"),
    /**用户配额已用光*/
    EXHAUST_USER_QUOTA("A0605"),
    /**用户上传文件异常*/
    ABNORMAL_UPLOAD("A0700"),
    /**用户上传文件类型不匹配*/
    INVALID_UPLOAD_TYPE("A0701"),
    /**用户上传文件太大*/
    TOO_LARGE_FILE("A0702"),
    /**用户上传图片太大*/
    TOO_LARGE_PICTURE("A0703"),
    /**用户上传视频太大*/
    TOO_LARGE_VIDEO("A0704"),
    /**用户上传压缩文件太大*/
    TOO_LARGE_ZIP("A0705"),
    /**用户当前版本异常*/
    ABNORMAL_VERSION("A0800"),
    /**用户安装版本与系统不匹配*/
    NOT_MATCH_SYSTEM_VERSION("A0801"),
    /**用户安装版本过低*/
    TOO_LOW_VERSION("A0802"),
    /**用户安装版本过高*/
    TOO_HIGH_VERSION("A0803"),
    /**用户当前版本已过期*/
    EXPIRED_VERSION("A0804"),
    /**用户API请求版本不匹配*/
    NOT_MATCH_API_VERSION("A0805"),
    /**用户API请求版本过高*/
    TOO_HIGH_API_VERSION("A0806"),
    /**用户API请求版本过低*/
    TOO_LOW_API_VERSION("A0807"),
    /**用户隐私未授权*/
    UNAUTHORIZED_PRIVACY("A0900"),
    /**用户隐私未签署*/
    UNSIGNED_PRIVACY("A0901"),
    /**用户摄像头未授权*/
    UNAUTHORIZED_CAMERA_HEAD("A0902"),
    /**用户相机未授权*/
    UNAUTHORIZED_CAMERA("A0903"),
    /**用户图片库未授权*/
    UNAUTHORIZED_PICTURE("A0904"),
    /**用户文件未授权*/
    UNAUTHORIZED_FILE("A0905"),
    /**用户位置信息未授权*/
    UNAUTHORIZED_MAP("A0906"),
    /**用户通讯录未授权*/
    UNAUTHORIZED_ADDRESS_BOOK("A0907"),
    /**无效的Excel文件*/
    INVALID_EXCEL("A0908"),
    /**用户设备异常*/
    ABNORMAL_DEVICE("A1000"),
    /**用户相机异常*/
    ABNORMAL_CAMERA("A1001"),
    /**用户麦克风异常*/
    ABNORMAL_MICROPHONE("A1002"),
    /**用户听筒异常*/
    ABNORMAL_RECEIVER("A1003"),
    /**用户听筒异常*/
    ABNORMAL_SPEAKER("A1004"),
    /**用户听筒异常*/
    ABNORMAL_GPS("A1005"),
    /**系统执行出错*/
    ERROR_SYSTEM("B0001"),
    /**系统执行超时*/
    TIMEOUT_SYSTEM("B0100"),
    /**系统订单处理超时*/
    TIMEOUT_ORDER("B0101"),
    /**系统中断*/
    INTERRUPTED_SYSTEM("B0102"),
    /**系统容灾功能被触发*/
    RECOVERY_SYSTEM("B0200"),
    /**系统限流*/
    LIMIT_SYSTEM("B0210"),
    /**系统功能降级*/
    FALLBACK_SYSTEM("B0220"),
    /**系统资源异常*/
    ABNORMAL_RESOURCE("B0300"),
    /**系统资源耗尽*/
    EXHAUSTION_RESOURCE("B0310"),
    /**系统磁盘空间耗尽*/
    EXHAUSTION_DISK("B0311"),
    /**系统内存耗尽*/
    EXHAUSTION_INMEMORY("B0312"),
    /**文件句柄耗尽*/
    EXHAUSTION_FILE("B0313"),
    /**系统连接池耗尽*/
    EXHAUSTION_SOCKET("B0314"),
    /**系统资源访问异常*/
    ABNORMAL_ACCESS_RESOURCE("B0320"),
    /**系统读取磁盘文件失败*/
    FAIL_READ_DISK("B0321"),
    /**序列化失败*/
    FAIL_SERIALIZATION("B0400"),
    /**无效的状态*/
    ILLEGAL_STATE("B0500"),
    /**加锁失败*/
    FAIL_LOCK("B0600"),
    /**系统重试*/
    RETRY_SYSTEM("B0700"),
    /**RXJAVA组件重试*/
    RETRY_RXJAVA("B0710"),
    /**库存不足*/
    OUT_OF_STOCK("B0800"),
    /**空错误*/
    ERROR_IF_NULL("B0900"),
    /**非空错误*/
    ERROR_NOT_NULL("B0910"),
    /**字符串非空错误*/
    ERROR_NOT_BLANK("B0920"),
    /**字符串非空错误*/
    ERROR_NOT_EMPTY("B0921"),
    /**无效的参数*/
    ILLEGAL_ARGUMENT("B1000"),
    /**调用第三方服务出错*/
    ERROR_CALL_CHANNEL("C0001"),
    /**中间件服务出错*/
    ERROR_MIDDLEWARE("C0100"),
    /**RPC服务出错*/
    ERROR_RPC("C0110"),
    /**RPC服务未找到*/
    NOTFOUND_RPC_SERVICE("C0111"),
    /**RPC服务未注册*/
    NOTREGISTER_RPC_SERVICE("C0112"),
    /**接口不存在*/
    NOTFOUND_API("C0113"),
    /**消息服务出错*/
    ERROR_MESSAGE_SERVICE("C0120"),
    /**消息投递出错*/
    ERROR_MESSAGE_SEND("C0121"),
    /**消息消费出错*/
    ERROR_MESSAGE_CONSUME("C0122"),
    /**消息订阅出错*/
    ERROR_MESSAGE_SUBSCRIPTION("C0123"),
    /**消息订阅出错*/
    NOTFOUND_MESSAGE_GROUP("C0124"),
    /**缓存服务出错*/
    ERROR_CACHE("C0130"),
    /**key长度超出限制*/
    EXCEEDS_CACHE_KEY_LENGTH("C0131"),
    /**key长度超出限制*/
    EXCEEDS_CACHE_VALUE_LENGTH("C0132"),
    /**存储容量已满*/
    EXCEEDS_CACHE_STORAGE("C0133"),
    /**不支持的数据格式*/
    ERROR_CACHE_DATA("C0134"),
    /**配置服务出错*/
    ERROR_CONFIG_SERVICE("C0140"),
    /**网络资源服务出错*/
    ERROR_NETWORK("C0150"),
    /**VPN服务出错*/
    ERROR_VPN("C0151"),
    /**CDN服务出错*/
    ERROR_CDN("C0152"),
    /**域名解析服务出错*/
    ERROR_DOMAIN("C0153"),
    /**网关服务出错*/
    ERROR_GATEWAY("C0154"),
    /**TOKEN错误*/
    ERROR_TOKEN("C0155"),
    /**第三方系统执行超时*/
    TIMEOUT_CHANNEL("C0200"),
    /**RPC执行超时*/
    TIMEOUT_RPC("C0210"),
    /**消息投递超时*/
    TIMEOUT_MESSAGE_SEND("C0220"),
    /**缓存服务超时*/
    TIMEOUT_CACHE("C0230"),
    /**配置服务超时*/
    TIMEOUT_CONFIG("C0240"),
    /**数据库服务超时*/
    TIMEOUT_DATABASE("C0250"),
    /**数据库服务出错*/
    ERROR_DATABASE("C0300"),
    /**表不存在*/
    NOTEXIST_TABLE("C0311"),
    /**列不存在*/
    NOTEXIST_COLUMN("C0312"),
    /**多表关联中存在多个相同名称的列*/
    CONFLICT_COLUMN("C0321"),
    /**数据库死锁*/
    DEAD_LOCK("C0331"),
    /**数据库访问失败*/
    ERROR_ACCESS_DATABASE("C0340"),
    /**主键冲突*/
    CONFLICT_PRIMARY_KEY("C0341"),
    /**唯一键冲突，数据重复*/
    CONFLICT_UNIKEY_KEY("C0342"),
    /**查询数据为空*/
    EMPTY_DATA("C0343"),
    /**第三方容灾系统被触发*/
    RECOVERY_CHANNEL_SYSTEM("C0400"),
    /**第三方系统限流*/
    LIMIT_CHANNEL_SYSTEM("C0401"),
    /**第三方功能降级*/
    FALLBACK_CHANNEL_SYSTEM("C0402"),
    /**通知服务出错*/
    ERROR_NOTIFY("C0500"),
    /**短信提醒服务失败*/
    ERROR_SMS_NOTIFY("C0501"),
    /**语音提醒服务失败*/
    ERROR_VOICE_NOTIFY("C0502"),
    /**邮件提醒服务失败*/
    ERROR_EMAIL_NOTIFY("C0503");
    private final String code;
}