package com.github.lontime.base.errors;

import java.util.Optional;

import com.github.lontime.base.errors.spi.ErrorMessageDetector;

/**
 * Detector for built-in media type mappings.
 * @author lontime
 * @since 1.0.0
 */
public class ChineseErrorMessageDetector implements ErrorMessageDetector {

    @Override
    public Optional<ErrorMessage> resolve(String code) {
        return ChineseErrorMessageEnum.map(code);
    }

    @Override
    public int sortNum() {
        return SORT_NUM_CHINESE;
    }
}
