/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.utils;

import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.springframework.util.StringUtils;

public abstract class StringHelper {
    private static final ThreadLocal<StringBuilder> sbtl = ThreadLocal.withInitial(StringHelper::builder);

    private static StringBuilder acquireStringBuilder() {
        StringBuilder sb = sbtl.get();
        sb.setLength(0);
        return sb;
    }

    public static StringBuilder builder() {
        return new StringBuilder(128);
    }

    public static StringBuilder fastBuilder() {
        return StringHelper.acquireStringBuilder();
    }

    public static boolean hasText(String str) {
        return StringUtils.hasText((String)str);
    }

    public static boolean hasLength(String str) {
        return StringUtils.hasLength((String)str);
    }

    public static boolean isEmpty(String str) {
        return !StringHelper.hasText(str);
    }

    public static String removePrefix(String str, String prefix) {
        return StringHelper.removePrefixAndSuffix(str, prefix, null);
    }

    public static String removeSuffix(String str, String suffix) {
        return StringHelper.removePrefixAndSuffix(str, null, suffix);
    }

    public static String removePrefixAndSuffix(String str, String prefix, String suffix) {
        String pattern = StringHelper.builder().append(Optional.ofNullable(prefix).map(ReUtil::escape).orElse("")).append("(.*)").append(Optional.ofNullable(suffix).map(ReUtil::escape).orElse("")).toString();
        if (!ReUtil.contains((String)pattern, (CharSequence)str)) {
            return str;
        }
        return ReUtil.replaceAll((CharSequence)str, (String)pattern, (String)"$1");
    }

    public static boolean relaxEquals(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (Objects.isNull(s1) || Objects.isNull(s2)) {
            return false;
        }
        if (s1.equalsIgnoreCase(s2)) {
            return true;
        }
        String t1 = StringUtils.replace((String)s1, (String)"-", (String)"_");
        String t2 = StringUtils.replace((String)s2, (String)"-", (String)"_");
        return t1.equalsIgnoreCase(t2);
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        return StringUtils.replace((String)inString, (String)oldPattern, (String)newPattern);
    }

    public static String toUnderlineCase(String str) {
        return StrUtil.toUnderlineCase((CharSequence)str);
    }

    public static boolean isEqual(CharSequence s, CharSequence cs) {
        return Objects.equals(s, cs);
    }

    public static boolean isNotEqual(CharSequence s, CharSequence cs) {
        return StringHelper.isEqual(s, cs);
    }

    public static String collectionToCommaDelimitedString(Collection<?> coll) {
        return StringUtils.collectionToCommaDelimitedString(coll);
    }

    public static String capitalize(String str) {
        return StringUtils.capitalize((String)str);
    }

    public static String uncapitalize(String str) {
        return StringUtils.uncapitalize((String)str);
    }
}

