/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.utils;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;

public abstract class SleepHelper {
    public static void sleep(Duration duration) {
        try {
            TimeUnit.MILLISECONDS.sleep(duration.toMillis());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean waitFor(Supplier<Boolean> supplier) {
        return SleepHelper.waitFor(supplier, Duration.ofSeconds(1L));
    }

    public static boolean waitFor(Supplier<Boolean> supplier, Duration timeout) {
        return SleepHelper.waitFor(supplier, timeout, Duration.ofNanos(timeout.toNanos() / 100L));
    }

    public static boolean waitFor(Supplier<Boolean> supplier, Duration timeout, Duration sleep) {
        return SleepHelper.waitFor(supplier, timeout, sleep, 200);
    }

    public static boolean waitFor(Supplier<Boolean> supplier, Duration timeout, Duration sleep, int retries) {
        int counter = retries;
        long started = System.currentTimeMillis();
        long sleepNs = sleep.toNanos();
        long timeoutMs = timeout.toMillis();
        while (System.currentTimeMillis() - started <= timeoutMs) {
            counter = SleepHelper.waitFor(counter, sleepNs);
            if (!Optional.ofNullable(supplier.get()).orElse(Boolean.FALSE).booleanValue()) continue;
            return true;
        }
        return Optional.ofNullable(supplier.get()).orElse(Boolean.FALSE);
    }

    private static int waitFor(int counter, long nanos) {
        if (counter > 100) {
            --counter;
        } else if (counter > 0) {
            --counter;
            Thread.yield();
        } else {
            LockSupport.parkNanos(nanos);
        }
        return counter;
    }
}

