/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.utils;

import com.github.lontime.base.commonj.errors.ErrorCodeEnum;
import com.github.lontime.base.commonj.errors.ErrorException;
import com.github.lontime.base.commonj.executor.Initialize;
import com.github.lontime.base.commonj.utils.StringHelper;
import com.github.lontime.base.commonj.utils.SupplierHelper;
import com.github.lontime.shaded.io.helidon.common.serviceloader.HelidonServiceLoader;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.springframework.util.CollectionUtils;

public class ServiceLoaderHelper {
    private static final Supplier<ServiceLoaderHelper> SUPPLIERS = SupplierHelper.memoize(ServiceLoaderHelper::new);
    private final Map<Class<?>, HelidonServiceLoader<?>> cache = new ConcurrentHashMap();

    public static ServiceLoaderHelper get() {
        return SUPPLIERS.get();
    }

    public <T> T load(Class<T> clazz, Class<?> interfaceClazz) {
        this.check(clazz, interfaceClazz);
        List<?> list = this.loadList(interfaceClazz);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return this.cast(clazz, list);
    }

    public <T> T loadNew(Class<T> clazz, Class<?> interfaceClazz) {
        this.check(clazz, interfaceClazz);
        List<?> list = this.loadNewList(interfaceClazz);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return this.cast(clazz, list);
    }

    public <T> T cast(Class<T> clazz, List<?> list) {
        return list.stream().filter(c -> c.getClass().equals(clazz)).findFirst().orElse(null);
    }

    private <T> void check(Class<T> clazz, Class<?> interfaceClazz) {
        if (!interfaceClazz.isInterface()) {
            throw ErrorException.from(ErrorCodeEnum.ERROR_SYSTEM, StringHelper.builder().append("[").append(interfaceClazz.getName()).append("] must is <interface>").toString());
        }
        if (clazz.isAssignableFrom(interfaceClazz)) {
            throw ErrorException.from(ErrorCodeEnum.ERROR_SYSTEM, StringHelper.builder().append("[").append(clazz.getName()).append("] must is extends ").append(interfaceClazz.getName()).toString());
        }
    }

    private <T> void checkInterface(Class<?> interfaceClazz) {
        if (!interfaceClazz.isInterface()) {
            throw ErrorException.from(ErrorCodeEnum.ERROR_SYSTEM, StringHelper.builder().append("[").append(interfaceClazz.getName()).append("] must is <interface>").toString());
        }
    }

    public <T> List<T> loadList(Class<T> interfaceClazz) {
        this.checkInterface(interfaceClazz);
        HelidonServiceLoader loader = this.cache.computeIfAbsent(interfaceClazz, cls -> {
            HelidonServiceLoader serviceLoader = HelidonServiceLoader.builder(ServiceLoader.load(cls)).build();
            this.init(serviceLoader.asList());
            return serviceLoader;
        });
        return loader.asList();
    }

    public <T> List<T> loadList(Class<T> interfaceClazz, HelidonServiceLoader.Builder<T> builder) {
        this.checkInterface(interfaceClazz);
        HelidonServiceLoader loader = this.cache.computeIfAbsent(interfaceClazz, cls -> {
            HelidonServiceLoader serviceLoader = builder.build();
            this.init(serviceLoader.asList());
            return serviceLoader;
        });
        return loader.asList();
    }

    public <T> List<T> loadNewList(Class<T> interfaceClazz) {
        this.checkInterface(interfaceClazz);
        return this.loadNewList(HelidonServiceLoader.builder(ServiceLoader.load(interfaceClazz)));
    }

    public <T> List<T> loadNewList(HelidonServiceLoader.Builder<T> builder) {
        return this.init(builder.build().asList());
    }

    private <T> List<T> init(List<T> list) {
        list.stream().filter(t -> t instanceof Initialize).map(t -> (Initialize)t).forEach(t -> t.init());
        return list;
    }
}

