/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.utils;

import com.github.lontime.base.commonj.utils.CollectionHelper;
import com.github.lontime.base.commonj.utils.StringHelper;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;

public class NetHelper {
    private static final String PREFERRED_NETWORK_INTERFACE = "lontime.network.interface.preferred";
    private static final String NETWORK_IGNORED_INTERFACE = "lontime.network.interface.ignored";
    private static final String LOCALHOST_KEY = "localhost";
    private static final String ANYHOST_VALUE = "0.0.0.0";
    private static final String LOCALHOST_VALUE = "127.0.0.1";
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^\\d{1,3}(\\.\\d{1,3}){3}\\:\\d{1,5}$");
    private static final Pattern LOCAL_IP_PATTERN = Pattern.compile("127(\\.\\d{1,3}){3}$");
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static final int MIN_PORT = 1;
    private static final int MAX_PORT = 65535;
    private static final int RND_PORT_START = 30000;
    private static final int RND_PORT_RANGE = 10000;
    private static final Map<String, InetAddress> LOCAL_ADDRESS_CACHE = new ConcurrentHashMap<String, InetAddress>(16);
    private static final String DEFAULT_INTERFACE_NAME = System.getProperty("lontime.network.interface.preferred", "__default__");
    private static final Map<String, String> HOST_ADDRESS_CACHE = new ConcurrentHashMap<String, String>(16);
    private static final Map<String, String> HOST_NAME_CACHE = new ConcurrentHashMap<String, String>(16);
    private static BitSet USED_PORT = new BitSet(65536);

    public static int getRandomPort() {
        return 30000 + ThreadLocalRandom.current().nextInt(10000);
    }

    public static synchronized int getAvailablePort() {
        int randomPort = NetHelper.getRandomPort();
        return NetHelper.getAvailablePort(randomPort);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized int getAvailablePort(int port) {
        if (port < 1) {
            port = 1;
        }
        int i = port;
        while (i < 65535) {
            if (!USED_PORT.get(i)) {
                try (ServerSocket ignored = new ServerSocket(i);){
                    USED_PORT.set(i);
                    int n = i;
                    return n;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return port;
    }

    public static boolean isInvalidPort(int port) {
        return port < 1 || port > 65535;
    }

    public static boolean isValidAddress(String address) {
        return ADDRESS_PATTERN.matcher(address).matches();
    }

    public static boolean isLocalHost(String host) {
        return host != null && (LOCAL_IP_PATTERN.matcher(host).matches() || host.equalsIgnoreCase(LOCALHOST_KEY));
    }

    public static boolean isAnyHost(String host) {
        return ANYHOST_VALUE.equals(host);
    }

    public static boolean isInvalidLocalHost(String host) {
        return host == null || host.length() == 0 || host.equalsIgnoreCase(LOCALHOST_KEY) || host.equals(ANYHOST_VALUE) || host.startsWith("127.");
    }

    public static boolean isValidLocalHost(String host) {
        return !NetHelper.isInvalidLocalHost(host);
    }

    public static String getLocalHost() {
        return NetHelper.getLocalHost(DEFAULT_INTERFACE_NAME);
    }

    public static String getLocalHost(String interfaceName) {
        return HOST_ADDRESS_CACHE.computeIfAbsent(interfaceName, k -> {
            InetAddress address = NetHelper.getLocalAddress(interfaceName);
            if (address != null) {
                return address.getHostAddress();
            }
            return LOCALHOST_VALUE;
        });
    }

    public static InetAddress getLocalAddress(String interfaceName) {
        return LOCAL_ADDRESS_CACHE.computeIfAbsent(interfaceName, k -> NetHelper.getLocalAddress0(k));
    }

    public static InetAddress getLocalAddress() {
        return NetHelper.getLocalAddress(DEFAULT_INTERFACE_NAME);
    }

    public static boolean isPreferredNetworkInterface(NetworkInterface networkInterface) {
        String preferredNetworkInterface = System.getProperty(PREFERRED_NETWORK_INTERFACE);
        return Objects.equals(networkInterface.getDisplayName(), preferredNetworkInterface);
    }

    public static NetworkInterface findNetworkInterface(String interfaceName) {
        List<Object> validNetworkInterfaces = Collections.emptyList();
        try {
            validNetworkInterfaces = NetHelper.getValidNetworkInterfaces();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NetworkInterface result = null;
        for (NetworkInterface networkInterface : validNetworkInterfaces) {
            if (!Objects.equals(networkInterface.getDisplayName(), interfaceName)) continue;
            result = networkInterface;
            break;
        }
        if (result != null) {
            return result;
        }
        block5: for (NetworkInterface networkInterface : validNetworkInterfaces) {
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                Optional<InetAddress> addressOp = NetHelper.toValidAddress(addresses.nextElement());
                if (!addressOp.isPresent()) continue;
                try {
                    if (!addressOp.get().isReachable(100)) continue;
                    result = networkInterface;
                    continue block5;
                }
                catch (IOException iOException) {
                }
            }
        }
        if (result == null) {
            result = (NetworkInterface)CollectionHelper.firstElement(validNetworkInterfaces);
        }
        return result;
    }

    public static String getHostName(String address) {
        try {
            String hostname;
            int i = address.indexOf(58);
            if (i > -1) {
                address = address.substring(0, i);
            }
            if ((hostname = HOST_NAME_CACHE.get(address)) != null && hostname.length() > 0) {
                return hostname;
            }
            InetAddress inetAddress = InetAddress.getByName(address);
            if (inetAddress != null) {
                hostname = inetAddress.getHostName();
                HOST_NAME_CACHE.put(address, hostname);
                return hostname;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return address;
    }

    public static String getIpByHost(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            return hostName;
        }
    }

    public static String toAddressString(InetSocketAddress address) {
        return address.getAddress().getHostAddress() + ":" + address.getPort();
    }

    public static InetSocketAddress toAddress(String address) {
        int port;
        String host;
        int i = address.indexOf(58);
        if (i > -1) {
            host = address.substring(0, i);
            port = Integer.parseInt(address.substring(i + 1));
        } else {
            host = address;
            port = 0;
        }
        return new InetSocketAddress(host, port);
    }

    static boolean isPreferIPV6Address() {
        return Boolean.getBoolean("java.net.preferIPv6Addresses");
    }

    static boolean isValidV4Address(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && IP_PATTERN.matcher(name).matches() && !ANYHOST_VALUE.equals(name) && !LOCALHOST_VALUE.equals(name);
    }

    static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + '%' + address.getScopeId());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return address;
    }

    private static Optional<InetAddress> toValidAddress(InetAddress address) {
        if (address instanceof Inet6Address) {
            Inet6Address v6Address = (Inet6Address)address;
            if (NetHelper.isPreferIPV6Address()) {
                return Optional.ofNullable(NetHelper.normalizeV6Address(v6Address));
            }
        }
        if (NetHelper.isValidV4Address(address)) {
            return Optional.of(address);
        }
        return Optional.empty();
    }

    private static List<NetworkInterface> getValidNetworkInterfaces() throws SocketException {
        LinkedList<NetworkInterface> validNetworkInterfaces = new LinkedList<NetworkInterface>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (NetHelper.ignoreNetworkInterface(networkInterface)) continue;
            validNetworkInterfaces.add(networkInterface);
        }
        return validNetworkInterfaces;
    }

    private static boolean ignoreNetworkInterface(NetworkInterface networkInterface) throws SocketException {
        String networkInterfaceDisplayName;
        if (networkInterface == null || networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp()) {
            return true;
        }
        String ignoredInterfaces = System.getProperty(NETWORK_IGNORED_INTERFACE);
        if (StringHelper.hasText(ignoredInterfaces) && StringHelper.hasText(networkInterfaceDisplayName = networkInterface.getDisplayName())) {
            for (String ignoredInterface : ignoredInterfaces.split(",")) {
                if (!networkInterfaceDisplayName.matches(ignoredInterface.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private static InetAddress getLocalAddress0(String interfaceName) {
        InetAddress localAddress = null;
        try {
            NetworkInterface networkInterface = NetHelper.findNetworkInterface(interfaceName);
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                Optional<InetAddress> addressOp = NetHelper.toValidAddress(addresses.nextElement());
                if (!addressOp.isPresent()) continue;
                try {
                    if (!addressOp.get().isReachable(100)) continue;
                    return addressOp.get();
                }
                catch (IOException iOException) {
                }
            }
        }
        catch (Throwable networkInterface) {
            // empty catch block
        }
        try {
            localAddress = InetAddress.getLocalHost();
            Optional<InetAddress> addressOp = NetHelper.toValidAddress(localAddress);
            if (addressOp.isPresent()) {
                return addressOp.get();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return localAddress;
    }
}

