/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;

public class DateHelper {
    public static final DateTimeFormatter CN_LOCAL_DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter CN_LOCAL_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final String CN_ZONE_ID = "Asia/Shanghai";

    public static Date newDate() {
        return new Date();
    }

    public static String now() {
        return DateHelper.now(CN_LOCAL_DATE_TIME);
    }

    public static String now(DateTimeFormatter formatter) {
        return LocalDateTime.now().format(formatter);
    }

    public static String now(String pattern) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String dateToString(Date date) {
        return DateHelper.dateToString(date, CN_LOCAL_DATE_TIME);
    }

    public static String dateToString(Date date, DateTimeFormatter formatter) {
        if (Objects.isNull(date)) {
            return null;
        }
        return DateHelper.asLocalDateTime(date).format(formatter);
    }

    public static String dateToString(Date date, String pattern) {
        return DateHelper.dateToString(date, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return DateHelper.asLocalDateTime(date, ZoneId.systemDefault());
    }

    public static LocalDateTime asLocalDateTime(Date date, ZoneId zoneId) {
        return Instant.ofEpochMilli(date.getTime()).atZone(zoneId).toLocalDateTime();
    }

    public static LocalDate asLocalDate(Date date) {
        return DateHelper.asLocalDate(date, ZoneId.systemDefault());
    }

    public static LocalDate asLocalDate(Date date, ZoneId zoneId) {
        return Instant.ofEpochMilli(date.getTime()).atZone(zoneId).toLocalDate();
    }

    public static Date asDate(LocalDate localDate, ZoneId zoneId) {
        return Date.from(localDate.atStartOfDay(zoneId).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return DateHelper.asDate(localDateTime, ZoneId.systemDefault());
    }

    public static Date asDate(LocalDateTime localDateTime, ZoneId zoneId) {
        return Date.from(localDateTime.atZone(zoneId).toInstant());
    }

    public static Date asDate2021() {
        return DateHelper.asDate("2021-01-01 00:00:00");
    }

    public static Date asDate(CharSequence text) {
        return DateHelper.asDate(text, CN_LOCAL_DATE_TIME);
    }

    public static Date asDate(CharSequence text, String pattern) {
        return DateHelper.asDate(text, DateTimeFormatter.ofPattern(pattern));
    }

    public static Date asDate(CharSequence text, DateTimeFormatter formatter) {
        return DateHelper.asDate(LocalDateTime.parse(text, formatter));
    }

    public static Date asLocalDate(CharSequence text, DateTimeFormatter formatter) {
        return DateHelper.asDate(LocalDate.parse(text, formatter));
    }

    public static Date asLocalDate(CharSequence text) {
        return DateHelper.asLocalDate(text, CN_LOCAL_DATE);
    }

    public static Date asDate(LocalDate localDate) {
        return DateHelper.asDate(localDate, ZoneId.systemDefault());
    }
}

