/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.utils;

import com.github.lontime.shaded.io.helidon.common.context.Context;
import com.github.lontime.shaded.io.helidon.common.context.Contexts;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class ContextHelper {
    public static Context getOrCreateContext() {
        Optional context = Contexts.context();
        if (context.isPresent()) {
            return (Context)context.get();
        }
        return Context.create();
    }

    public static <T> Context getOrCreateContext(T instance) {
        Context ctx = ContextHelper.getOrCreateContext();
        ctx.register(instance);
        return ctx;
    }

    public static <T> Context getOrCreateContext(Object classifier, T instance) {
        Context ctx = ContextHelper.getOrCreateContext();
        ctx.register(classifier, instance);
        return ctx;
    }

    public static <T> void register(T instance) {
        if (instance != null) {
            Contexts.context().ifPresent(s -> s.register(instance));
        }
    }

    public static <T> void register(Object classifier, T instance) {
        if (instance != null) {
            Contexts.context().ifPresent(s -> s.register(classifier, instance));
        }
    }

    public static <T> Optional<T> get(Class<T> type) {
        Optional context = Contexts.context();
        if (!context.isPresent()) {
            return Optional.empty();
        }
        return ((Context)context.get()).get(type);
    }

    public static <T> Optional<T> get(Object classifier, Class<T> type) {
        Optional context = Contexts.context();
        if (!context.isPresent()) {
            return Optional.empty();
        }
        return ((Context)context.get()).get(classifier, type);
    }

    public static void runInContext(Context context, Runnable runnable) {
        Contexts.runInContext((Context)context, (Runnable)runnable);
    }

    public static <T> T runInContext(Context context, Callable<T> callable) {
        return (T)Contexts.runInContext((Context)context, callable);
    }

    public static ExecutorService wrap(ExecutorService toWrap) {
        return Contexts.wrap((ExecutorService)toWrap);
    }

    public static ScheduledExecutorService wrap(ScheduledExecutorService toWrap) {
        return Contexts.wrap((ScheduledExecutorService)toWrap);
    }
}

