/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.utils;

import cn.hutool.core.thread.ExecutorBuilder;
import com.github.lontime.base.commonj.components.AbstractComponentLifecycle;
import com.github.lontime.base.commonj.components.ComponentShutdownPriority;
import com.github.lontime.base.commonj.threads.NamedThreadPoolBundle;
import com.github.lontime.base.commonj.utils.SupplierHelper;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public class CommonManager
extends AbstractComponentLifecycle {
    private static Supplier<CommonManager> supplier = SupplierHelper.memoize(() -> CommonManager.builder().build());
    private NamedThreadPoolBundle threadPoolBundle = new NamedThreadPoolBundle();

    public static CommonManager getInstance() {
        return supplier.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    private CommonManager() {
    }

    @Override
    public String getName() {
        return "common";
    }

    @Override
    public void initialize() {
        this.threadPoolBundle.initialize();
    }

    @Override
    public void destroy() {
        this.threadPoolBundle.destroy();
    }

    public ExecutorService getExecutorService(String name) {
        return this.threadPoolBundle.get(name);
    }

    public ExecutorService getExecutorService(String name, int size) {
        return this.threadPoolBundle.get(name, size);
    }

    public ExecutorService getExecutorService(String name, int size, int maxSize) {
        return this.threadPoolBundle.get(name, size, maxSize);
    }

    public ExecutorService getExecutorService(String name, ExecutorBuilder executorBuilder) {
        return this.threadPoolBundle.get(name, executorBuilder);
    }

    public ExecutorService getExecutorService() {
        return this.threadPoolBundle.get();
    }

    @Override
    public int getShutdownPriority() {
        return ComponentShutdownPriority.LOWEST.getValue();
    }

    public static class Builder
    implements com.github.lontime.shaded.io.helidon.common.Builder<CommonManager> {
        public CommonManager build() {
            return new CommonManager();
        }
    }
}

