/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.utils;

import com.github.lontime.base.commonj.errors.ErrorCodeEnum;
import com.github.lontime.base.commonj.errors.ErrorException;
import com.github.lontime.base.commonj.utils.StringHelper;
import java.util.Objects;

public class AssertHelper {
    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkIfNull(Object data) {
        if (Objects.isNull(data)) {
            throw ErrorException.from(ErrorCodeEnum.EMPTY_DATA);
        }
    }

    public static void checkIfNull(Object data, String message) {
        if (Objects.isNull(data)) {
            throw ErrorException.from(ErrorCodeEnum.EMPTY_DATA, message);
        }
    }

    public static void checkIfEmpty(String data) {
        if (StringHelper.isEmpty(data)) {
            throw ErrorException.from(ErrorCodeEnum.EMPTY_DATA);
        }
    }

    public static void checkIfEmpty(String data, String message) {
        if (StringHelper.isEmpty(data)) {
            throw ErrorException.from(ErrorCodeEnum.EMPTY_DATA, message);
        }
    }

    public static void unsupportedOperation(String message) {
        throw ErrorException.from(ErrorCodeEnum.ILLEGAL_ARGUMENT, message);
    }
}

