/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.threads;

import cn.hutool.core.thread.ExecutorBuilder;
import cn.hutool.core.thread.RejectPolicy;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.github.lontime.base.commonj.components.AbstractLifecycle;
import com.github.lontime.base.commonj.config.CommonOptionResolver;
import com.github.lontime.base.commonj.config.ExecutorKind;
import com.github.lontime.base.commonj.config.NamedCommonExecutorOptions;
import com.github.lontime.base.commonj.utils.ExecutorHelper;
import com.github.lontime.base.commonj.utils.StringHelper;
import com.github.lontime.extnetty.NettyThreadFactory;
import com.github.lontime.shaded.io.helidon.common.context.Contexts;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;

public class NamedThreadPoolBundle
extends AbstractLifecycle {
    private Map<String, ExecutorService> map = new ConcurrentHashMap<String, ExecutorService>();

    @Override
    public String resolveName(String name) {
        return StringHelper.hasText(name) ? name : "lontime-default";
    }

    public ExecutorService get() {
        return this.get(null);
    }

    public ExecutorService get(String name) {
        return this.get(this.resolveName(name), 16);
    }

    public ExecutorService get(String name, int size) {
        return this.get(name, size, size);
    }

    public ExecutorService get(String name, int size, int maxSize) {
        Objects.requireNonNull(name, "name is not null");
        return this.loadIfAbsent(name, size, maxSize);
    }

    public ExecutorService get(String name, ExecutorBuilder executorBuilder) {
        return this.loadIfAbsent(name, executorBuilder);
    }

    @Override
    public void initialize() {
        Optional.ofNullable(CommonOptionResolver.getInstance().getExecutors()).ifPresent(e -> e.stream().forEach(this::loadIfAbsent));
    }

    @Override
    public void destroy() {
        this.map.forEach((k, v) -> ExecutorHelper.shutdownAndAwaitTermination(v, CommonOptionResolver.getInstance().getAwaitTerminatedTimeout()));
    }

    private ExecutorService loadIfAbsent(NamedCommonExecutorOptions options) {
        return this.map.computeIfAbsent(options.getName(), name -> this.load(options));
    }

    private ExecutorService loadIfAbsent(String name, int coreSize, int maxSize) {
        return this.map.computeIfAbsent(name, key -> this.load((String)key, coreSize, maxSize));
    }

    private ExecutorService loadIfAbsent(String name, ExecutorBuilder executorBuilder) {
        return this.map.computeIfAbsent(name, key -> executorBuilder.build());
    }

    public ExecutorService load(String name, int coreSize, int maxSize) {
        NamedCommonExecutorOptions options = new NamedCommonExecutorOptions();
        options.setCorePoolSize(coreSize);
        options.setMaxPoolSize(maxSize);
        options.setKeepAliveTime(Duration.ZERO);
        NamedCommonExecutorOptions.ThreadFactory factory = new NamedCommonExecutorOptions.ThreadFactory();
        factory.setPrefix(name + "-");
        options.setThreadFactory(factory);
        return this.load(options);
    }

    public ExecutorService load(NamedCommonExecutorOptions options) {
        ExecutorBuilder builder = ExecutorBuilder.create();
        Optional.ofNullable(options.getCorePoolSize()).ifPresent(arg_0 -> ((ExecutorBuilder)builder).setCorePoolSize(arg_0));
        Optional.ofNullable(options.getMaxPoolSize()).ifPresent(arg_0 -> ((ExecutorBuilder)builder).setMaxPoolSize(arg_0));
        Optional.ofNullable(options.getKeepAliveTime()).map(c -> c.toNanos()).ifPresent(arg_0 -> ((ExecutorBuilder)builder).setKeepAliveTime(arg_0));
        Optional.ofNullable(options.getAllowCoreThreadTimeOut()).ifPresent(arg_0 -> ((ExecutorBuilder)builder).setAllowCoreThreadTimeOut(arg_0));
        if (options.getThreadFactory() != null) {
            NamedCommonExecutorOptions.ThreadFactory threadFactoryOptions = options.getThreadFactory();
            builder.setThreadFactory((ThreadFactory)new NettyThreadFactory(threadFactoryOptions.getPrefix(), options.getMaxPoolSize() == null ? 0 : options.getMaxPoolSize(), threadFactoryOptions.getDaemon().booleanValue()));
        }
        Optional.ofNullable(options.getQueue()).map(this::buildWorkQueue).ifPresent(arg_0 -> ((ExecutorBuilder)builder).setWorkQueue(arg_0));
        Optional.ofNullable(options.getRejectedStrategy()).map(s -> s.toUpperCase()).map(s -> RejectPolicy.valueOf((String)s)).map(s -> s.getValue()).ifPresent(arg_0 -> ((ExecutorBuilder)builder).setHandler(arg_0));
        if (options.getKind() == ExecutorKind.HELIDON) {
            return Contexts.wrap((ExecutorService)builder.build());
        }
        if (options.getKind() == ExecutorKind.TTL) {
            return TtlExecutors.getTtlExecutorService((ExecutorService)builder.build());
        }
        return builder.build();
    }

    private BlockingQueue<Runnable> buildWorkQueue(int queueSize) {
        if (queueSize < -2) {
            return new SynchronousQueue<Runnable>(true);
        }
        if (queueSize == -1) {
            return new SynchronousQueue<Runnable>();
        }
        if (queueSize == 0) {
            return new LinkedBlockingQueue<Runnable>();
        }
        return new ArrayBlockingQueue<Runnable>(queueSize);
    }
}

