/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.langs;

import com.github.lontime.base.commonj.langs.LazilyParsedNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;

public class StringObjectMap {
    private static final int DEFAULT_SIZE = 8;
    private final Map<String, Object> map;

    public static StringObjectMap create() {
        return StringObjectMap.create(8);
    }

    public static StringObjectMap create(int initialCapacity) {
        return new StringObjectMap(initialCapacity, false);
    }

    public static StringObjectMap create(Map<String, ? extends Object> objectMap) {
        return new StringObjectMap(new HashMap<String, Object>(objectMap));
    }

    public static StringObjectMap createSorted() {
        return StringObjectMap.createSorted(Collections.emptyMap());
    }

    public static StringObjectMap createSorted(Comparator<String> comparator) {
        return StringObjectMap.createSorted(Collections.emptyMap(), comparator);
    }

    public static StringObjectMap createSorted(Map<String, ? extends Object> objectMap) {
        return StringObjectMap.createSorted(objectMap, null);
    }

    public static StringObjectMap createSorted(Map<String, ? extends Object> objectMap, Comparator<String> comparator) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(comparator);
        treeMap.putAll(objectMap);
        return new StringObjectMap(treeMap);
    }

    public static StringObjectMap createSafe() {
        return StringObjectMap.createSafe(8);
    }

    public static StringObjectMap createSafe(int initialCapacity) {
        return new StringObjectMap(initialCapacity, true);
    }

    public static StringObjectMap createSafe(Map<String, ? extends Object> objectMap) {
        return new StringObjectMap(new ConcurrentHashMap<String, Object>(objectMap));
    }

    public StringObjectMap(int initialCapacity, boolean threadSafe) {
        this.map = threadSafe ? new ConcurrentHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public StringObjectMap() {
        this(8, false);
    }

    public StringObjectMap(boolean threadSafe) {
        this(8, threadSafe);
    }

    public StringObjectMap(Map<String, Object> objectMap) {
        this.map = objectMap;
    }

    public void put(String key, Object value) {
        this.map.put(key, value);
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Object getOrDefault(String key, Object defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    public Object computeIfAbsent(String key, Function<String, Object> mappingFunction) {
        return this.map.computeIfAbsent(key, mappingFunction);
    }

    public Object computeIfPresent(String key, BiFunction<String, Object, Object> remappingFunction) {
        return this.map.computeIfPresent(key, remappingFunction);
    }

    public Object putIfAbsent(String key, Object value) {
        return this.map.putIfAbsent(key, value);
    }

    public void putAll(Map<String, Object> m) {
        this.map.putAll(m);
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public boolean remove(String key, Object value) {
        return this.map.remove(key, value);
    }

    public Object replace(String key, Object value) {
        return this.map.replace(key, value);
    }

    public boolean replace(String key, Object oldValue, Object newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StringObjectMap)) {
            return false;
        }
        StringObjectMap m = (StringObjectMap)o;
        return this.map.equals(m.toMap());
    }

    public <T> T getAsClass(String key) {
        return (T)this.map.get(key);
    }

    public boolean getAsBoolean(String key) {
        Object value = this.map.get(key);
        if (this.isBoolean(value)) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(this.getAsString(key));
    }

    public String getAsString(String key) {
        Object value = this.map.get(key);
        if (this.isNumber(value)) {
            return this.getAsNumber(key).toString();
        }
        if (this.isBoolean(value)) {
            return ((Boolean)value).toString();
        }
        return (String)value;
    }

    public Number getAsNumber(String key) {
        Object value = this.map.get(key);
        return value instanceof String ? new LazilyParsedNumber((String)value) : (Number)value;
    }

    public BigDecimal getAsBigDecimal(String key) {
        Object value = this.map.get(key);
        return value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
    }

    public BigInteger getAsBigInteger(String key) {
        Object value = this.map.get(key);
        return value instanceof BigInteger ? (BigInteger)value : new BigInteger(value.toString());
    }

    public int getAsInt(String key) {
        Object value = this.map.get(key);
        return this.isNumber(value) ? this.getAsNumber(key).intValue() : Integer.parseInt(this.getAsString(key));
    }

    public byte getAsByte(String key) {
        Object value = this.map.get(key);
        return this.isNumber(value) ? this.getAsNumber(key).byteValue() : Byte.parseByte(this.getAsString(key));
    }

    public short getAsShort(String key) {
        Object value = this.map.get(key);
        return this.isNumber(value) ? this.getAsNumber(key).shortValue() : Short.parseShort(this.getAsString(key));
    }

    public long getAsLong(String key) {
        Object value = this.map.get(key);
        return this.isNumber(value) ? this.getAsNumber(key).longValue() : Long.parseLong(this.getAsString(key));
    }

    public float getAsFloat(String key) {
        Object value = this.map.get(key);
        return this.isNumber(value) ? this.getAsNumber(key).floatValue() : Float.parseFloat(this.getAsString(key));
    }

    public double getAsDouble(String key) {
        Object value = this.map.get(key);
        return this.isNumber(value) ? this.getAsNumber(key).doubleValue() : Double.parseDouble(this.getAsString(key));
    }

    public char getAsCharacter(String key) {
        return this.getAsString(key).charAt(0);
    }

    public boolean isNumber(Object value) {
        return value instanceof Number;
    }

    public boolean isBoolean(Object value) {
        return value instanceof Boolean;
    }

    public boolean isString(String value) {
        return value instanceof String;
    }
}

