/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.langs;

import com.github.lontime.base.commonj.langs.Hooklet;
import com.github.lontime.base.commonj.utils.SupplierHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class ExtPriorityHook {
    private static Supplier<ExtPriorityHook> supplier = SupplierHelper.memoize(ExtPriorityHook::new);
    private final Map<Hooklet, Hooklet> hookletPool = new ConcurrentHashMap<Hooklet, Hooklet>();
    private final Thread shutdownThread = new Thread(() -> ExtPriorityHook.getInstance().onShutdown());

    public static ExtPriorityHook getInstance() {
        return supplier.get();
    }

    private ExtPriorityHook() {
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    public boolean add(int priority, Runnable hook) {
        return this.addAndGet(Hooklet.of(priority, hook)).equals(hook);
    }

    public <H extends Hooklet> H addAndGet(H hooklet) {
        Hooklet hook = this.hookletPool.computeIfAbsent(hooklet, Function.identity());
        return (H)hook;
    }

    public void clear() {
        this.hookletPool.clear();
        Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
    }

    public <H extends Hooklet> H remove(H hooklet) {
        return (H)this.hookletPool.remove(hooklet);
    }

    public List<Hooklet> getHooks() {
        return new ArrayList<Hooklet>(this.hookletPool.values());
    }

    public void onShutdown() {
        this.hookletPool.values().stream().sorted(Hooklet::compareTo).forEach(h -> h.onShutdown());
    }
}

