/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.errors;

import com.github.lontime.base.commonj.errors.BuiltInsDetector;
import com.github.lontime.base.commonj.errors.ErrorCodeEnum;
import com.github.lontime.base.commonj.errors.ErrorMessage;
import com.github.lontime.base.commonj.errors.spi.ErrorMessageDetector;
import com.github.lontime.shaded.io.helidon.common.serviceloader.HelidonServiceLoader;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;

public final class ErrorTypes {
    private static final Logger log = Logger.getLogger(ErrorTypes.class);
    private static final List<ErrorMessageDetector> DETECTORS;
    private static final ConcurrentHashMap<String, Optional<ErrorMessage>> CACHE;

    private ErrorTypes() {
    }

    public static Optional<ErrorMessage> detectErrorTypeOptional(String code) {
        log.debugf("error code is %s", (Object)code);
        return CACHE.computeIfAbsent(code, it -> DETECTORS.stream().map(mtd -> {
            Optional<ErrorMessage> errorMessage = mtd.resolve(code);
            return errorMessage;
        }).filter(Optional::isPresent).map(Optional::get).findFirst());
    }

    public static Optional<ErrorMessage> detectErrorTypeOptional(ErrorCodeEnum codeEnum) {
        return ErrorTypes.detectErrorTypeOptional(codeEnum.getCode());
    }

    public static ErrorMessage detectErrorType(String code) {
        Optional<ErrorMessage> optional = ErrorTypes.detectErrorTypeOptional(code);
        if (optional.isPresent()) {
            return optional.get();
        }
        return ErrorTypes.detectErrorTypeOptional(ErrorCodeEnum.UNKNOWN).get();
    }

    public static ErrorMessage detectErrorType(ErrorCodeEnum codeEnum) {
        return ErrorTypes.detectErrorType(codeEnum.getCode());
    }

    static {
        CACHE = new ConcurrentHashMap();
        DETECTORS = HelidonServiceLoader.builder(ServiceLoader.load(ErrorMessageDetector.class)).addService((Object)new BuiltInsDetector(), 100100).build().asList();
    }
}

