/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.errors;

import am.ik.yavi.core.ConstraintViolation;
import am.ik.yavi.core.ConstraintViolations;
import com.github.lontime.base.commonj.errors.ErrorCodeEnum;
import com.github.lontime.base.commonj.errors.ErrorTypes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

public class ErrorException
extends RuntimeException {
    private final String code;
    private final Integer statusCode;

    public ErrorException(ErrorCodeEnum codeEnum, String message) {
        super(message);
        this.code = codeEnum.getCode();
        this.statusCode = ErrorTypes.detectErrorType(codeEnum).getStatusCode();
    }

    public ErrorException(String code, String message) {
        super(message);
        this.code = code;
        this.statusCode = ErrorTypes.detectErrorType(code).getStatusCode();
    }

    public ErrorException(String code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
        this.statusCode = ErrorTypes.detectErrorType(code).getStatusCode();
    }

    public String getCode() {
        return this.code;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public static ErrorException from(ErrorCodeEnum errorCodeEnum) {
        return ErrorException.from(errorCodeEnum.getCode());
    }

    public static ErrorException from(String code, Throwable cause) {
        return new ErrorException(code, ErrorTypes.detectErrorType(code).getMessage(), cause);
    }

    public static ErrorException from(ErrorCodeEnum errorCodeEnum, String message) {
        return new ErrorException(errorCodeEnum.getCode(), message);
    }

    public static ErrorException from(ErrorCodeEnum errorCodeEnum, Throwable cause) {
        return ErrorException.from(errorCodeEnum.getCode(), cause);
    }

    public static ErrorException from(ErrorCodeEnum errorCodeEnum, String message, Throwable cause) {
        return new ErrorException(errorCodeEnum.getCode(), message, cause);
    }

    public static ErrorException from(String code) {
        return new ErrorException(code, ErrorTypes.detectErrorType(code).getMessage());
    }

    public static ErrorException invalid(List<ConstraintViolation> violations) {
        String message = violations.stream().map(s -> s.message()).collect(Collectors.joining(";"));
        return new ErrorException(ErrorCodeEnum.ERROR_PARAM, message);
    }

    public static ErrorException invalid(ConstraintViolations violations) {
        String message = violations.stream().map(s -> s.message()).collect(Collectors.joining(";"));
        return new ErrorException(ErrorCodeEnum.ERROR_PARAM, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFullStackTrace(Throwable throwable) {
        Charset charset = StandardCharsets.UTF_8;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = null;
        try {
            ps = new PrintStream((OutputStream)baos, true, charset.name());
            throwable.printStackTrace(ps);
            String string = baos.toString(charset.name());
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            try {
                baos.close();
            }
            catch (IOException iOException) {}
        }
        return "";
    }
}

