/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.domain;

import com.github.lontime.base.commonj.utils.CollectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MetaWhere {
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    private final List<String> wheres;
    private final String joiner;

    public static MetaWhere create() {
        return new MetaWhere(AND);
    }

    public static MetaWhere createOr() {
        return new MetaWhere(OR);
    }

    public MetaWhere(String joiner) {
        this(null, joiner);
    }

    public MetaWhere(String where, String joiner) {
        this.wheres = where == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(where));
        this.joiner = joiner;
    }

    public MetaWhere and() {
        if (this.wheres.isEmpty()) {
            return new MetaWhere(AND);
        }
        return new MetaWhere(this.wheres.stream().collect(Collectors.joining(this.joiner, "(", ")")), AND);
    }

    public MetaWhere or() {
        if (this.wheres.isEmpty()) {
            return new MetaWhere(OR);
        }
        return new MetaWhere(this.wheres.stream().collect(Collectors.joining(this.joiner, "(", ")")), OR);
    }

    public MetaWhere add(String where) {
        this.wheres.add(where);
        return this;
    }

    public MetaWhere eq(String left, Object right) {
        return this.add(left + "=" + this.wrap(right));
    }

    public MetaWhere lt(String left, Object right) {
        return this.add(left + "<" + this.wrap(right));
    }

    public MetaWhere le(String left, Object right) {
        return this.add(left + "<=" + this.wrap(right));
    }

    public MetaWhere gt(String left, Object right) {
        return this.add(left + ">" + this.wrap(right));
    }

    public MetaWhere ge(String left, Object right) {
        return this.add(left + ">=" + this.wrap(right));
    }

    private String wrap(Object right) {
        if (right instanceof String) {
            return "'" + right + "'";
        }
        return right.toString();
    }

    public String getWheres() {
        return this.wheres.stream().collect(Collectors.joining(this.joiner));
    }

    public boolean isEmpty() {
        return CollectionHelper.isEmpty(this.wheres);
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }
}

