/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.domain;

import com.github.lontime.base.commonj.domain.MetaWhere;
import com.github.lontime.base.commonj.utils.CollectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MetaColumn {
    public static MetaColumn ALL = MetaColumn.create().add("*");
    private String table;
    private final List<String> keys;
    private final List<String> names;
    private MetaWhere where = MetaWhere.create();

    public static MetaColumn create() {
        return new MetaColumn();
    }

    private MetaColumn() {
        this.keys = new ArrayList<String>();
        this.names = new ArrayList<String>();
    }

    public MetaColumn table(String name) {
        this.table = name;
        return this;
    }

    public MetaColumn add(String name) {
        this.names.add(name);
        return this;
    }

    public MetaColumn add(Set<String> names) {
        this.names.addAll(names);
        return this;
    }

    public MetaColumn add(List<String> names) {
        this.names.addAll(names);
        return this;
    }

    public MetaColumn add(String name, String alias) {
        this.names.add(name + " " + alias);
        return this;
    }

    public MetaColumn column(String name) {
        return this.add(name);
    }

    public MetaColumn column(String name, String alias) {
        return this.add(name, alias);
    }

    public MetaColumn key(String name) {
        this.keys.add(name);
        return this;
    }

    public MetaColumn where(MetaWhere where) {
        this.where = where;
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public String columns() {
        return this.names.stream().collect(Collectors.joining(","));
    }

    public String queryColumns() {
        if (CollectionHelper.isEmpty(this.names)) {
            return ALL.columns();
        }
        return this.columns();
    }

    public List<String> getQueryColumns() {
        if (CollectionHelper.isEmpty(this.names)) {
            return ALL.getColumns();
        }
        return this.names;
    }

    public List<String> getColumns() {
        return this.names;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public MetaWhere getWhere() {
        return this.where;
    }

    public String wheres() {
        return this.where.getWheres();
    }
}

