/*
 * Decompiled with CFR 0.152.
 */
package com.github.lontime.base.commonj.domain;

import com.github.lontime.base.commonj.errors.ErrorCodeEnum;

public class BaseReceiver {
    private String code;
    private String details;

    public BaseReceiver() {
        this(ErrorCodeEnum.UNKNOWN);
    }

    public BaseReceiver(ErrorCodeEnum codeEnum) {
        this.code = codeEnum.getCode();
    }

    public boolean successful() {
        return ErrorCodeEnum.SUCCESS.getCode().equals(this.code);
    }

    public static <T extends BaseReceiver> T wrapSuccess(T entity) {
        return BaseReceiver.wrap(entity, ErrorCodeEnum.SUCCESS);
    }

    public static <T extends BaseReceiver> T wrap(T entity, ErrorCodeEnum codeEnum) {
        entity.setCode(codeEnum.getCode());
        return entity;
    }

    public String getCode() {
        return this.code;
    }

    public String getDetails() {
        return this.details;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String toString() {
        return "BaseReceiver(super=" + super.toString() + ", code=" + this.getCode() + ", details=" + this.getDetails() + ")";
    }
}

